/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.forms.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.FormTemplateFile;
import net.gopro.selfservice.exceptions.FormException;
import net.gopro.selfservice.exceptions.GoProFormXmlErrorHandler;
import net.gopro.selfservice.forms.util.BaseFormUtil;
import net.gopro.selfservice.forms.util.IFormUtil;
import net.gopro.selfservice.util.SaxReader;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class GoProFormsv2Util
extends BaseFormUtil
implements IFormUtil {
    private static final Logger logger = Logger.getLogger(GoProFormsv2Util.class);

    @Override
    public boolean validateForm(FormTemplateFile ff) throws FormException {
        if (!"true".equals(SelfServiceEngine.getConfig("goproforms.xml.validate"))) {
            logger.warn((Object)"GoPro Forms validation is turned OFF!");
            return true;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(ff.getStream());
        InputStream xsdIn = null;
        try {
            SAXReader reader = SaxReader.createReader();
            ByteArrayInputStream is = new ByteArrayInputStream(ff.getStream());
            Document doc = reader.read((InputStream)is);
            is.close();
            Element root = doc.getRootElement();
            String namespaceURI = root.getNamespaceURI();
            String schemeLocation = null;
            String schemaFile = null;
            if (namespaceURI != null) {
                Node schemaLocationNode = root.selectSingleNode("@xsi:schemaLocation");
                if (schemaLocationNode != null) {
                    schemeLocation = schemaLocationNode.getText();
                    String[] parts = schemeLocation.split(" ");
                    if (parts.length != 2) {
                        throw new FormException("Invalid schema location for template: " + schemeLocation);
                    }
                    schemaFile = parts[1];
                }
            } else {
                throw new FormException("Template is not a GoPro 2.0 form template!");
            }
            if (schemaFile.startsWith("http://")) {
                boolean schemaLocationNode = this.validateDocument(in);
                return schemaLocationNode;
            }
            String internalSchema = "WEB-INF/selfservice/" + schemaFile;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setNamespaceAware(true);
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            xsdIn = SelfServiceEngine.getContext().getResourceAsStream(internalSchema);
            if (xsdIn == null) {
                throw new FormException("The schema file " + internalSchema + " was not found!");
            }
            StreamSource schemaDocument = new StreamSource(xsdIn);
            Schema schema = factory.newSchema(schemaDocument);
            dbf.setSchema(schema);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            builder.setErrorHandler(new GoProFormXmlErrorHandler());
            org.w3c.dom.Document wDoc = builder.parse(in);
            boolean bl = true;
            return bl;
        }
        catch (MalformedURLException ex) {
            throw new FormException(ex);
        }
        catch (SAXException ex) {
            throw new FormException(ex);
        }
        catch (IOException ex) {
            throw new FormException(ex);
        }
        catch (DocumentException ex) {
            throw new FormException((Exception)((Object)ex));
        }
        catch (ParserConfigurationException ex) {
            throw new FormException(ex);
        }
        finally {
            try {
                if (xsdIn != null) {
                    xsdIn.close();
                }
            }
            catch (Exception ex) {
                throw new FormException(ex);
            }
        }
    }

    @Override
    public void cleanForCloning(ApplicationForm form) throws SelfServiceException {
    }
}

