/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.forms.util;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateFile;
import net.gopro.selfservice.data.GoProFormTemplate;
import net.gopro.selfservice.data.LotusFormTemplate;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.exceptions.FormException;
import net.gopro.selfservice.exceptions.FormTemplateException;
import net.gopro.selfservice.forms.util.GoProFormsV1Util;
import net.gopro.selfservice.forms.util.GoProFormsv2Util;
import net.gopro.selfservice.forms.util.IBMFormsUtil;
import net.gopro.selfservice.forms.util.IFormUtil;
import net.gopro.selfservice.util.SaxReader;
import net.gopro.selfservice.util.StringUtil;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class FormsUtil
implements IFormUtil {
    protected static final Logger logger = Logger.getLogger(FormsUtil.class);
    private IFormUtil instance = null;

    private FormsUtil(FormType formType) {
        switch (formType) {
            case GOPRO_FORM_V1: {
                this.instance = new GoProFormsV1Util();
                break;
            }
            case GOPRO_FORM_V2: {
                this.instance = new GoProFormsv2Util();
                break;
            }
            case IBM_FORM: {
                this.instance = new IBMFormsUtil();
            }
        }
    }

    public static FormsUtil getInstance(FormType formType) {
        FormsUtil instance = new FormsUtil(formType);
        return instance;
    }

    public static FormsUtil getInstance(FormTemplate ft) {
        if (ft instanceof LotusFormTemplate) {
            return new FormsUtil(FormType.IBM_FORM);
        }
        if (ft instanceof GoProFormTemplate) {
            double schemaVersion = ft.getSchemaVersion();
            if (schemaVersion >= 1.0 && schemaVersion < 2.0) {
                return new FormsUtil(FormType.GOPRO_FORM_V1);
            }
            if (schemaVersion >= 2.0 && schemaVersion < 3.0) {
                return new FormsUtil(FormType.GOPRO_FORM_V2);
            }
            throw new RuntimeException("Unsupported GoPro Form version: " + schemaVersion);
        }
        throw new RuntimeException("Unsuported Form Template Type: " + ft.getClass().getName());
    }

    public static final void writeFile(String filename, byte[] data) throws IOException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(filename);
            fos.write(data);
        }
    }

    public static double getSchemaVersion(FormTemplateFile file) throws FormException {
        double version = 0.0;
        if (FormTemplateFile.Tag.DATA.equals((Object)file.getTag())) {
            if (FormTemplateFile.Type.XML.equals((Object)file.getType())) {
                Document doc = FormsUtil.createDocument(file.getStream());
                String schema = doc.getRootElement().attributeValue("noNamespaceSchemaLocation");
                if (StringUtil.isValid(schema)) {
                    String regex = "gopro-forms-([0-9]+[.]{0,1}[0-9]*|[0-9]+[.]{0,1}[0-9]+[.]{0,1}[0-9]*).xsd";
                    Matcher matcher = Pattern.compile("gopro-forms-([0-9]+[.]{0,1}[0-9]*|[0-9]+[.]{0,1}[0-9]+[.]{0,1}[0-9]*).xsd").matcher(schema);
                    if (matcher.find()) {
                        String schemaVersion = matcher.group(1);
                        int dotIndex = schemaVersion.indexOf(".");
                        if (dotIndex != schemaVersion.lastIndexOf(".")) {
                            schemaVersion = schemaVersion.substring(0, dotIndex + 1) + schemaVersion.substring(dotIndex).replace(".", "");
                        }
                        if (StringUtil.isValid(schemaVersion)) {
                            version = Double.parseDouble(schemaVersion);
                        }
                    }
                } else {
                    Node schemaLocationNode;
                    Element root = doc.getRootElement();
                    String namespaceURI = root.getNamespaceURI();
                    if (namespaceURI != null && (schemaLocationNode = root.selectSingleNode("@xsi:schemaLocation")) != null && "http://rep.gopro.net/gpf/xml/schemas/".equals(namespaceURI)) {
                        version = 2.0;
                    }
                }
            } else if (FormTemplateFile.Type.XFDL.equals((Object)file.getType())) {
                String schemaVersion;
                Document doc = FormsUtil.createDocument(file.getStream());
                String namespaceURI = doc.getRootElement().getNamespaceURI();
                String regex = "XFDL\\/([0-9]+[.]{0,1}[0-9]*)";
                Matcher matcher = Pattern.compile("XFDL\\/([0-9]+[.]{0,1}[0-9]*)").matcher(namespaceURI);
                if (matcher.find() && StringUtil.isValid(schemaVersion = matcher.group(1))) {
                    version = Double.parseDouble(schemaVersion);
                }
            }
        }
        return version;
    }

    public static final Document getApplicationForm(FormTemplate ft) throws FormException {
        Document doc = null;
        FormTemplateFile file = ft.getFormTemplateFile(FormTemplateFile.Tag.DATA);
        if (file != null && file.getStream() != null) {
            doc = FormsUtil.createDocument(file.getStream());
        }
        return doc;
    }

    public static final Document createDocument(byte[] xmldata) throws FormException {
        try {
            Document doc = null;
            if (xmldata != null && xmldata.length > 0) {
                ByteArrayInputStream in = null;
                SAXReader reader = SaxReader.createReader();
                try {
                    in = new ByteArrayInputStream(xmldata);
                    doc = reader.read((InputStream)in);
                }
                catch (DocumentException ex) {
                    throw new FormException("Could not load document data.", (Exception)((Object)ex));
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException ex) {
                        throw new FormException(ex);
                    }
                }
            }
            return doc;
        }
        catch (SAXException ex) {
            throw new FormException(ex);
        }
    }

    public static final FormTemplateFile getInternalXslFile(FormTemplateFile.Tag fileTag, FormType formType) throws FormTemplateException {
        FormTemplateFile ff = new FormTemplateFile();
        ff.setTag(fileTag);
        ff.setType(FormTemplateFile.Type.XSL);
        switch (fileTag) {
            case EDIT: {
                ff.setFilename("internal-xsl-edit.xsl");
                break;
            }
            case READ: {
                ff.setFilename("internal-xsl-read.xsl");
                break;
            }
            case DATA: {
                throw new FormTemplateException("Only READ or EDIT types are supported");
            }
        }
        ff.setStream(FormsUtil.getInternalXsl(fileTag, formType));
        return ff;
    }

    private static final byte[] getInternalXsl(FormTemplateFile.Tag fileTag, FormType formType) throws FormTemplateException {
        try {
            String filename = "";
            switch (fileTag) {
                case READ: {
                    if (FormType.GOPRO_FORM_V1.equals((Object)formType)) {
                        filename = SelfServiceEngine.getConfig("goproforms.v1.xsl.read");
                        break;
                    }
                    if (!FormType.GOPRO_FORM_V2.equals((Object)formType)) break;
                    filename = SelfServiceEngine.getConfig("goproforms.v2.xsl.read");
                    break;
                }
                case EDIT: {
                    if (FormType.GOPRO_FORM_V1.equals((Object)formType)) {
                        filename = SelfServiceEngine.getConfig("goproforms.v1.xsl.edit");
                        break;
                    }
                    if (!FormType.GOPRO_FORM_V2.equals((Object)formType)) break;
                    filename = SelfServiceEngine.getConfig("goproforms.v2.xsl.edit");
                    break;
                }
                case DATA: {
                    throw new FormTemplateException("The tag DATA is not supported");
                }
            }
            filename = "/WEB-INF/" + filename;
            InputStream in = SelfServiceEngine.getContext().getResourceAsStream(filename);
            if (in == null) {
                throw new FormTemplateException("The internal xsl template " + filename + " could not be loaded.");
            }
            byte[] bytes = new byte[in.available()];
            in.read(bytes);
            in.close();
            return bytes;
        }
        catch (IOException ex) {
            throw new FormTemplateException("An internal xsl template could not be loaded.", ex);
        }
    }

    public static List<MetaData> getSchemaMetadata(FormTemplateFile file) throws FormException {
        ArrayList<MetaData> list = new ArrayList<MetaData>();
        if (FormTemplateFile.Tag.DATA.equals((Object)file.getTag()) && FormTemplateFile.Type.XML.equals((Object)file.getType())) {
            Document doc = FormsUtil.createDocument(file.getStream());
            String schema = doc.getRootElement().attributeValue("noNamespaceSchemaLocation");
            if (StringUtil.isValid(schema)) {
                String schemaVersion;
                String regex = "gopro-forms-([0-9]+[.]{0,1}[0-9]*).xsd";
                Matcher matcher = Pattern.compile("gopro-forms-([0-9]+[.]{0,1}[0-9]*).xsd").matcher(schema);
                if (matcher.find() && StringUtil.isValid(schemaVersion = matcher.group(1))) {
                    MetaData m = new MetaData();
                    m.setKey("schema.version");
                    m.setValue(schemaVersion);
                    list.add(m);
                }
                MetaData m = new MetaData();
                m.setKey("schema.location");
                m.setValue(schema);
                list.add(m);
            } else {
                String schemeLocation;
                String[] schemas;
                Node schemaLocationNode;
                Element root = doc.getRootElement();
                String namespaceURI = root.getNamespaceURI();
                if (namespaceURI != null && (schemaLocationNode = root.selectSingleNode("@xsi:schemaLocation")) != null && "http://rep.gopro.net/gpf/xml/schemas/".equals(namespaceURI) && (schemas = (schemeLocation = schemaLocationNode.getText()).split(" ")) != null && schemas.length == 2) {
                    MetaData m = new MetaData();
                    m.setKey("schema.version");
                    m.setValue("2.0");
                    list.add(m);
                    m = new MetaData();
                    m.setKey("schema.location");
                    m.setValue(schemas[1]);
                    list.add(m);
                }
            }
        }
        return list;
    }

    @Override
    public boolean validateForm(FormTemplateFile ff) throws FormException {
        return this.instance.validateForm(ff);
    }

    @Override
    public void cleanForCloning(ApplicationForm form) throws SelfServiceException {
        this.instance.cleanForCloning(form);
    }

    public static enum FormType {
        GOPRO_FORM_V1,
        GOPRO_FORM_V2,
        IBM_FORM;

    }
}

