/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.filters;

import java.util.Date;
import net.gopro.selfservice.util.StringUtil;

public class RoutingLogFilter {
    private Date startDate;
    private Date endDate;
    private String organizationId;
    private DeliveryStatus status = DeliveryStatus.ALL;
    private RouteStatus routeStatus = RouteStatus.ALL;
    private boolean isBrokerFilter = false;

    public RoutingLogFilter(Date startDate, Date endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        if (StringUtil.isValid(organizationId) && organizationId.length() == 32) {
            this.organizationId = organizationId;
        }
    }

    public DeliveryStatus getStatus() {
        return this.status;
    }

    public void setStatus(DeliveryStatus status) {
        this.status = status;
    }

    public void setStatus(String status) {
        try {
            this.status = DeliveryStatus.valueOf(status.toUpperCase());
        }
        catch (Exception ex) {
            this.status = DeliveryStatus.ALL;
        }
    }

    public RouteStatus getRouteStatus() {
        return this.routeStatus;
    }

    public void setRouteStatus(RouteStatus routeStatus) {
        this.routeStatus = routeStatus;
    }

    public boolean isBrokerFilter() {
        return this.isBrokerFilter;
    }

    public void setBrokerFilter(boolean isBrokerFilter) {
        this.isBrokerFilter = isBrokerFilter;
    }

    public static enum RouteStatus {
        ALL,
        INCOMING,
        OUTGOING;

    }

    public static enum DeliveryStatus {
        ALL,
        SENT,
        NOTSENT;

    }
}

