/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.datastore;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ServiceCache {
    private static final Logger logger = Logger.getLogger(ServiceCache.class);
    private static Map<String, Object> cache = new HashMap<String, Object>();

    public static void add(String objectId, Object object) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Adding Object %s with key \"%s\" to the service cache.", object.getClass().getName(), objectId));
        }
        cache.put(objectId, object);
    }

    public static <T> T get(String objectId, Class<T> c) {
        if (cache.containsKey(objectId)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Get Object %s with key \"%s\"from cache.", c.getName(), objectId));
            }
            return (T)cache.get(objectId);
        }
        return null;
    }

    public static boolean contains(String objectId) {
        return cache.containsKey(objectId);
    }

    public static boolean remove(String objectId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Requesting removal from cache. Object id \"%s\".", objectId));
        }
        if (cache.containsKey(objectId)) {
            cache.remove(objectId);
            return true;
        }
        return false;
    }
}

