/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.datastore;

import java.io.IOException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.gopro.Endpoint;
import net.gopro.selfservice.datastore.RESTDataStore;
import net.gopro.selfservice.exceptions.GoProDataStoreException;
import org.glassfish.jersey.client.ClientConfig;
import org.json.JSONObject;

public class GoProNetRestDataStore
extends RESTDataStore {
    public void filter(ClientRequestContext context) throws IOException {
    }

    @Override
    public String getInfo() {
        return "GoPro.NET REST Datastore";
    }

    @Override
    protected Response authenticate(Organization org) throws GoProDataStoreException {
        Endpoint ep = org.getEndpoint();
        if (ep == null) {
            throw new GoProDataStoreException("No Endpoint is defined with the organization");
        }
        try {
            ClientConfig config = new ClientConfig();
            Client client = ClientBuilder.newClient((Configuration)config);
            WebTarget target = client.target(ep.getHostname());
            JSONObject job = new JSONObject();
            job.put("_type", (Object)"UserCredentialsType");
            job.put("username", (Object)ep.getUsername());
            job.put("password", (Object)ep.getPassword());
            Form form = new Form();
            form.param("credentials", job.toString());
            Entity entity = Entity.form((Form)form);
            Response response = target.path("Client/Access/Login").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).accept(new String[]{"application/json"}).post(entity);
            if (response.getStatus() == 200) {
                return response;
            }
            throw new GoProDataStoreException("Invalid user/pass, response from server: " + response.getStatus());
        }
        catch (Exception ex) {
            throw new GoProDataStoreException(ex);
        }
    }
}

