/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data.targetgroup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.gopro.gdf.data.AddressType;
import net.gopro.gdf.data.BinaryFilterExpressionType;
import net.gopro.gdf.data.ContactType;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.DocumentCollectionType;
import net.gopro.gdf.data.DocumentFilterType;
import net.gopro.gdf.data.FilterExpressionType;
import net.gopro.gdf.data.FlexibleDataRowType;
import net.gopro.gdf.data.FlexibleDataSetType;
import net.gopro.gdf.data.IndividualType;
import net.gopro.gdf.data.MetaDataType;
import net.gopro.gdf.data.types.DeleteStatusType;
import net.gopro.gdf.data.types.DocumentStateType;
import net.gopro.gdf.data.types.FilterOperatorType;
import net.gopro.gdf.data.types.HiddenStatusType;
import net.gopro.gdf.exceptions.GdfServiceException;
import net.gopro.gdf.ws.proxy.DocumentService;
import net.gopro.selfservice.ITargetGroupGenerator;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.DirectoryUser;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.gopro.RemoteGoPro;
import net.gopro.selfservice.data.targetgroup.TargetGroup;
import net.gopro.selfservice.exceptions.TargetGroupException;
import net.gopro.selfservice.services.ConfigService;
import org.apache.log4j.Logger;

public class GoProPortalGroupGenerator
implements ITargetGroupGenerator {
    private static final String BASE = "services/DocumentService";
    private static final String TARGETGROUP_CATEGORY_KEY = "ClientGroups";
    private static final Logger logger = Logger.getLogger(GoProPortalGroupGenerator.class);
    private String organizationName;
    private String targetGroupName;

    @Override
    public List<DirectoryUser> getAudience(TargetGroup group) throws TargetGroupException {
        try {
            Organization org = this.getOrganization();
            ArrayList<DirectoryUser> list = new ArrayList<DirectoryUser>();
            DocumentService service = this.getService(org);
            List<DocumentBaseType> clients = this.getClients(service);
            for (DocumentBaseType doc : clients) {
                DirectoryUser user = new DirectoryUser();
                if (doc instanceof IndividualType) {
                    IndividualType ind = (IndividualType)doc;
                    user.setFullName(ind.getSubject());
                    user.setSsn(ind.getIDNumber());
                    for (MetaDataType m : ind.getMetaDataEntries()) {
                        if (!m.getName().equalsIgnoreCase("SelfServiceId")) continue;
                        user.setSelfServiceUserId(m.getValue());
                    }
                    if (ind.getEmailAddressesCount() > 0) {
                        user.setEmail(ind.getEmailAddress(0));
                    }
                    if (ind.getOrganizationUnit() != null) {
                        user.setOrganization(ind.getOrganizationUnit().getName());
                    }
                    if (ind.getAddressesCount() > 0) {
                        AddressType address = ind.getAddress(0);
                        user.setCity(address.getCity());
                        user.setPostcode(address.getPostCode());
                        user.setStreetName(address.getStreetName());
                        user.setStreetNumber(address.getStreetNumber());
                        if (address.getCountry() != null) {
                            user.setCountryCode(address.getCountry().getName());
                        }
                    }
                } else if (doc instanceof ContactType) {
                    ContactType contact = (ContactType)doc;
                    user.setFullName(contact.getSubject());
                    user.setSsn(contact.getIDNumber());
                    for (MetaDataType m : contact.getMetaDataEntries()) {
                        if (!m.getName().equalsIgnoreCase("SelfServiceId")) continue;
                        user.setSelfServiceUserId(m.getValue());
                    }
                    if (contact.getEmailAddressesCount() > 0) {
                        user.setEmail(contact.getEmailAddress(0));
                    }
                    if (contact.getOrganizationUnit() != null) {
                        user.setOrganization(contact.getOrganizationUnit().getName());
                    }
                }
                list.add(user);
            }
            return list;
        }
        catch (SelfServiceException ex) {
            throw new TargetGroupException(ex);
        }
        catch (GdfServiceException ex) {
            throw new TargetGroupException((Exception)((Object)ex));
        }
    }

    @Override
    public void getAudienceCallback(List<User> userList) throws TargetGroupException {
        Iterator<User> it = userList.iterator();
        while (it.hasNext()) {
            if (!it.next().isDeleted()) continue;
            it.remove();
        }
    }

    @Override
    public String getInfo() {
        return "GoPro Portal specified Client Groups";
    }

    @Override
    public Properties getPropertes() throws TargetGroupException {
        Properties p = new Properties();
        p.put("organization", "The organization name or alias");
        p.put("targetgroup", "The Client Group name in GoPro Portal");
        return p;
    }

    @Override
    public void setProperties(Properties prop) throws TargetGroupException {
        try {
            this.organizationName = prop.getProperty("organization");
            if (this.organizationName == null) {
                throw new TargetGroupException("The parameter \"organization\" is missing");
            }
            List<Organization> list = ConfigService.getOrganizations();
            boolean isValid = false;
            for (Organization o : list) {
                if (!o.getSubject().equalsIgnoreCase(this.organizationName) && !o.getAlias().equals(this.organizationName)) continue;
                isValid = true;
                if (o.getEndpoint().getGoproType().equals((Object)RemoteGoPro.GoPro.GOPRO_PORTAL)) continue;
                throw new TargetGroupException("Target GoPro must be of type GoPro Portal");
            }
            if (!isValid) {
                throw new TargetGroupException("The parameter \"organization\" is not correct. No organization by that name or alias was found.");
            }
            this.targetGroupName = prop.getProperty("targetgroup");
            if (this.targetGroupName == null) {
                throw new TargetGroupException("The parameter \"targetgroup\" is missing");
            }
        }
        catch (SelfServiceException ex) {
            throw new TargetGroupException(ex);
        }
    }

    private final Organization getOrganization() throws TargetGroupException {
        try {
            Organization org = null;
            List<Organization> organizationList = ConfigService.getOrganizations();
            for (Organization organization : organizationList) {
                if (!organization.getSubject().equalsIgnoreCase(this.organizationName) && !organization.getAlias().equalsIgnoreCase(this.organizationName)) continue;
                org = organization;
                break;
            }
            if (org == null) {
                throw new TargetGroupException("The specified organization (" + this.organizationName + ") was not found!");
            }
            if (!org.getEndpoint().getGoproType().equals((Object)RemoteGoPro.GoPro.GOPRO_PORTAL)) {
                throw new TargetGroupException("Target GoPro must be of type GoPro Portal");
            }
            return org;
        }
        catch (SelfServiceException ex) {
            throw new TargetGroupException(ex);
        }
    }

    private DocumentService getService(Organization org) throws SelfServiceException {
        String documentServiceUrl = org.getEndpoint().getHostname();
        String authUsername = org.getEndpoint().getUsername();
        String authPassword = org.getEndpoint().getPassword();
        if (documentServiceUrl == null) {
            throw new SelfServiceException("GoPro Service Url is missing for the organization!");
        }
        if (authUsername == null) {
            throw new SelfServiceException("GoPro username is missing for the organization!");
        }
        if (authPassword == null) {
            throw new SelfServiceException("GoPro password is missing for the organization!");
        }
        documentServiceUrl = documentServiceUrl + BASE;
        return new DocumentService(documentServiceUrl, authUsername, authPassword, false);
    }

    private List<DocumentBaseType> getClients(DocumentService service) throws GdfServiceException, TargetGroupException {
        ArrayList<DocumentBaseType> clientList = new ArrayList<DocumentBaseType>();
        String targetGroupId = this.getTargetGroupId(service);
        if (targetGroupId == null) {
            throw new TargetGroupException("No Contact Group was found with the name: " + this.targetGroupName);
        }
        DocumentFilterType filter = new DocumentFilterType();
        filter.setID("00000000-0000-0000-0000-000000000000");
        filter.setSubject("");
        filter.setDocumentFormType(1006);
        filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
        filter.setHiddenStatus(HiddenStatusType.NOTHIDDEN);
        BinaryFilterExpressionType bf = new BinaryFilterExpressionType();
        bf.setOperator(FilterOperatorType.EQUAL);
        bf.setPropertyName("_groups[CategoryRefType]._ID");
        bf.setValue((Object)targetGroupId);
        filter.setCustomFilter((FilterExpressionType)bf);
        DocumentCollectionType docs = service.getDocuments(filter, DocumentStateType.UNCHANGED);
        logger.debug((Object)("Client count from GoPro mathing critera :" + docs.getDocumentsCount()));
        for (DocumentBaseType doc : docs.getDocuments()) {
            if (!(doc instanceof IndividualType) && !(doc instanceof ContactType)) continue;
            logger.debug((Object)("Adding " + doc.getClass().getSimpleName() + " : " + doc.getSubject()));
            clientList.add(doc);
        }
        return clientList;
    }

    private String getTargetGroupId(DocumentService service) throws GdfServiceException {
        DocumentFilterType filter = new DocumentFilterType();
        filter.setID("00000000-0000-0000-0000-000000000000");
        filter.setSubject("");
        filter.setDocumentFormType(1013);
        filter.setDeleteStatus(DeleteStatusType.NOTDELETED);
        filter.setHiddenStatus(HiddenStatusType.NOTHIDDEN);
        filter.setLoadDefaultColumns(false);
        filter.setLoadColumns(Arrays.asList("_key"));
        String rootCategoryId = null;
        FlexibleDataSetType categories = service.getDocumentHeaders(filter);
        if (categories != null && categories.getData() != null) {
            for (FlexibleDataRowType row : categories.getData().getRows()) {
                if (!row.getColumnValue(0).equals(TARGETGROUP_CATEGORY_KEY)) continue;
                rootCategoryId = row.getID();
                break;
            }
        }
        if (rootCategoryId != null) {
            filter.setLoadColumns(Arrays.asList("_subject"));
            filter.addFilterParentID(rootCategoryId);
            FlexibleDataSetType headers = service.getDocumentHeaders(filter);
            if (headers != null && headers.getData() != null && headers.getData().getRowsCount() > 0) {
                for (FlexibleDataRowType row : headers.getData().getRows()) {
                    String groupName = row.getColumnValue(0);
                    if (!groupName.equalsIgnoreCase(this.targetGroupName)) continue;
                    return row.getID();
                }
            }
        }
        return null;
    }
}

