/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data.routing;

import java.sql.ResultSet;
import java.sql.SQLException;
import net.gopro.selfservice.data.gopro.RemoteGoPro;
import net.gopro.selfservice.data.routing.RoutingQueueEntry;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.StringUtil;
import org.dom4j.Element;

public class RoutingQueueInformationEntry
extends RoutingQueueEntry {
    protected String userId;
    protected String fullname;
    protected String organizationName;
    protected String detailedDocumentType;
    protected String subject;
    protected String goproType;

    public RoutingQueueInformationEntry() {
    }

    public RoutingQueueInformationEntry(ResultSet rs) throws SQLException {
        super(rs);
        this.userId = rs.getString("uid");
        this.fullname = rs.getString("fullname");
        this.organizationName = rs.getString("organizationName");
        this.detailedDocumentType = rs.getString("dtype");
        this.subject = rs.getString("docname");
        this.goproType = rs.getString("gopro");
    }

    public String getUserId() {
        return this.userId;
    }

    public String getFullname() {
        return this.fullname;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    private RemoteGoPro.GoPro getGoProType() {
        try {
            return RemoteGoPro.GoPro.valueOf(this.goproType);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public Element getXml() {
        Element el = super.getXml();
        Dom4JUtil.addElement(el, "fullname", this.fullname);
        Dom4JUtil.addElement(el, "user_id", this.userId);
        Dom4JUtil.addElement(el, "document_type", this.detailedDocumentType);
        Dom4JUtil.addElement(el, "organization", this.organizationName);
        Dom4JUtil.addElement(el, "subject", this.subject);
        Dom4JUtil.addElement(el, "subject_short", StringUtil.shortenText(this.subject, 20));
        RemoteGoPro.GoPro goProType = this.getGoProType();
        if (goProType != null) {
            Dom4JUtil.addElement(el, "gopro", RemoteGoPro.getDataStoreTitle(goProType));
        }
        return el;
    }
}

