/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data.routing;

import java.sql.ResultSet;
import java.sql.SQLException;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.util.Dom4JUtil;
import org.dom4j.Element;

public class RoutingQueueEntry
extends BaseDocument {
    protected String localDocumentId;
    protected String organizationId;
    protected DocumentType documentType;
    protected boolean isProcessed = false;
    protected boolean isResend = false;
    private int iterationCount;

    public RoutingQueueEntry() {
    }

    public RoutingQueueEntry(String documentId, String organizationId, DocumentType documentType) {
        this.localDocumentId = documentId;
        this.organizationId = organizationId;
        this.documentType = documentType;
        this.isProcessed = false;
        this.iterationCount = 0;
    }

    public RoutingQueueEntry(ResultSet rs) throws SQLException {
        super(rs);
        this.documentId = rs.getString("queue_id");
        this.localDocumentId = rs.getString("document_id");
        this.organizationId = rs.getString("organization_id");
        this.isProcessed = rs.getInt("is_processed") == 1;
        this.documentType = DocumentType.valueOf(rs.getString("doctype"));
        this.iterationCount = rs.getInt("iteration");
    }

    public String getDocumentId() {
        return this.localDocumentId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public boolean isProcessed() {
        return this.isProcessed;
    }

    public boolean isResend() {
        return this.isResend;
    }

    public void setResend(boolean isResend) {
        this.isResend = isResend;
    }

    public final void markProcessed() {
        this.isProcessed = true;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public void incrementIterationCount() {
        ++this.iterationCount;
    }

    @Override
    public Element getXml() {
        Element el = super.getBaseXml("queue");
        Dom4JUtil.addElement(el, "type", this.documentType.toString());
        Dom4JUtil.addElement(el, "is_processed", String.valueOf(this.isProcessed));
        Dom4JUtil.addElement(el, "iteration", String.valueOf(this.iterationCount));
        Dom4JUtil.addElement(el, "local_id", this.localDocumentId);
        Dom4JUtil.addElement(el, "organization_id", this.organizationId);
        return el;
    }

    public static enum DocumentType {
        CASE,
        SUBDOCUMENT,
        CONTACT;

    }
}

