/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data.routing;

import java.sql.ResultSet;
import java.sql.SQLException;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.routing.RoutingQueueEntry;
import org.dom4j.Element;

public class BrokerRelationEntry
extends BaseDocument {
    private String queueId;
    private String transactionId;
    private String goproId;
    private String organizationId;
    private boolean isCompleted;
    private int iterationCount;

    public BrokerRelationEntry() {
    }

    public BrokerRelationEntry(RoutingQueueEntry entry, String transactionId) {
        this.documentId = entry.getDocumentId();
        this.organizationId = entry.getOrganizationId();
        this.queueId = entry.getId();
        this.transactionId = transactionId;
        this.iterationCount = 0;
        this.isCompleted = false;
    }

    public BrokerRelationEntry(ResultSet rs) throws SQLException {
        super(rs);
        this.documentId = rs.getString("document_id");
        this.queueId = rs.getString("queue_id");
        this.goproId = rs.getString("gopro_id");
        this.organizationId = rs.getString("organization_id");
        this.transactionId = rs.getString("transaction_id");
        this.iterationCount = rs.getInt("iteration");
        this.isCompleted = rs.getInt("is_completed") == 1;
    }

    public String getGoproId() {
        return this.goproId;
    }

    public void setGoproId(String goproId) {
        this.goproId = goproId;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void setCompleted(boolean isCompleted) {
        this.isCompleted = isCompleted;
    }

    public String getQueueId() {
        return this.queueId;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public final void incrementIterationCount() {
        ++this.iterationCount;
    }

    @Override
    public Element getXml() {
        Element el = super.getBaseXml("brokerrelation");
        return el;
    }
}

