/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data.routing;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import net.gopro.selfservice.data.routing.RoutingQueueInformationEntry;
import net.gopro.selfservice.util.LocaleUtil;
import org.dom4j.Element;

public class BrokerQueueInformationEntry
extends RoutingQueueInformationEntry {
    private boolean isCompleted;
    private long dateDelivered = 0L;
    private long dateInBroker = 0L;

    public BrokerQueueInformationEntry() {
    }

    public BrokerQueueInformationEntry(ResultSet rs) throws SQLException {
        super(rs);
        this.isCompleted = rs.getInt("is_completed") == 1;
        Timestamp tsd = rs.getTimestamp("in_broker");
        Timestamp tsf = rs.getTimestamp("in_gopro");
        if (tsd != null) {
            this.dateInBroker = tsd.getTime();
        }
        if (tsf != null) {
            this.dateDelivered = tsf.getTime();
        }
    }

    @Override
    public Element getXml() {
        Element el = super.getXml();
        DateFormat df = LocaleUtil.getTimeFormat();
        if (this.dateInBroker > 0L) {
            el.addElement("inbroker").setText(df.format(this.dateInBroker));
            el.addElement("inbroker_alt").setText(LocaleUtil.formatDate(this.dateInBroker));
        }
        if (this.dateDelivered > 0L) {
            el.addElement("delivered").setText(df.format(this.dateDelivered));
            el.addElement("delivered_alt").setText(LocaleUtil.formatDate(this.dateDelivered));
        }
        el.addElement("is_completed").setText(String.valueOf(this.isCompleted));
        return el;
    }
}

