/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.util.Dom4JUtil;
import org.dom4j.Element;

public class UserRole
extends BaseDocument {
    public static final String CITIZEN = "D82C9C303767DFE8AA6BF50DCF119748";
    public static final String ADMINISTRATOR = "A2AAC04696D89CBC6C56EF934F892410";
    public static final String DESIGNER = "A2AAC04696D89CBC6C56EF934F892411";
    public static final String EDITOR = "A2AAC04696D89CBC6C56EF934F892412";
    public static final String CLOUDMANAGER = "00DD3C9F86ABC8D80000012B10B69DA1";
    private String subject;
    private String description;

    public UserRole() {
    }

    public UserRole(ResultSet rs) throws SQLException {
        super(rs);
        this.documentId = rs.getString("role_id");
        this.subject = rs.getString("rolename");
        this.description = rs.getString("description");
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Element getXml() {
        Element el = this.getBaseXml("userrole");
        Dom4JUtil.addElement(el, "subject", this.subject);
        Dom4JUtil.addCDATAElement(el, "description", this.description);
        Dom4JUtil.addElement(el, "is_system", String.valueOf(UserRole.isSystemRole(this.documentId)));
        return el;
    }

    public static final boolean isSystemRole(String roleId) {
        List<String> sysRoles = Arrays.asList(ADMINISTRATOR, DESIGNER, EDITOR, CITIZEN, CLOUDMANAGER);
        return sysRoles.contains(roleId);
    }

    public static final boolean isPrivilegedRole(String roleId) {
        return Arrays.asList(ADMINISTRATOR, DESIGNER, EDITOR).contains(roleId);
    }
}

