/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.LocaleUtil;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class MetaData
extends BaseDocument {
    private String referenceId;
    private String userId;
    private String key;
    private String value;
    private boolean isDirty = false;

    public MetaData() {
    }

    public MetaData(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public MetaData(String key, String value, String userId) {
        this.key = key;
        this.value = value;
        this.userId = userId;
    }

    public MetaData(ResultSet rs) throws SQLException {
        super(rs);
        this.documentId = rs.getString("metadata_id");
        this.referenceId = rs.getString("document_id");
        this.userId = rs.getString("user_id");
        this.key = rs.getString("datakey");
        this.value = rs.getString("datavalue");
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    @Override
    public Element getXml() {
        Element el = DocumentHelper.createElement((String)"metadata");
        DateFormat df = LocaleUtil.getTimeFormat();
        el.addAttribute("id", this.documentId);
        Dom4JUtil.addElement(el, "reference_id", this.referenceId);
        Dom4JUtil.addElement(el, "user_id", this.userId);
        Dom4JUtil.addElement(el, "key", this.key);
        Dom4JUtil.addCDATAElement(el, "value", this.value);
        el.addElement("deleted").setText(String.valueOf(this.isDeleted));
        el.addElement("created").setText(df.format(this.dateCreated));
        el.addElement("modified").setText(df.format(this.dateModified));
        return el;
    }
}

