/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.util.Dom4JUtil;
import org.apache.commons.io.FileUtils;
import org.dom4j.Element;

public final class FormTemplateFile
extends BaseDocument {
    private String filename;
    private Type type;
    private Tag tag;
    private byte[] stream;
    private boolean isDirty = false;

    public FormTemplateFile() {
    }

    public FormTemplateFile(String id, String filename, Type type, Tag tag) {
        this.documentId = id;
        this.filename = filename;
        this.type = type;
        this.tag = tag;
    }

    public FormTemplateFile(String id, String filename, Type type, Tag tag, byte[] stream) {
        this.documentId = id;
        this.filename = filename;
        this.type = type;
        this.tag = tag;
        this.stream = stream;
    }

    public FormTemplateFile(ResultSet rs) throws SQLException {
        super(rs);
        this.documentId = rs.getString("file_id");
        this.filename = rs.getString("filename");
        this.type = Type.valueOf(rs.getString("type").toUpperCase());
        this.tag = Tag.valueOf(rs.getString("tag").toUpperCase());
    }

    public final String getFilename() {
        return this.filename;
    }

    public final void setFilename(String filename) {
        this.filename = filename;
    }

    public final Tag getTag() {
        return this.tag;
    }

    public final void setTag(Tag tag) {
        this.tag = tag;
    }

    public final Type getType() {
        return this.type;
    }

    public final void setType(Type type) {
        this.type = type;
    }

    public final byte[] getStream() {
        return this.stream;
    }

    public final void setStream(byte[] stream) {
        this.stream = stream;
    }

    @Override
    public final boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public final void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
    }

    @Override
    public Element getXml() {
        Element el = this.getBaseXml("formtemplatefile");
        el.addElement("filename").setText(this.filename);
        el.addElement("tag").setText(this.tag.toString());
        el.addElement("type").setText(this.type.toString());
        if (this.getStream() != null) {
            Dom4JUtil.addElement(el, "filesize", FileUtils.byteCountToDisplaySize((long)this.stream.length));
        }
        return el;
    }

    public static enum Tag {
        DATA,
        READ,
        EDIT;

    }

    public static enum Type {
        XFDL,
        XML,
        XSL;

    }
}

