/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import is.hugvit.util.UID;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.gopro.selfservice.util.Dom4JUtil;
import org.apache.commons.io.FileUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class EmailAttachment {
    private String attachmentId;
    private String emailId;
    private String fileName;
    private long fileSize;
    private String mimeType;
    private byte[] stream;

    public EmailAttachment() {
        this.attachmentId = UID.getUID();
    }

    public EmailAttachment(ResultSet rs) throws SQLException {
        this.attachmentId = rs.getString("attachment_id");
        this.emailId = rs.getString("email_id");
        this.fileName = rs.getString("filename");
        this.fileSize = rs.getLong("filesize");
        this.mimeType = rs.getString("mimetype");
    }

    public String getAttachmentId() {
        return this.attachmentId;
    }

    public String getEmailId() {
        return this.emailId;
    }

    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public byte[] getStream() {
        return this.stream;
    }

    public void setStream(byte[] stream) {
        this.stream = stream;
    }

    public Element getXml() {
        Element el = DocumentHelper.createElement((String)"attachment");
        Dom4JUtil.addElement(el, "id", this.attachmentId);
        Dom4JUtil.addElement(el, "emailId", this.emailId);
        Dom4JUtil.addElement(el, "filename", this.fileName);
        Dom4JUtil.addElement(el, "filesize", Long.toString(this.fileSize));
        Dom4JUtil.addElement(el, "humanfilesize", FileUtils.byteCountToDisplaySize((long)this.fileSize));
        Dom4JUtil.addElement(el, "mimetype", this.mimeType);
        return el;
    }
}

