/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.util.Dom4JUtil;
import org.dom4j.Element;

public class Contact
extends BaseDocument {
    protected String userId;
    protected String companyId;
    protected String assignedById;
    protected boolean isManager = false;
    protected boolean isConfirmed = false;
    protected String email;
    protected String companyName;
    protected String assignedByName;

    public Contact() {
    }

    public Contact(String userId, String companyId) {
        this.userId = userId;
        this.companyId = companyId;
    }

    public Contact(ResultSet rs) throws SQLException {
        super(rs);
        this.documentId = rs.getString("contact_id");
        this.userId = rs.getString("user_id");
        this.companyId = rs.getString("company_id");
        this.assignedById = rs.getString("assignedby_id");
        this.isConfirmed = rs.getInt("is_confirmed") == 1;
        this.isManager = rs.getInt("is_manager") == 1;
        this.email = rs.getString("email");
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        if (email != null) {
            this.email = email.toLowerCase();
            this.isDirty = true;
        }
    }

    public boolean isManager() {
        return this.isManager;
    }

    public void setManager(boolean isManager) {
        this.isManager = isManager;
    }

    public boolean isConfirmed() {
        return this.isConfirmed;
    }

    public void setConfirmed(boolean isConfirmed) {
        this.isConfirmed = isConfirmed;
    }

    public String getAssignedById() {
        return this.assignedById;
    }

    public void setAssignedById(String assignedById) {
        this.assignedById = assignedById;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getAssignedByName() {
        return this.assignedByName;
    }

    public void setAssignedByName(String assignedByName) {
        this.assignedByName = assignedByName;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public Element getXml() {
        Element el = super.getBaseXml("contact");
        Dom4JUtil.addElement(el, "user_id", this.userId);
        Dom4JUtil.addElement(el, "company_id", this.companyId);
        Dom4JUtil.addElement(el, "companyname", this.companyName);
        Dom4JUtil.addElement(el, "email", this.email);
        Dom4JUtil.addElement(el, "assignedby_id", this.assignedById);
        Dom4JUtil.addElement(el, "assignee", this.assignedByName);
        Dom4JUtil.addElement(el, "is_manager", String.valueOf(this.isManager));
        Dom4JUtil.addElement(el, "is_confirmed", String.valueOf(this.isConfirmed));
        return el;
    }
}

