/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import is.hugvit.util.UID;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class CheckoutTicket {
    private String ticketId;
    private String documentId;
    private String userId;
    private String checkedOutByUser = null;
    private long dateCheckedOut;
    private long dateCheckedIn;
    private boolean checkoutSuccess = false;

    public CheckoutTicket() {
        this.ticketId = UID.getUID();
        this.dateCheckedOut = new Date().getTime();
    }

    public CheckoutTicket(String documentId, String userId) {
        this.ticketId = UID.getUID();
        this.documentId = documentId;
        this.userId = userId;
        this.dateCheckedOut = new Date().getTime();
    }

    public CheckoutTicket(ResultSet rs) throws SQLException {
        this.ticketId = rs.getString("ticket_id");
        this.documentId = rs.getString("document_id");
        this.userId = rs.getString("user_id");
        this.dateCheckedOut = rs.getTimestamp("checkout").getTime();
        Timestamp tsCheckedIn = rs.getTimestamp("checkin");
        if (tsCheckedIn != null) {
            this.dateCheckedIn = tsCheckedIn.getTime();
        }
    }

    public String getTicketId() {
        return this.ticketId;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getCheckedOutByUser() {
        return this.checkedOutByUser;
    }

    public void setCheckedOutByUser(String checkedOutByUser) {
        this.checkedOutByUser = checkedOutByUser;
    }

    public long getDateCheckedOut() {
        return this.dateCheckedOut;
    }

    public long getDateCheckedIn() {
        return this.dateCheckedIn;
    }

    public void setDateCheckedIn(long dateCheckedIn) {
        this.dateCheckedIn = dateCheckedIn;
    }

    public boolean isCheckedIn() {
        return this.dateCheckedIn > 0L;
    }

    public boolean isCheckedOut() {
        return this.dateCheckedIn == 0L;
    }

    public boolean isCheckoutSuccess() {
        return this.checkoutSuccess;
    }

    public void setCheckoutSuccess(boolean checkoutSuccess) {
        this.checkoutSuccess = checkoutSuccess;
    }
}

