/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.util.Dom4JUtil;
import net.gopro.selfservice.util.LocaleUtil;
import org.dom4j.Element;

public class Announcement
extends BaseDocument {
    private String subject;
    private String body;
    private boolean isInternal;
    private boolean isEmail;
    private String targetGroupId;
    private int recipientCount;
    private long dateSent;
    private String targetgroupName;
    private boolean isCompanyAnnouncement = false;

    public Announcement() {
    }

    public Announcement(ResultSet rs) throws SQLException {
        super(rs);
        this.documentId = rs.getString("announcement_id");
        this.targetGroupId = rs.getString("targetgroup_id");
        this.subject = rs.getString("subject");
        this.body = rs.getString("body");
        this.isInternal = rs.getInt("is_internal") == 1;
        this.isEmail = rs.getInt("is_email") == 1;
        this.recipientCount = rs.getInt("recipientcount");
        this.targetgroupName = rs.getString("groupname");
        Timestamp ts = rs.getTimestamp("sent");
        if (ts != null) {
            this.dateSent = ts.getTime();
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public boolean isEmail() {
        return this.isEmail;
    }

    public String getTargetGroupId() {
        return this.targetGroupId;
    }

    public String getTargetgroupName() {
        return this.targetgroupName;
    }

    public int getRecipientCount() {
        return this.recipientCount;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setInternal(boolean isInternal) {
        this.isInternal = isInternal;
    }

    public void setEmail(boolean isEmail) {
        this.isEmail = isEmail;
    }

    public void setTargetGroupId(String targetGroupId) {
        this.targetGroupId = targetGroupId;
    }

    public void setRecipientCount(int recipientCount) {
        this.recipientCount = recipientCount;
    }

    public boolean isSent() {
        return this.dateSent > 0L;
    }

    public boolean isCompanyAnnouncement() {
        return this.isCompanyAnnouncement;
    }

    public void setCompanyAnnouncement(boolean isCompanyAnnouncement) {
        this.isCompanyAnnouncement = isCompanyAnnouncement;
    }

    public long getDateSent() {
        return this.dateSent;
    }

    public void setDateSent(long dateSent) {
        this.dateSent = dateSent;
    }

    @Override
    public Element getXml() {
        Element el = super.getBaseXml("announcement");
        Dom4JUtil.addElement(el, "subject", this.subject);
        Dom4JUtil.addCDATAElement(el, "body", this.body);
        Dom4JUtil.addElement(el, "is_email", String.valueOf(this.isEmail));
        Dom4JUtil.addElement(el, "is_internal", String.valueOf(this.isInternal));
        Dom4JUtil.addElement(el, "recipientcount", String.valueOf(this.recipientCount));
        Dom4JUtil.addElement(el, "targetgroup_id", this.targetGroupId);
        Dom4JUtil.addElement(el, "targetgroupname", this.targetgroupName);
        Dom4JUtil.addElement(el, "is_sent", String.valueOf(this.isSent()));
        Dom4JUtil.addElement(el, "is_company", String.valueOf(this.isCompanyAnnouncement));
        if (this.isSent()) {
            DateFormat df = LocaleUtil.getTimeFormat();
            el.addElement("sent").setText(df.format(this.dateSent));
            el.addElement("sent_alt").setText(LocaleUtil.formatDate(this.dateSent));
        }
        return el;
    }
}

