/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import net.gopro.selfservice.data.Reference;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class AccessControl {
    private String documentId;
    private String entityId;
    private AccessControlType entityType;
    private int bitmask;
    private Reference entityReference;

    public AccessControl(String documentId, String entityId, AccessControlType entityType) {
        this(documentId, entityId);
        this.entityType = entityType;
    }

    public AccessControl(String documentId, String entityId) {
        this.entityType = AccessControlType.USER;
        this.documentId = documentId;
        this.entityId = entityId;
    }

    public AccessControl() {
        this.entityType = AccessControlType.USER;
    }

    public AccessControl(ResultSet rs) throws SQLException {
        this.documentId = rs.getString("document_id");
        this.entityId = rs.getString("entity_id");
        this.entityType = AccessControlType.from(rs.getInt("entity_type"));
        this.bitmask = rs.getInt("bitmask");
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public AccessControlType getEntityType() {
        return this.entityType;
    }

    public int getBitmask() {
        return this.bitmask;
    }

    public void setBitmask(int mask) {
        this.bitmask = mask;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public void setEntityType(AccessControlType entityType) {
        this.entityType = entityType;
    }

    public Reference getEntityReference() {
        return this.entityReference;
    }

    public void setEntityReference(Reference entityReference) {
        this.entityReference = entityReference;
    }

    public Element getXml() {
        Element el = DocumentHelper.createElement((String)"acl");
        el.addElement("type").setText(this.entityType.toString());
        el.addElement("id").setText(this.entityId);
        el.addElement("accessmask").setText(String.valueOf(this.bitmask));
        if (this.entityReference != null && this.entityReference.getName() != null) {
            el.addElement("name").setText(this.entityReference.getName());
        }
        return el;
    }

    public static enum AccessControlType {
        USER(1),
        GROUP(2),
        COMPANY(3),
        ROLE(4);

        private int value;

        private AccessControlType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static AccessControlType from(int value) {
            switch (value) {
                case 1: {
                    return USER;
                }
                case 2: {
                    return GROUP;
                }
                case 3: {
                    return COMPANY;
                }
                case 4: {
                    return ROLE;
                }
            }
            throw new RuntimeException("Invalid Access Control Type value");
        }
    }

    public static enum Permission {
        NONE(0),
        READ(1),
        WRITE(2);

        private int value;

        private Permission(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

