/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.dalc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import net.gopro.selfservice.dalc.BaseDalc;
import net.gopro.selfservice.data.Task;

public class TaskDalc
extends BaseDalc {
    private static final String TBL_TASKS = "ss_tasks";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTask(Task task) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"task_id", "parent_id", "topparent_id", "responsible_id", "createdby_id", "modifiedby_id", "startedby_id", "completedby_id", "status", "priority_id", "category_id", "subject", "description", "startdate", "completed", "deadline", "is_deleted", "created", "modified"};
        String sql = this.createInsertSQL(TBL_TASKS, cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, task.getId());
            stmt.setString(2, task.getParentId());
            stmt.setString(3, task.getTopParentId());
            stmt.setString(4, task.getResponsibleId());
            stmt.setString(5, task.getCreatedById());
            stmt.setString(6, task.getModifiedById());
            stmt.setString(7, task.getStartedById());
            stmt.setString(8, task.getCompletedById());
            stmt.setInt(9, task.getStatus().getCode());
            stmt.setString(10, task.getPriorityId());
            stmt.setString(11, task.getCategoryId());
            stmt.setString(12, task.getSubject());
            stmt.setString(13, task.getDescription());
            stmt.setTimestamp(14, new Timestamp(task.getStartDate()));
            if (task.getCompletedDate() > 0L) {
                stmt.setTimestamp(15, new Timestamp(task.getCompletedDate()));
            } else {
                stmt.setNull(15, 93);
            }
            if (task.getDeadline() > 0L) {
                stmt.setTimestamp(16, new Timestamp(task.getDeadline()));
            } else {
                stmt.setNull(16, 93);
            }
            stmt.setInt(17, task.isDeleted() ? 1 : 0);
            stmt.setTimestamp(18, new Timestamp(task.getDateCreated()));
            stmt.setTimestamp(19, new Timestamp(task.getDateModified()));
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTask(Task task) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"parent_id", "topparent_id", "responsible_id", "modifiedby_id", "startedby_id", "completedby_id", "status", "priority_id", "category_id", "subject", "description", "startdate", "completed", "deadline", "is_deleted", "modified", "task_id"};
        String sql = this.createUpdateSQL(TBL_TASKS, cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, task.getParentId());
            stmt.setString(2, task.getTopParentId());
            stmt.setString(3, task.getResponsibleId());
            stmt.setString(4, task.getModifiedById());
            stmt.setString(5, task.getStartedById());
            stmt.setString(6, task.getCompletedById());
            stmt.setInt(7, task.getStatus().getCode());
            stmt.setString(8, task.getPriorityId());
            stmt.setString(9, task.getCategoryId());
            stmt.setString(10, task.getSubject());
            stmt.setString(11, task.getDescription());
            if (task.getStartDate() > 0L) {
                stmt.setTimestamp(12, new Timestamp(task.getStartDate()));
            } else {
                stmt.setNull(12, 93);
            }
            if (task.getCompletedDate() > 0L) {
                stmt.setTimestamp(13, new Timestamp(task.getCompletedDate()));
            } else {
                stmt.setNull(13, 93);
            }
            if (task.getDeadline() > 0L) {
                stmt.setTimestamp(14, new Timestamp(task.getDeadline()));
            } else {
                stmt.setNull(14, 93);
            }
            stmt.setInt(15, task.isDeleted() ? 1 : 0);
            stmt.setTimestamp(16, new Timestamp(task.getDateModified()));
            stmt.setString(17, task.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task getTask(String taskId) throws SQLException {
        Task task;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Task task2 = null;
        String sql = "SELECT t.task_id, t.parent_id, t.topparent_id, t.responsible_id, u.fullname AS responsibleName, t.createdby_id, t.modifiedby_id, t.startedby_id, t.completedby_id, t.status, t.priority_id, t.category_id, t.subject, t.description, t.startdate, t.completed, t.deadline, t.is_deleted, t.created, t.modified, l1.subject AS priorityName, l2.subject AS categoryName FROM ss_tasks t LEFT OUTER JOIN ss_listitems l1 ON l1.item_id = t.priority_id LEFT OUTER JOIN ss_listitems l2 ON l2.item_id = t.category_id LEFT OUTER JOIN ss_users u ON u.user_id = t.responsible_id WHERE t.task_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, taskId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                task2 = new Task(rs);
                task2.setPrioritySubject(rs.getString("priorityName"));
                task2.setCategorySubject(rs.getString("categoryName"));
                task2.setResponsibleName(rs.getString("responsibleName"));
            }
            rs.close();
            task = task2;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Task> getTasksByResponsibleUser(String responsibleUserId) throws SQLException {
        ArrayList<Task> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Task> list = new ArrayList<Task>();
        String sql = "SELECT t.task_id, t.parent_id, t.topparent_id, t.responsible_id, u.fullname AS responsibleName, t.createdby_id, t.modifiedby_id, t.startedby_id, t.completedby_id, t.status, t.priority_id, t.category_id, t.subject, t.description, t.startdate, t.completed, t.deadline, t.is_deleted, t.created, t.modified, l1.subject AS priorityName, l2.subject AS categoryName FROM ss_tasks t LEFT OUTER JOIN ss_listitems l1 ON l1.item_id = t.priority_id LEFT OUTER JOIN ss_listitems l2 ON l2.item_id = t.category_id LEFT OUTER JOIN ss_users u ON u.user_id = t.responsible_id WHERE t.responsible_id = ? ";
        try {
            con = this.getConnection();
            boolean isMSSQL = "Microsoft SQL Server".equalsIgnoreCase(this.getSqlServiceType(con));
            sql = isMSSQL ? sql + "ORDER BY ISNULL(t.deadline, 0) ASC, t.deadline ASC, t.subject" : sql + "ORDER BY t.deadline IS NULL ASC, t.deadline ASC, t.subject";
            stmt = con.prepareStatement(sql);
            stmt.setString(1, responsibleUserId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                Task task = new Task(rs);
                task.setPrioritySubject(rs.getString("priorityName"));
                task.setCategorySubject(rs.getString("categoryName"));
                task.setResponsibleName(rs.getString("responsibleName"));
                list.add(task);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Task> getTasksByParentDocument(String parentId) throws SQLException {
        ArrayList<Task> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Task> list = new ArrayList<Task>();
        String sql = "SELECT t.task_id, t.parent_id, t.topparent_id, t.responsible_id, u.fullname AS responsibleName, t.createdby_id, t.modifiedby_id, t.startedby_id, t.completedby_id, t.status, t.priority_id, t.category_id, t.subject, t.description, t.startdate, t.completed, t.deadline, t.is_deleted, t.created, t.modified, l1.subject AS priorityName, l2.subject AS categoryName FROM ss_tasks t LEFT OUTER JOIN ss_listitems l1 ON l1.item_id = t.priority_id LEFT OUTER JOIN ss_listitems l2 ON l2.item_id = t.category_id LEFT OUTER JOIN ss_users u ON u.user_id = t.responsible_id WHERE t.parent_id = ? ORDER BY t.deadline, t.subject";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, parentId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                Task task = new Task(rs);
                task.setPrioritySubject(rs.getString("priorityName"));
                task.setCategorySubject(rs.getString("categoryName"));
                task.setResponsibleName(rs.getString("responsibleName"));
                list.add(task);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Task> getTasks() throws SQLException {
        ArrayList<Task> arrayList;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<Task> list = new ArrayList<Task>();
        String sql = "SELECT t.task_id, t.parent_id, t.topparent_id, t.responsible_id, u.fullname AS responsibleName, t.createdby_id, t.modifiedby_id, t.startedby_id, t.completedby_id, t.status, t.priority_id, t.category_id, t.subject, t.description, t.startdate, t.completed, t.deadline, t.is_deleted, t.created, t.modified, l1.subject AS priorityName, l2.subject AS categoryName FROM ss_tasks t LEFT OUTER JOIN ss_listitems l1 ON l1.item_id = t.priority_id LEFT OUTER JOIN ss_listitems l2 ON l2.item_id = t.category_id LEFT OUTER JOIN ss_users u ON u.user_id = t.responsible_id ORDER BY t.deadline, t.subject";
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                Task task = new Task(rs);
                task.setPrioritySubject(rs.getString("priorityName"));
                task.setCategorySubject(rs.getString("categoryName"));
                task.setResponsibleName(rs.getString("responsibleName"));
                list.add(task);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }
}

