/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.dalc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import net.gopro.selfservice.dalc.BaseDalc;
import net.gopro.selfservice.data.targetgroup.TargetGroup;
import net.gopro.selfservice.data.targetgroup.TargetGroupUser;

public class TargetGroupDalc
extends BaseDalc {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTargetGroup(TargetGroup group) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"targetgroup_id", "subject", "description", "generator", "classname", "classparams", "company_id", "runinterval", "is_enabled", "is_deleted", "created", "modified"};
        String sql = this.createInsertSQL("ss_targetgroups", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, group.getId());
            stmt.setString(2, group.getSubject());
            stmt.setString(3, group.getDescription());
            stmt.setString(4, group.getGenerator().toString());
            stmt.setString(5, group.getClassName());
            stmt.setString(6, group.getClassParameters());
            stmt.setString(7, group.getCompanyId());
            stmt.setInt(8, group.getUpdateHourInterval());
            stmt.setInt(9, group.isEnabled() ? 1 : 0);
            stmt.setInt(10, group.isDeleted() ? 1 : 0);
            stmt.setTimestamp(11, new Timestamp(group.getDateCreated()));
            stmt.setTimestamp(12, new Timestamp(group.getDateModified()));
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetGroup getTargetGroup(String targetgroupId) throws SQLException {
        TargetGroup targetGroup;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        TargetGroup group = null;
        String sql = "SELECT t.targetgroup_id, t.subject, t.description, t.generator, t.classname, t.classparams, t.company_id, t.runinterval, t.is_enabled, t.created, t.modified, t.is_deleted,(SELECT COUNT(tu.user_id) FROM ss_targetgroupusers tu INNER JOIN ss_users u ON u.user_id = tu.user_id WHERE tu.targetgroup_id = t.targetgroup_id AND u.is_deleted = 0) AS usercount FROM ss_targetgroups t WHERE t.targetgroup_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, targetgroupId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                group = new TargetGroup(rs);
                group.setTargetGroupUserCount(rs.getInt("usercount"));
            }
            rs.close();
            targetGroup = group;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return targetGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTargetGroup(TargetGroup group) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"subject", "description", "generator", "classname", "classparams", "company_id", "runinterval", "is_enabled", "is_deleted", "modified", "targetgroup_id"};
        String sql = this.createUpdateSQL("ss_targetgroups", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, group.getSubject());
            stmt.setString(2, group.getDescription());
            stmt.setString(3, group.getGenerator().toString());
            stmt.setString(4, group.getClassName());
            stmt.setString(5, group.getClassParameters());
            stmt.setString(6, group.getCompanyId());
            stmt.setInt(7, group.getUpdateHourInterval());
            stmt.setInt(8, group.isEnabled() ? 1 : 0);
            stmt.setInt(9, group.isDeleted() ? 1 : 0);
            stmt.setTimestamp(10, new Timestamp(group.getDateModified()));
            stmt.setString(11, group.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TargetGroup> getTargetGroups() throws SQLException {
        ArrayList<TargetGroup> arrayList;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<TargetGroup> list = new ArrayList<TargetGroup>();
        String sql = "SELECT t.targetgroup_id, t.subject, t.description, t.generator, t.classname, t.classparams, t.company_id, t.runinterval, t.is_enabled, t.created, t.modified, t.is_deleted,(SELECT COUNT(tu.user_id) FROM ss_targetgroupusers tu INNER JOIN ss_users u ON u.user_id = tu.user_id WHERE tu.targetgroup_id = t.targetgroup_id AND u.is_deleted = 0) AS usercount FROM ss_targetgroups t ORDER BY t.subject";
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                TargetGroup group = new TargetGroup(rs);
                group.setTargetGroupUserCount(rs.getInt("usercount"));
                list.add(group);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTargetGroupUser(TargetGroupUser user) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"targetgroup_id", "user_id", "date_in", "rolename"};
        String sql = this.createInsertSQL("ss_targetgroupusers", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, user.getTargetGroupId());
            stmt.setString(2, user.getUserId());
            stmt.setTimestamp(3, new Timestamp(user.getJoinDate()));
            if (user.getRolename() == null) {
                stmt.setNull(4, 12);
            } else {
                stmt.setString(4, user.getRolename());
            }
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TargetGroupUser> getTargetGroupUsers(String targetGroupId) throws SQLException {
        ArrayList<TargetGroupUser> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<TargetGroupUser> list = new ArrayList<TargetGroupUser>();
        String sql = "SELECT e.targetgroup_id, e.user_id, e.date_in, e.rolename, u.fullname, u.email FROM ss_targetgroupusers e INNER JOIN ss_targetgroups t ON t.targetgroup_id = e.targetgroup_id INNER JOIN ss_users u ON u.user_id = e.user_id WHERE t.targetgroup_id = ? AND u.is_deleted = 0";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, targetGroupId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                TargetGroupUser u = new TargetGroupUser(rs);
                u.setFullname(rs.getString("fullname"));
                u.setEmail(rs.getString("email"));
                list.add(u);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateTargetGroupUsers(String groupId, Set<TargetGroupUser> currentUsers, List<String> removedUsers) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        PreparedStatement stmt2 = null;
        try {
            con = this.startTransaction();
            String sql = "DELETE FROM ss_targetgroupusers WHERE targetgroup_id = ? AND user_id = ?";
            stmt = con.prepareStatement(sql);
            for (String userId : removedUsers) {
                stmt.setString(1, groupId);
                stmt.setString(2, userId);
                stmt.addBatch();
            }
            stmt.executeBatch();
            this.commitTransaction();
            con.close();
            con = this.startTransaction();
            String[] cols = new String[]{"targetgroup_id", "user_id", "date_in", "rolename"};
            sql = this.createInsertSQL("ss_targetgroupusers", cols);
            stmt2 = con.prepareStatement(sql);
            for (TargetGroupUser user : currentUsers) {
                stmt2.setString(1, groupId);
                stmt2.setString(2, user.getUserId());
                stmt2.setTimestamp(3, new Timestamp(user.getJoinDate()));
                stmt2.setString(4, user.getRolename());
                stmt2.addBatch();
            }
            stmt2.executeBatch();
            this.commitTransaction();
        }
        catch (BatchUpdateException ex) {
            try {
                con.rollback();
                throw ex;
                catch (SQLException ex2) {
                    con.rollback();
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeStatement(stmt2);
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        this.closeStatement(stmt2);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TargetGroup> getTargetGroupsByUser(String userId) throws SQLException {
        ArrayList<TargetGroup> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<TargetGroup> list = new ArrayList<TargetGroup>();
        String sql = "SELECT t.targetgroup_id, t.subject, t.description, t.generator, t.classname, t.classparams, t.company_id, t.runinterval, t.is_enabled, t.created, t.modified, t.is_deleted FROM ss_targetgroups t INNER JOIN ss_targetgroupusers u ON u.targetgroup_id = t.targetgroup_id WHERE u.user_id = ? AND t.is_enabled = 1 AND t.is_deleted = 0 ORDER BY t.subject";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, userId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                TargetGroup group = new TargetGroup(rs);
                list.add(group);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInTargetGroup(String userId, String targetgroupId) throws SQLException {
        boolean bl;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean isInGroup = false;
        String sql = "SELECT COUNT(e.targetgroup_id) AS counter FROM ss_targetgroupusers e WHERE e.user_id = ? AND e.targetgroup_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, userId);
            stmt.setString(2, targetgroupId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                isInGroup = rs.getInt(1) > 0;
            }
            rs.close();
            bl = isInGroup;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUserFromTargetGroup(String userId, String targetgroupId) throws SQLException {
        boolean bl;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            String sql = "DELETE FROM ss_targetgroupusers WHERE targetgroup_id = ? AND user_id = ?";
            stmt = con.prepareStatement(sql);
            stmt.setString(1, targetgroupId);
            stmt.setString(2, userId);
            bl = stmt.executeUpdate() == 1;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUserToTargetGroup(String userId, String targetgroupId) throws SQLException {
        boolean bl;
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"targetgroup_id", "user_id", "date_in", "rolename"};
        String sql = this.createInsertSQL("ss_targetgroupusers", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, targetgroupId);
            stmt.setString(2, userId);
            stmt.setTimestamp(3, new Timestamp(new Date().getTime()));
            stmt.setNull(4, 12);
            bl = stmt.executeUpdate() == 1;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return bl;
    }
}

