/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.dalc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import net.gopro.selfservice.CaseFactory;
import net.gopro.selfservice.ExternalDocumentFactory;
import net.gopro.selfservice.FormTemplateFactory;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.dalc.BaseDalc;
import net.gopro.selfservice.data.Attachment;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.Case;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.Email;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateExtras;
import net.gopro.selfservice.data.Memo;
import net.gopro.selfservice.data.Message;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.targetgroup.TargetGroup;
import net.gopro.selfservice.filters.DocumentFilter;
import net.gopro.selfservice.filters.DocumentSearchFilter;
import net.gopro.selfservice.filters.MetaDataSearchFilter;

public class SearchDalc
extends BaseDalc {
    private static final String TBL_EXTRAS = "ss_extras";
    private static final String TBL_MESSAGES = "ss_messages";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Memo> searchMemos(DocumentSearchFilter filter, String userContextId) throws SQLException {
        ArrayList<Memo> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Memo> list = new ArrayList<Memo>();
        ArrayList<BaseDalc.FilterParam> paramList = new ArrayList<BaseDalc.FilterParam>();
        String sql = "SELECT m.memo_id, m.case_id, m.parent_id, m.gopro_id, m.createdby_id, m.status_id, m.subject, m.body, m.savecounter, m.responsecount, m.is_sent, m.is_fromgopro, m.is_sensitive,m.is_deleted, m.modified, m.created, m.completed, m.modifiedby_id, m.completedby_id FROM ss_memos m INNER JOIN ss_cases c ON c.case_id = m.case_id WHERE (m.subject LIKE ? OR m.body LIKE ?) ";
        paramList.add(new BaseDalc.FilterParam(12, "%" + filter.getSearchKeyword() + "%"));
        paramList.add(new BaseDalc.FilterParam(12, "%" + filter.getSearchKeyword() + "%"));
        sql = sql + " AND m.memo_id IN " + this.getQuery("acl");
        paramList.add(new BaseDalc.FilterParam(12, userContextId));
        paramList.add(new BaseDalc.FilterParam(12, userContextId));
        paramList.add(new BaseDalc.FilterParam(12, userContextId));
        paramList.add(new BaseDalc.FilterParam(12, userContextId));
        if (filter.getDocumentOwnerId() != null && !filter.getCompanyIds().isEmpty()) {
            sql = sql + " AND (c.createdby_id = ? OR m.createdby_id = ? ";
            paramList.add(new BaseDalc.FilterParam(12, filter.getDocumentOwnerId()));
            paramList.add(new BaseDalc.FilterParam(12, filter.getDocumentOwnerId()));
            for (String companyId : filter.getCompanyIds()) {
                sql = sql + " OR c.company_id = ? ";
                paramList.add(new BaseDalc.FilterParam(12, companyId));
            }
            sql = sql + ")";
        } else if (filter.getDocumentOwnerId() != null) {
            sql = sql + " AND (c.createdby_id = ? OR m.createdby_id = ?)";
            paramList.add(new BaseDalc.FilterParam(12, filter.getDocumentOwnerId()));
            paramList.add(new BaseDalc.FilterParam(12, filter.getDocumentOwnerId()));
        } else if (!filter.getCompanyIds().isEmpty()) {
            if (filter.getCompanyIds().size() == 1) {
                sql = sql + " AND (c.company_id = ?) ";
                paramList.add(new BaseDalc.FilterParam(12, filter.getCompanyIds().get(0)));
            } else {
                sql = sql + " AND ( ";
                for (int i = 0; i < filter.getCompanyIds().size(); ++i) {
                    sql = i == 0 ? sql + " c.company_id = ? " : sql + " OR c.company_id = ? ";
                    paramList.add(new BaseDalc.FilterParam(12, filter.getCompanyIds().get(i)));
                }
                sql = sql + ")";
            }
        }
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            int paramCounter = 1;
            for (BaseDalc.FilterParam param : paramList) {
                stmt.setObject(paramCounter, param.getValue(), param.getDataType());
                ++paramCounter;
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(new Memo(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Email> searchEmails(DocumentSearchFilter filter, String userContextId) throws SQLException {
        ArrayList<Email> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Email> list = new ArrayList<Email>();
        ArrayList<BaseDalc.FilterParam> paramList = new ArrayList<BaseDalc.FilterParam>();
        String sql = "SELECT e.email_id, e.case_id, e.parent_id, e.gopro_id, e.createdby_id, e.status_id, e.subject, e.body, e.fromname, e.fromemail, e.savecounter, e.responsecount, e.is_sent, e.is_sensitive, e.is_fromgopro, e.is_deleted, e.modified, e.created, e.completed, e.modifiedby_id, e.completedby_id FROM ss_emails e INNER JOIN ss_cases c ON c.case_id = e.case_id WHERE (e.subject LIKE ? OR e.body LIKE ? OR e.fromname LIKE ? OR e.fromemail LIKE ?) ";
        paramList.add(new BaseDalc.FilterParam(12, "%" + filter.getSearchKeyword() + "%"));
        paramList.add(new BaseDalc.FilterParam(12, "%" + filter.getSearchKeyword() + "%"));
        paramList.add(new BaseDalc.FilterParam(12, "%" + filter.getSearchKeyword() + "%"));
        paramList.add(new BaseDalc.FilterParam(12, "%" + filter.getSearchKeyword() + "%"));
        sql = sql + " AND e.email_id IN " + this.getQuery("acl");
        paramList.add(new BaseDalc.FilterParam(12, userContextId));
        paramList.add(new BaseDalc.FilterParam(12, userContextId));
        paramList.add(new BaseDalc.FilterParam(12, userContextId));
        paramList.add(new BaseDalc.FilterParam(12, userContextId));
        if (filter.getDocumentOwnerId() != null && !filter.getCompanyIds().isEmpty()) {
            sql = sql + " AND (c.createdby_id = ? OR e.createdby_id = ? ";
            paramList.add(new BaseDalc.FilterParam(12, filter.getDocumentOwnerId()));
            paramList.add(new BaseDalc.FilterParam(12, filter.getDocumentOwnerId()));
            for (String companyId : filter.getCompanyIds()) {
                sql = sql + " OR c.company_id = ? ";
                paramList.add(new BaseDalc.FilterParam(12, companyId));
            }
            sql = sql + ")";
        } else if (filter.getDocumentOwnerId() != null) {
            sql = sql + " AND (c.createdby_id = ? OR e.createdby_id = ?)";
            paramList.add(new BaseDalc.FilterParam(12, filter.getDocumentOwnerId()));
            paramList.add(new BaseDalc.FilterParam(12, filter.getDocumentOwnerId()));
        } else if (!filter.getCompanyIds().isEmpty()) {
            if (filter.getCompanyIds().size() == 1) {
                sql = sql + " AND (c.company_id = ?) ";
                paramList.add(new BaseDalc.FilterParam(12, filter.getCompanyIds().get(0)));
            } else {
                sql = sql + " AND ( ";
                for (int i = 0; i < filter.getCompanyIds().size(); ++i) {
                    sql = i == 0 ? sql + " c.company_id = ? " : sql + " OR c.company_id = ? ";
                    paramList.add(new BaseDalc.FilterParam(12, filter.getCompanyIds().get(i)));
                }
                sql = sql + ")";
            }
        }
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            int paramCounter = 1;
            for (BaseDalc.FilterParam param : paramList) {
                stmt.setObject(paramCounter, param.getValue(), param.getDataType());
                ++paramCounter;
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(new Email(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FormTemplate> searchFormTemplates(DocumentSearchFilter filter) throws SQLException {
        ArrayList<FormTemplate> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<FormTemplate> list = new ArrayList<FormTemplate>();
        ArrayList<BaseDalc.FilterParam> paramList = new ArrayList<BaseDalc.FilterParam>();
        String sql = "SELECT t.template_id, t.subject, t.description, t.category, t.valid_from, t.valid_to, t.is_visible, t.is_postsendfilter, t.is_memos, t.is_attachments, t.is_resend, t.resendstatus_id, t.message_id, t.restriction, t.is_signature, t.is_sensitive, t.is_secondary, t.sec_handle,t.created, t.modified, t.is_deleted, t.classname, t.version, e.targetgroup_id, e.cssfile, e.customclass, e.jscript,e.gopro_agent, e.gopro_alias, e.gopro_subject, e.filecount, e.fee_amount, e.fee_currency FROM ss_formtemplates t INNER JOIN ss_extras e ON t.template_id = e.template_id WHERE t.is_visible = 1 AND (lower(t.subject) LIKE ? OR t.description LIKE ? OR lower(t.category) LIKE ?) ";
        paramList.add(new BaseDalc.FilterParam(12, "%" + filter.getSearchKeyword().toLowerCase() + "%"));
        paramList.add(new BaseDalc.FilterParam(12, "%" + filter.getSearchKeyword() + "%"));
        paramList.add(new BaseDalc.FilterParam(12, "%" + filter.getSearchKeyword().toLowerCase() + "%"));
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            int paramCounter = 1;
            for (BaseDalc.FilterParam param : paramList) {
                stmt.setObject(paramCounter, param.getValue(), param.getDataType());
                ++paramCounter;
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                FormTemplate ft = FormTemplateFactory.getInstance(rs.getString("classname"), rs);
                ft.setExtendedData(new FormTemplateExtras(rs));
                list.add(ft);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BaseCase> searchCases(DocumentSearchFilter filter, Class<? extends BaseDocument> clazz, String userContextId) throws RuntimeException, SQLException {
        ArrayList<BaseCase> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<BaseCase> list = new ArrayList<BaseCase>();
        ArrayList<BaseDalc.FilterParam> paramList = new ArrayList<BaseDalc.FilterParam>();
        String sql = "SELECT c.case_id, c.parent_id, c.createdby_id, c.organization_id, c.formtemplate_id, c.casetemplate_id,c.status_id, c.gopro_id, c.gopro_casenumber, c.reference_number, c.subject, c.body, c.is_sensitive, c.is_sent, c.is_deleted, c.is_fromgopro, c.is_signed, c.is_signaturepending, c.is_reopened, c.is_shared, c.responsecount, c.created, c.modified, c.completed, c.classname, c.targetgroup_id, c.company_id, c.contact_id, c.modifiedby_id, c.completedby_id FROM ss_cases c WHERE c.classname = ? AND (lower(c.subject) LIKE ? OR c.body LIKE ? OR lower(c.gopro_casenumber) LIKE ? OR lower(c.reference_number) LIKE ?) ";
        paramList.add(new BaseDalc.FilterParam(12, clazz.getName()));
        paramList.add(new BaseDalc.FilterParam(12, "%" + filter.getSearchKeyword().toLowerCase() + "%"));
        paramList.add(new BaseDalc.FilterParam(12, "%" + filter.getSearchKeyword() + "%"));
        paramList.add(new BaseDalc.FilterParam(12, "%" + filter.getSearchKeyword().toLowerCase() + "%"));
        paramList.add(new BaseDalc.FilterParam(12, "%" + filter.getSearchKeyword().toLowerCase() + "%"));
        sql = sql + " AND c.case_id IN " + this.getQuery("acl");
        paramList.add(new BaseDalc.FilterParam(12, userContextId));
        paramList.add(new BaseDalc.FilterParam(12, userContextId));
        paramList.add(new BaseDalc.FilterParam(12, userContextId));
        paramList.add(new BaseDalc.FilterParam(12, userContextId));
        if (filter.getDocumentOwnerId() != null || !filter.getTargetgroupIds().isEmpty() || !filter.getCompanyIds().isEmpty()) {
            int i;
            sql = sql + " AND (";
            if (filter.getDocumentOwnerId() != null) {
                sql = sql + " (c.createdby_id = ? AND c.company_id IS NULL) ";
                paramList.add(new BaseDalc.FilterParam(12, filter.getDocumentOwnerId()));
            }
            if (filter.getTargetgroupIds().size() > 0) {
                for (i = 0; i < filter.getTargetgroupIds().size(); ++i) {
                    String groupId = filter.getTargetgroupIds().get(i);
                    sql = sql + " OR c.targetgroup_id = ? ";
                    paramList.add(new BaseDalc.FilterParam(12, groupId));
                }
            }
            if (filter.getCompanyIds().size() > 0) {
                for (i = 0; i < filter.getCompanyIds().size(); ++i) {
                    String companyId = filter.getCompanyIds().get(i);
                    sql = sql + " OR c.company_id = ? ";
                    paramList.add(new BaseDalc.FilterParam(12, companyId));
                }
            }
            sql = sql + " ) ";
        }
        if (filter.getDocumentTemplateId() != null) {
            sql = sql + " AND (c.formtemplate_id = ?) ";
            paramList.add(new BaseDalc.FilterParam(12, filter.getDocumentTemplateId()));
        }
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            int paramCounter = 1;
            for (BaseDalc.FilterParam param : paramList) {
                stmt.setObject(paramCounter, param.getValue(), param.getDataType());
                ++paramCounter;
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(CaseFactory.getInstance(clazz.getName(), rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExternalDocument> searchExternalDocuments(DocumentSearchFilter filter, Class<? extends BaseDocument> clazz, String userContextId) throws SQLException {
        ArrayList<ExternalDocument> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<ExternalDocument> list = new ArrayList<ExternalDocument>();
        ArrayList<BaseDalc.FilterParam> paramList = new ArrayList<BaseDalc.FilterParam>();
        String sql = "SELECT d.document_id, d.case_id, d.parent_id, d.gopro_id, d.createdby_id, d.status_id, d.subject, d.body, d.is_sent, d.is_fromgopro, d.savecounter, d.responsecount, d.filesize, d.filename, d.mimetype, d.is_deleted, d.modified, d.created, d.completed, d.is_sensitive, d.classname, c.formtemplate_id, d.modifiedby_id, d.completedby_id, d.is_signed, d.is_signaturepending FROM ss_documents d INNER JOIN ss_cases c ON c.case_id = d.case_id WHERE d.classname = ? AND (lower(d.subject) LIKE ? OR d.body LIKE ? OR lower(d.filename) LIKE ? OR d.document_id IN ( SELECT m.document_id FROM ss_metadata m WHERE m.document_id = d.document_id AND m.is_deleted = 0 AND m.datavalue LIKE ? ) ) ";
        paramList.add(new BaseDalc.FilterParam(12, clazz.getName()));
        paramList.add(new BaseDalc.FilterParam(12, "%" + filter.getSearchKeyword().toLowerCase() + "%"));
        paramList.add(new BaseDalc.FilterParam(12, "%" + filter.getSearchKeyword() + "%"));
        paramList.add(new BaseDalc.FilterParam(12, "%" + filter.getSearchKeyword().toLowerCase() + "%"));
        paramList.add(new BaseDalc.FilterParam(12, filter.getSearchKeyword().toLowerCase() + "%"));
        sql = sql + " AND d.document_id IN " + this.getQuery("acl");
        paramList.add(new BaseDalc.FilterParam(12, userContextId));
        paramList.add(new BaseDalc.FilterParam(12, userContextId));
        paramList.add(new BaseDalc.FilterParam(12, userContextId));
        paramList.add(new BaseDalc.FilterParam(12, userContextId));
        if (filter.getDocumentOwnerId() != null && !filter.getCompanyIds().isEmpty()) {
            sql = sql + " AND (c.createdby_id = ? OR d.createdby_id = ? ";
            paramList.add(new BaseDalc.FilterParam(12, filter.getDocumentOwnerId()));
            paramList.add(new BaseDalc.FilterParam(12, filter.getDocumentOwnerId()));
            for (String arrayList2 : filter.getCompanyIds()) {
                sql = sql + " OR c.company_id = ? ";
                paramList.add(new BaseDalc.FilterParam(12, arrayList2));
            }
            sql = sql + ")";
        } else if (filter.getDocumentOwnerId() != null) {
            sql = sql + " AND (c.createdby_id = ? OR d.createdby_id = ?)";
            paramList.add(new BaseDalc.FilterParam(12, filter.getDocumentOwnerId()));
            paramList.add(new BaseDalc.FilterParam(12, filter.getDocumentOwnerId()));
        } else if (!filter.getCompanyIds().isEmpty()) {
            if (filter.getCompanyIds().size() == 1) {
                sql = sql + " AND (c.company_id = ?) ";
                paramList.add(new BaseDalc.FilterParam(12, filter.getCompanyIds().get(0)));
            } else {
                sql = sql + " AND ( ";
                for (int i = 0; i < filter.getCompanyIds().size(); ++i) {
                    sql = i == 0 ? sql + " c.company_id = ? " : sql + " OR c.company_id = ? ";
                    paramList.add(new BaseDalc.FilterParam(12, filter.getCompanyIds().get(i)));
                }
                sql = sql + ")";
            }
        }
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            int paramCounter = 1;
            for (BaseDalc.FilterParam param : paramList) {
                stmt.setObject(paramCounter, param.getValue(), param.getDataType());
                ++paramCounter;
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                String string = rs.getString("classname");
                ExternalDocument doc = ExternalDocumentFactory.getInstance(string, rs);
                list.add(doc);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, Hashtable<String, String>> getFormTemplateMapping() throws SQLException {
        Hashtable<String, Hashtable<String, String>> hashtable;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        Hashtable<String, Hashtable<String, String>> ht = new Hashtable<String, Hashtable<String, String>>();
        String sql = "SELECT l.template_id, l.organization_id, l.link_id FROM ss_formlinks l ORDER BY l.template_id";
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                Hashtable<Object, Object> map;
                String templateId = rs.getString("template_id");
                String organizationId = rs.getString("organization_id");
                String linkToken = rs.getString("link_id");
                if (ht.containsKey(templateId)) {
                    map = ht.get(templateId);
                    map.put(organizationId, linkToken);
                    continue;
                }
                map = new Hashtable();
                map.put(organizationId, linkToken);
                ht.put(templateId, map);
            }
            rs.close();
            hashtable = ht;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> searchMessages(DocumentSearchFilter filter, String userContextId) throws SQLException {
        ArrayList<Message> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Message> list = new ArrayList<Message>();
        String sql = "SELECT m.message_id, m.recipient_id, m.createdby_id, m.parent_id, m.subject, m.body, m.sender, m.is_read, m.is_deleted, m.created, m.modified FROM ss_messages m WHERE m.recipient_id = ? AND m.is_deleted = 0 AND (m.subject LIKE ? OR m.body LIKE ?)";
        String searchString = "%" + filter.getSearchKeyword() + "%";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, userContextId);
            stmt.setString(2, searchString);
            stmt.setString(3, searchString);
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(new Message(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BaseCase> getCases(DocumentFilter filter, Class<? extends BaseDocument> clazz) throws SQLException {
        ArrayList<BaseCase> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<BaseCase> list = new ArrayList<BaseCase>();
        ArrayList<BaseDalc.FilterParam> paramList = new ArrayList<BaseDalc.FilterParam>();
        String sql = "SELECT c.case_id, c.parent_id, c.createdby_id, c.organization_id, c.formtemplate_id, c.casetemplate_id,c.status_id, c.gopro_id, c.gopro_casenumber, c.reference_number, c.subject, c.body, c.is_sensitive, c.is_sent, c.is_deleted, c.is_fromgopro, c.is_signed, c.is_signaturepending, c.is_reopened, c.is_shared,  c.responsecount, c.created, c.modified, c.completed, c.classname, c.targetgroup_id, c.company_id, c.contact_id, c.modifiedby_id, c.completedby_id FROM ss_cases c WHERE c.classname = ? ";
        paramList.add(new BaseDalc.FilterParam(12, clazz.getName()));
        if (DocumentFilter.DeletionStatus.NOT_DELETED.equals((Object)filter.getDeletionStatus())) {
            sql = sql + " AND c.is_deleted = 0 ";
        } else if (DocumentFilter.DeletionStatus.DELETED.equals((Object)filter.getDeletionStatus())) {
            sql = sql + " AND c.is_deleted = 1 ";
        }
        HashMap<String, String> queryMap = this.getQueryMap(filter);
        if (queryMap.size() > 0) {
            sql = sql + " AND (";
            ArrayList<String> keyList = new ArrayList<String>(queryMap.keySet());
            for (int i = 0; i < keyList.size(); ++i) {
                String columnKey = keyList.get(i);
                String columnValue = queryMap.get(columnKey);
                sql = sql + columnKey + " = ? ";
                paramList.add(new BaseDalc.FilterParam(12, columnValue));
                if (i >= keyList.size() - 1) continue;
                sql = sql + " AND ";
            }
            sql = sql + ") ";
        }
        if (filter.getCreatedDateFrom() != null || filter.getCreatedDateTo() != null) {
            if (filter.getCreatedDateFrom() != null && filter.getCreatedDateTo() != null) {
                sql = sql + " AND (c.created > ? AND c.created < ?) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getCreatedDateFrom()));
                paramList.add(new BaseDalc.FilterParam(93, filter.getCreatedDateTo()));
            } else if (filter.getCreatedDateFrom() != null) {
                sql = sql + " AND (c.created > ? ) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getCreatedDateFrom()));
            } else if (filter.getCreatedDateTo() != null) {
                sql = sql + " AND (c.created < ? ) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getCreatedDateTo()));
            }
        }
        if (filter.getModifiedDateFrom() != null || filter.getModifiedDateTo() != null) {
            if (filter.getModifiedDateFrom() != null && filter.getModifiedDateTo() != null) {
                sql = sql + " AND (c.modified > ? AND c.modified < ?) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getModifiedDateFrom()));
                paramList.add(new BaseDalc.FilterParam(93, filter.getModifiedDateTo()));
            } else if (filter.getModifiedDateFrom() != null) {
                sql = sql + " AND (c.modified > ? ) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getModifiedDateFrom()));
            } else if (filter.getModifiedDateTo() != null) {
                sql = sql + " AND (c.modified < ? ) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getModifiedDateTo()));
            }
        }
        if (filter.getCompletedDateFrom() != null || filter.getCompletedDateTo() != null) {
            if (filter.getCompletedDateFrom() != null && filter.getCompletedDateTo() != null) {
                sql = sql + " AND (c.completed > ? AND c.completed < ?) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getCompletedDateFrom()));
                paramList.add(new BaseDalc.FilterParam(93, filter.getCompletedDateTo()));
            } else if (filter.getCompletedDateFrom() != null) {
                sql = sql + " AND (c.completed > ? ) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getCompletedDateFrom()));
            } else if (filter.getCompletedDateTo() != null) {
                sql = sql + " AND (c.completed < ? ) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getCompletedDateTo()));
            }
        }
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            int paramCounter = 1;
            for (BaseDalc.FilterParam param : paramList) {
                if (param.getDataType() == 93) {
                    Date date = (Date)param.getValue();
                    stmt.setTimestamp(paramCounter, new Timestamp(date.getTime()));
                } else {
                    stmt.setObject(paramCounter, param.getValue(), param.getDataType());
                }
                ++paramCounter;
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(CaseFactory.getInstance(clazz.getName(), rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Memo> getMemos(DocumentFilter filter) throws SQLException {
        ArrayList<Memo> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Memo> list = new ArrayList<Memo>();
        ArrayList<BaseDalc.FilterParam> paramList = new ArrayList<BaseDalc.FilterParam>();
        String sql = "SELECT m.memo_id, m.case_id, m.parent_id, m.gopro_id, m.createdby_id, m.status_id, m.subject, m.body, m.savecounter, m.responsecount, m.is_sent, m.is_fromgopro, m.is_sensitive, m.is_deleted, m.modified, m.created, m.completed, m.modifiedby_id, m.completedby_id FROM ss_memos m INNER JOIN ss_cases c ON c.case_id = m.case_id WHERE ";
        boolean isStarted = false;
        if (DocumentFilter.DeletionStatus.NOT_DELETED.equals((Object)filter.getDeletionStatus())) {
            sql = sql + " m.is_deleted = 0 AND c.is_deleted = 0 ";
            isStarted = true;
        } else if (DocumentFilter.DeletionStatus.DELETED.equals((Object)filter.getDeletionStatus())) {
            sql = sql + "m.is_deleted = 1 ";
            isStarted = true;
        }
        HashMap<String, String> queryMap = this.getQueryMap(filter);
        if (queryMap.size() > 0) {
            sql = isStarted ? sql + " AND (" : sql + " ( ";
            ArrayList<String> keyList = new ArrayList<String>(queryMap.keySet());
            for (int i = 0; i < keyList.size(); ++i) {
                String columnKey = keyList.get(i);
                String columnValue = queryMap.get(columnKey);
                if (columnKey.equals("c.createdby_id")) {
                    columnKey = "m.createdby_id";
                }
                sql = sql + columnKey + " = ? ";
                paramList.add(new BaseDalc.FilterParam(12, columnValue));
                if (i >= keyList.size() - 1) continue;
                sql = sql + " AND ";
            }
            sql = sql + ") ";
        }
        if (filter.getCreatedDateFrom() != null || filter.getCreatedDateTo() != null) {
            if (filter.getCreatedDateFrom() != null && filter.getCreatedDateTo() != null) {
                sql = sql + " AND (m.created > ? AND m.created < ?) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getCreatedDateFrom()));
                paramList.add(new BaseDalc.FilterParam(93, filter.getCreatedDateTo()));
            } else if (filter.getCreatedDateFrom() != null) {
                sql = sql + " AND (m.created > ? ) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getCreatedDateFrom()));
            } else if (filter.getCreatedDateTo() != null) {
                sql = sql + " AND (m.created < ? ) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getCreatedDateTo()));
            }
        }
        if (filter.getModifiedDateFrom() != null || filter.getModifiedDateTo() != null) {
            if (filter.getModifiedDateFrom() != null && filter.getModifiedDateTo() != null) {
                sql = sql + " AND (m.modified > ? AND m.modified < ?) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getModifiedDateFrom()));
                paramList.add(new BaseDalc.FilterParam(93, filter.getModifiedDateTo()));
            } else if (filter.getModifiedDateFrom() != null) {
                sql = sql + " AND (m.modified > ? ) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getModifiedDateFrom()));
            } else if (filter.getModifiedDateTo() != null) {
                sql = sql + " AND (m.modified < ? ) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getModifiedDateTo()));
            }
        }
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            int paramCounter = 1;
            for (BaseDalc.FilterParam param : paramList) {
                if (param.getDataType() == 93) {
                    Date date = (Date)param.getValue();
                    stmt.setTimestamp(paramCounter, new Timestamp(date.getTime()));
                } else {
                    stmt.setObject(paramCounter, param.getValue(), param.getDataType());
                }
                ++paramCounter;
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(new Memo(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    private HashMap<String, String> getQueryMap(DocumentFilter filter) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (filter.getOwnerId() != null) {
            map.put("c.createdby_id", filter.getOwnerId());
        }
        if (filter.getCompanyId() != null) {
            map.put("c.company_id", filter.getCompanyId());
        }
        if (filter.getFormTemplateId() != null) {
            map.put("c.formtemplate_id", filter.getFormTemplateId());
        }
        if (filter.getCaseTemplateId() != null) {
            map.put("c.casetemplate_id", filter.getCaseTemplateId());
        }
        if (filter.getOrganizationId() != null) {
            map.put("c.organization_id", filter.getOrganizationId());
        }
        if (filter.getTargetgroupId() != null) {
            map.put("c.targetgroup_id", filter.getTargetgroupId());
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Email> getEmails(DocumentFilter filter) throws SQLException {
        ArrayList<Email> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Email> list = new ArrayList<Email>();
        ArrayList<BaseDalc.FilterParam> paramList = new ArrayList<BaseDalc.FilterParam>();
        String sql = "SELECT e.email_id, e.case_id, e.parent_id, e.gopro_id, e.createdby_id, e.status_id, e.subject, e.body, e.fromname, e.fromemail, e.savecounter, e.responsecount, e.is_sent, e.is_sensitive, e.is_fromgopro, e.is_deleted, e.modified, e.created, e.completed, e.modifiedby_id, e.completedby_id FROM ss_emails e INNER JOIN ss_cases c ON c.case_id = e.case_id WHERE ";
        boolean isStarted = false;
        if (DocumentFilter.DeletionStatus.NOT_DELETED.equals((Object)filter.getDeletionStatus())) {
            sql = sql + " e.is_deleted = 0 AND c.is_deleted = 0 ";
            isStarted = true;
        } else if (DocumentFilter.DeletionStatus.DELETED.equals((Object)filter.getDeletionStatus())) {
            sql = sql + "e.is_deleted = 1 ";
            isStarted = true;
        }
        HashMap<String, String> queryMap = this.getQueryMap(filter);
        if (queryMap.size() > 0) {
            sql = isStarted ? sql + " AND (" : sql + " ( ";
            ArrayList<String> keyList = new ArrayList<String>(queryMap.keySet());
            for (int i = 0; i < keyList.size(); ++i) {
                String columnKey = keyList.get(i);
                String columnValue = queryMap.get(columnKey);
                if (columnKey.equals("c.createdby_id")) {
                    columnKey = "e.createdby_id";
                }
                sql = sql + columnKey + " = ? ";
                paramList.add(new BaseDalc.FilterParam(12, columnValue));
                if (i >= keyList.size() - 1) continue;
                sql = sql + " AND ";
            }
            sql = sql + ") ";
        }
        if (filter.getCreatedDateFrom() != null || filter.getCreatedDateTo() != null) {
            if (filter.getCreatedDateFrom() != null && filter.getCreatedDateTo() != null) {
                sql = sql + " AND (e.created > ? AND e.created < ?) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getCreatedDateFrom()));
                paramList.add(new BaseDalc.FilterParam(93, filter.getCreatedDateTo()));
            } else if (filter.getCreatedDateFrom() != null) {
                sql = sql + " AND (e.created > ? ) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getCreatedDateFrom()));
            } else if (filter.getCreatedDateTo() != null) {
                sql = sql + " AND (e.created < ? ) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getCreatedDateTo()));
            }
        }
        if (filter.getModifiedDateFrom() != null || filter.getModifiedDateTo() != null) {
            if (filter.getModifiedDateFrom() != null && filter.getModifiedDateTo() != null) {
                sql = sql + " AND (e.modified > ? AND e.modified < ?) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getModifiedDateFrom()));
                paramList.add(new BaseDalc.FilterParam(93, filter.getModifiedDateTo()));
            } else if (filter.getModifiedDateFrom() != null) {
                sql = sql + " AND (e.modified > ? ) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getModifiedDateFrom()));
            } else if (filter.getModifiedDateTo() != null) {
                sql = sql + " AND (e.modified < ? ) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getModifiedDateTo()));
            }
        }
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            int paramCounter = 1;
            for (BaseDalc.FilterParam param : paramList) {
                if (param.getDataType() == 93) {
                    Date date = (Date)param.getValue();
                    stmt.setTimestamp(paramCounter, new Timestamp(date.getTime()));
                } else {
                    stmt.setObject(paramCounter, param.getValue(), param.getDataType());
                }
                ++paramCounter;
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(new Email(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExternalDocument> getExternalDocuments(DocumentFilter filter, List<Class<? extends BaseDocument>> typeList) throws SQLException {
        ArrayList<ExternalDocument> arrayList;
        HashMap<String, String> queryMap;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<ExternalDocument> list = new ArrayList<ExternalDocument>();
        ArrayList<BaseDalc.FilterParam> paramList = new ArrayList<BaseDalc.FilterParam>();
        String sql = "SELECT d.document_id, d.case_id, d.parent_id, d.gopro_id, d.createdby_id, d.status_id, d.subject, d.body, d.is_sent, d.is_fromgopro, d.savecounter, d.responsecount, d.filesize, d.filename, d.mimetype, d.is_deleted, d.modified, d.created, d.completed, d.classname, c.formtemplate_id, d.modifiedby_id, d.completedby_id, d.is_signed, d.is_signaturepending, d.is_sensitive FROM ss_documents d INNER JOIN ss_cases c ON c.case_id = d.case_id ";
        if (filter.isSigned() && (filter.getSigningCompletedDateFrom() != null || filter.getSigningCompletedDateTo() != null)) {
            sql = sql + "INNER JOIN ss_metadata m ON m.document_id = d.document_id ";
        }
        sql = sql + " WHERE ";
        if (typeList.size() > 0) {
            sql = sql + "(";
            for (int i = 0; i < typeList.size(); ++i) {
                Class<? extends BaseDocument> clazz = typeList.get(i);
                sql = sql + " d.classname = ? ";
                paramList.add(new BaseDalc.FilterParam(12, clazz.getName()));
                if (i >= typeList.size() - 1) continue;
                sql = sql + " OR ";
            }
            sql = sql + ") ";
        }
        if (DocumentFilter.DeletionStatus.NOT_DELETED.equals((Object)filter.getDeletionStatus())) {
            sql = sql + "AND d.is_deleted = 0 AND c.is_deleted = 0 ";
        } else if (DocumentFilter.DeletionStatus.DELETED.equals((Object)filter.getDeletionStatus())) {
            sql = sql + "AND d.is_deleted = 1 ";
        }
        if (filter.isSigned()) {
            sql = sql + "AND d.is_signed = 1 ";
        }
        if ((queryMap = this.getQueryMap(filter)).size() > 0) {
            sql = sql + " AND (";
            ArrayList<String> keyList = new ArrayList<String>(queryMap.keySet());
            for (int i = 0; i < keyList.size(); ++i) {
                String columnKey = keyList.get(i);
                String columnValue = queryMap.get(columnKey);
                if (columnKey.equals("c.createdby_id")) {
                    columnKey = "d.createdby_id";
                }
                sql = sql + columnKey + " = ? ";
                paramList.add(new BaseDalc.FilterParam(12, columnValue));
                if (i >= keyList.size() - 1) continue;
                sql = sql + " AND ";
            }
            sql = sql + ") ";
        }
        if (filter.getCreatedDateFrom() != null || filter.getCreatedDateTo() != null) {
            if (filter.getCreatedDateFrom() != null && filter.getCreatedDateTo() != null) {
                sql = sql + " AND (d.created > ? AND d.created < ?) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getCreatedDateFrom()));
                paramList.add(new BaseDalc.FilterParam(93, filter.getCreatedDateTo()));
            } else if (filter.getCreatedDateFrom() != null) {
                sql = sql + " AND (d.created > ? ) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getCreatedDateFrom()));
            } else if (filter.getCreatedDateTo() != null) {
                sql = sql + " AND (d.created < ? ) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getCreatedDateTo()));
            }
        }
        if (filter.getModifiedDateFrom() != null || filter.getModifiedDateTo() != null) {
            if (filter.getModifiedDateFrom() != null && filter.getModifiedDateTo() != null) {
                sql = sql + " AND (d.modified > ? AND d.modified < ?) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getModifiedDateFrom()));
                paramList.add(new BaseDalc.FilterParam(93, filter.getModifiedDateTo()));
            } else if (filter.getModifiedDateFrom() != null) {
                sql = sql + " AND (d.modified > ? ) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getModifiedDateFrom()));
            } else if (filter.getModifiedDateTo() != null) {
                sql = sql + " AND (d.modified < ? ) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getModifiedDateTo()));
            }
        }
        if (filter.getCompletedDateFrom() != null || filter.getCompletedDateTo() != null) {
            if (filter.getCompletedDateFrom() != null && filter.getCompletedDateTo() != null) {
                sql = sql + " AND (d.completed > ? AND d.completed < ? AND d.is_sent = 1) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getCompletedDateFrom()));
                paramList.add(new BaseDalc.FilterParam(93, filter.getCompletedDateTo()));
            } else if (filter.getCompletedDateFrom() != null) {
                sql = sql + " AND (d.completed > ? AND d.is_sent = 1) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getCompletedDateFrom()));
            } else if (filter.getCompletedDateTo() != null) {
                sql = sql + " AND (d.completed < ? AND d.is_sent = 1) ";
                paramList.add(new BaseDalc.FilterParam(93, filter.getCompletedDateTo()));
            }
        }
        if (filter.getSigningCompletedDateFrom() != null || filter.getSigningCompletedDateTo() != null) {
            if (filter.getSigningCompletedDateFrom() != null && filter.getSigningCompletedDateTo() != null) {
                sql = sql + " AND (m.datakey = ? AND m.datavalue = ? AND m.created > ? AND m.created < ?) ";
                paramList.add(new BaseDalc.FilterParam(12, "Signing.Completed"));
                paramList.add(new BaseDalc.FilterParam(12, Boolean.toString(true)));
                paramList.add(new BaseDalc.FilterParam(93, filter.getSigningCompletedDateFrom()));
                paramList.add(new BaseDalc.FilterParam(93, filter.getSigningCompletedDateTo()));
            } else if (filter.getSigningCompletedDateFrom() != null) {
                sql = sql + " AND (m.datakey = ? AND m.datavalue = ? AND m.created > ?) ";
                paramList.add(new BaseDalc.FilterParam(12, "Signing.Completed"));
                paramList.add(new BaseDalc.FilterParam(12, Boolean.toString(true)));
                paramList.add(new BaseDalc.FilterParam(93, filter.getSigningCompletedDateFrom()));
            } else if (filter.getSigningCompletedDateTo() != null) {
                sql = sql + " AND (m.datakey = ? AND m.datavalue = ? AND  m.created < ?) ";
                paramList.add(new BaseDalc.FilterParam(12, "Signing.Completed"));
                paramList.add(new BaseDalc.FilterParam(12, Boolean.toString(true)));
                paramList.add(new BaseDalc.FilterParam(93, filter.getSigningCompletedDateTo()));
            }
        }
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            int paramCounter = 1;
            for (BaseDalc.FilterParam param : paramList) {
                if (param.getDataType() == 93) {
                    Date date = (Date)param.getValue();
                    stmt.setTimestamp(paramCounter, new Timestamp(date.getTime()));
                } else {
                    stmt.setObject(paramCounter, param.getValue(), param.getDataType());
                }
                ++paramCounter;
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                String className = rs.getString("classname");
                ExternalDocument doc = ExternalDocumentFactory.getInstance(className, rs);
                list.add(doc);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> searchByMetaData(Class<? extends BaseDocument> clazz, MetaDataSearchFilter filter) throws SQLException, SelfServiceException {
        Connection con = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<BaseDalc.FilterParam> paramList = new ArrayList<BaseDalc.FilterParam>();
        boolean isMSSQL = "Microsoft SQL Server".equalsIgnoreCase(this.getSqlServiceType(con));
        String sql = "SELECT m.document_id FROM ss_metadata m ";
        if (clazz.equals(BaseCase.class) || clazz.equals(FormCase.class) || clazz.equals(Case.class)) {
            sql = sql + "INNER JOIN ss_cases x ON x.case_id = m.document_id ";
        } else if (clazz.equals(Memo.class)) {
            sql = sql + "INNER JOIN ss_memos x ON x.memo_id = m.document_id ";
        } else if (clazz.equals(ExternalDocument.class)) {
            sql = sql + "INNER JOIN ss_documents x ON x.document_id = m.document_id ";
        } else if (clazz.equals(Email.class)) {
            sql = sql + "INNER JOIN ss_emails x ON x.email_id = m.document_id ";
        } else if (clazz.equals(User.class)) {
            sql = sql + "INNER JOIN ss_users x ON x.user_id = m.document_id ";
        } else if (clazz.equals(Company.class)) {
            sql = sql + "INNER JOIN ss_companies x ON x.company_id = m.document_id ";
        } else {
            throw new SelfServiceException("Unsupported document type in query");
        }
        if (filter.getMetadataKey() != null && filter.getMetadataValue() != null) {
            boolean useLastParam = true;
            if (isMSSQL) {
                sql = sql + " WHERE m.datakey = ? AND m.datavalue LIKE ? ";
            } else if (MetaDataSearchFilter.FilterOperator.EQUALS.equals((Object)filter.getOperator())) {
                sql = sql + " WHERE m.datakey = ? AND m.datavalue = ? ";
            } else if (MetaDataSearchFilter.FilterOperator.LIKE.equals((Object)filter.getOperator())) {
                sql = sql + " WHERE m.datakey = ? AND m.datavalue LIKE ? ";
            } else if (MetaDataSearchFilter.FilterOperator.ISNULL.equals((Object)filter.getOperator())) {
                sql = sql + " WHERE m.datakey = ? AND m.datavalue IS NULL ";
                useLastParam = false;
            } else if (MetaDataSearchFilter.FilterOperator.ISNOTNULL.equals((Object)filter.getOperator())) {
                sql = sql + " WHERE m.datakey = ? AND m.datavalue IS NOT NULL ";
                useLastParam = false;
            }
            paramList.add(new BaseDalc.FilterParam(12, filter.getMetadataKey()));
            if (useLastParam) {
                paramList.add(new BaseDalc.FilterParam(12, filter.getMetadataValue()));
            }
        } else if (filter.getMetadataKey() != null) {
            sql = sql + " WHERE m.datakey = ? ";
            paramList.add(new BaseDalc.FilterParam(12, filter.getMetadataKey()));
        } else if (filter.getMetadataValue() != null) {
            sql = isMSSQL ? sql + " WHERE m.datavalue LIKE ? " : sql + " WHERE m.datavalue = ? ";
            paramList.add(new BaseDalc.FilterParam(12, filter.getMetadataValue()));
        }
        sql = sql + " AND m.is_deleted = 0 AND x.is_deleted = 0";
        try {
            stmt = con.prepareStatement(sql);
            int paramCounter = 1;
            for (BaseDalc.FilterParam param : paramList) {
                stmt.setObject(paramCounter, param.getValue(), param.getDataType());
                ++paramCounter;
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                String documentId = rs.getString("document_id");
                list.add(documentId);
            }
            rs.close();
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        finally {
            this.closeStatement(stmt);
            this.closeConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BaseDocument> getDocumentsByIds(Class<? extends BaseDocument> clazz, List<String> documentIds) throws SQLException, SelfServiceException {
        ArrayList<BaseDocument> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<BaseDocument> list = new ArrayList<BaseDocument>();
        ArrayList<BaseDalc.FilterParam> paramList = new ArrayList<BaseDalc.FilterParam>();
        String sql = "";
        if (clazz.equals(BaseCase.class) || clazz.equals(FormCase.class) || clazz.equals(Case.class)) {
            sql = "SELECT c.case_id, c.parent_id, c.createdby_id, c.organization_id, c.formtemplate_id, c.casetemplate_id,c.status_id, c.gopro_id, c.gopro_casenumber, c.reference_number, c.subject, c.body, c.is_sensitive, c.is_sent, c.is_deleted, c.is_fromgopro, c.is_signed, c.is_signaturepending, c.is_reopened, c.is_shared, c.responsecount, c.created, c.modified, c.completed, c.classname, c.targetgroup_id, c.company_id, c.contact_id, c.modifiedby_id, c.completedby_id FROM ss_cases c WHERE c.is_deleted = 0 AND " + this.getLookupIds("c.case_id", documentIds, paramList);
        } else if (clazz.equals(Memo.class)) {
            sql = "SELECT m.memo_id, m.case_id, m.parent_id, m.gopro_id, m.createdby_id, m.status_id, m.subject, m.body, m.savecounter, m.responsecount, m.is_sent, m.is_fromgopro, m.is_sensitive,m.is_deleted, m.modified, m.created, m.completed, m.modifiedby_id, m.completedby_id FROM ss_memos m INNER JOIN ss_cases c ON c.case_id = m.case_id WHERE m.is_deleted = 0 AND c.is_deleted = 0 AND " + this.getLookupIds("m.memo_id", documentIds, paramList);
        } else if (clazz.equals(ExternalDocument.class)) {
            sql = "SELECT d.document_id, d.case_id, d.parent_id, d.gopro_id, d.createdby_id, d.status_id, d.subject, d.body, d.is_sent, d.is_fromgopro, d.savecounter, d.responsecount, d.filesize, d.is_sensitive,d.filename, d.mimetype, d.is_deleted, d.is_signed, d.is_signaturepending, d.modified, d.created, d.completed, d.classname, c.formtemplate_id, d.modifiedby_id, d.completedby_id FROM ss_documents d INNER JOIN ss_cases c ON c.case_id = d.case_id WHERE d.is_deleted = 0 AND c.is_deleted = 0 AND " + this.getLookupIds("d.document_id", documentIds, paramList);
        } else if (clazz.equals(Email.class)) {
            sql = "SELECT e.email_id, e.case_id, e.parent_id, e.gopro_id, e.createdby_id, e.status_id, e.subject, e.body, e.fromname, e.fromemail, e.savecounter, e.responsecount, e.is_sent, e.is_fromgopro, e.is_deleted, e.modified, e.created, e.completed, e.is_sensitive, e.modifiedby_id, e.completedby_id FROM ss_emails e INNER JOIN ss_cases c ON c.case_id = e.case_id WHERE  e.is_deleted = 0 AND c.is_deleted = 0 AND " + this.getLookupIds("e.email_id", documentIds, paramList);
        } else {
            throw new SelfServiceException("DocumentType " + clazz.getSimpleName() + " is not supported");
        }
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            int paramCounter = 1;
            for (BaseDalc.FilterParam param : paramList) {
                stmt.setObject(paramCounter, param.getValue(), param.getDataType());
                ++paramCounter;
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                String className;
                if (clazz.equals(BaseCase.class) || clazz.equals(FormCase.class) || clazz.equals(Case.class)) {
                    className = rs.getString("classname");
                    list.add(CaseFactory.getInstance(className, rs));
                    continue;
                }
                if (clazz.equals(Memo.class)) {
                    list.add(new Memo(rs));
                    continue;
                }
                if (clazz.equals(ExternalDocument.class)) {
                    className = rs.getString("classname");
                    ExternalDocument doc = ExternalDocumentFactory.getInstance(className, rs);
                    list.add(doc);
                    continue;
                }
                if (!clazz.equals(Email.class)) continue;
                list.add(new Email(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExternalDocument> getUserDocuments(User user) throws SQLException {
        ArrayList<ExternalDocument> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<ExternalDocument> list = new ArrayList<ExternalDocument>();
        ArrayList<BaseDalc.FilterParam> paramList = new ArrayList<BaseDalc.FilterParam>();
        String sql = "SELECT d.document_id, d.case_id, d.parent_id, d.gopro_id, d.createdby_id, d.status_id, d.subject, d.body, d.is_sent, d.is_fromgopro, d.savecounter, d.responsecount, d.filesize, d.filename, d.mimetype, d.is_deleted, d.modified, d.created, d.completed, d.is_sensitive, d.classname, c.formtemplate_id, d.modifiedby_id, d.completedby_id, d.is_signed, d.is_signaturepending FROM ss_documents d INNER JOIN ss_cases c ON c.case_id = d.case_id WHERE d.is_deleted = 0 AND c.is_deleted = 0 AND d.classname = ? ";
        sql = sql + " AND ( c.createdby_id = ? ";
        paramList.add(new BaseDalc.FilterParam(12, Attachment.class.getName()));
        paramList.add(new BaseDalc.FilterParam(12, user.getId()));
        for (TargetGroup arrayList2 : user.getTargetGroups()) {
            sql = sql + " OR c.targetgroup_id = ? ";
            paramList.add(new BaseDalc.FilterParam(12, arrayList2.getId()));
        }
        for (String string : user.getContactCompanyIds()) {
            sql = sql + " OR c.company_id = ? ";
            paramList.add(new BaseDalc.FilterParam(12, string));
        }
        sql = sql + " ) ";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            int paramCounter = 1;
            for (BaseDalc.FilterParam param : paramList) {
                stmt.setObject(paramCounter, param.getValue(), param.getDataType());
                ++paramCounter;
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                String string = rs.getString("classname");
                ExternalDocument doc = ExternalDocumentFactory.getInstance(string, rs);
                list.add(doc);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    private String getLookupIds(String columnName, List<String> ids, List<BaseDalc.FilterParam> paramList) {
        String sql = "(";
        for (int i = 0; i < ids.size(); ++i) {
            paramList.add(new BaseDalc.FilterParam(12, ids.get(i)));
            sql = i > 0 ? sql + " OR " + columnName + " = ? " : sql + columnName + " = ? ";
        }
        sql = sql + ")";
        return sql;
    }

    static {
        queryPathMap.put(SearchDalc.class.getSimpleName(), "search");
    }
}

