/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.dalc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.gopro.selfservice.IQueueEngine;
import net.gopro.selfservice.dalc.BaseDalc;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.Memo;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.routing.BrokerRelationEntry;
import net.gopro.selfservice.data.routing.IncomingInformationEntry;
import net.gopro.selfservice.data.routing.PickUpQueueEntry;
import net.gopro.selfservice.data.routing.QueueLogEntry;
import net.gopro.selfservice.data.routing.RoutingQueueEntry;
import net.gopro.selfservice.data.routing.RoutingQueueInformationEntry;
import net.gopro.selfservice.filters.RoutingLogFilter;
import net.gopro.selfservice.util.StringUtil;

public class QueueDalc
extends BaseDalc {
    private static final String TBL_BROKER_RELATION = "ss_brokerrelations";
    private static final String TBL_QUEUELOG = "ss_queuelog";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRoutingQueueEntry(RoutingQueueEntry entry) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"queue_id", "document_id", "organization_id", "doctype", "iteration", "is_processed", "is_deleted", "created", "modified"};
        String sql = this.createInsertSQL("ss_queue", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, entry.getId());
            stmt.setString(2, entry.getDocumentId());
            stmt.setString(3, entry.getOrganizationId());
            stmt.setString(4, entry.getDocumentType().toString());
            stmt.setInt(5, entry.getIterationCount());
            stmt.setInt(6, entry.isProcessed() ? 1 : 0);
            stmt.setInt(7, entry.isDeleted() ? 1 : 0);
            stmt.setTimestamp(8, new Timestamp(entry.getDateCreated()));
            stmt.setTimestamp(9, new Timestamp(entry.getDateModified()));
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDocumentInQueue(String documentId) throws SQLException {
        boolean bl;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean inQueue = false;
        String sql = "SELECT COUNT(document_id) AS counter FROM ss_queue WHERE document_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, documentId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                inQueue = rs.getInt("counter") == 1;
            }
            rs.close();
            bl = inQueue;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return bl;
    }

    public boolean removeRoutingQueueEntry(String queueId) throws SQLException {
        boolean bl;
        Connection con = null;
        PreparedStatement stmt = null;
        boolean isRemoved = false;
        String[] cols = new String[]{"modified", "is_processed", "queue_id"};
        String sql = this.createUpdateSQL("ss_queue", cols);
        try {
            con = this.startTransaction();
            stmt = con.prepareStatement(sql);
            stmt.setTimestamp(1, new Timestamp(new Date().getTime()));
            stmt.setInt(2, 1);
            stmt.setString(3, queueId);
            isRemoved = stmt.executeUpdate() > 0;
            this.commitTransaction();
            bl = isRemoved;
        }
        catch (SQLException ex) {
            try {
                con.rollback();
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RoutingQueueEntry> getRoutingQueue() throws SQLException {
        ArrayList<RoutingQueueEntry> arrayList;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<RoutingQueueEntry> list = new ArrayList<RoutingQueueEntry>();
        String sql = "SELECT q.queue_id, q.document_id, q.organization_id, q.doctype, q.iteration, q.is_processed, q.is_deleted, q.created, q.modified FROM ss_queue q WHERE q.is_processed = 0 AND q.is_deleted = 0 ORDER BY q.created DESC, q.doctype";
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                list.add(new RoutingQueueEntry(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoutingQueueEntry getRoutingQueueEntry(String queueId) throws SQLException {
        RoutingQueueEntry routingQueueEntry;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        RoutingQueueEntry entry = null;
        String sql = "SELECT q.queue_id, q.document_id, q.organization_id, q.doctype, q.iteration, q.is_processed, q.is_deleted, q.created, q.modified FROM ss_queue q WHERE q.is_deleted = 0 AND q.queue_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, queueId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                entry = new RoutingQueueEntry(rs);
            }
            rs.close();
            routingQueueEntry = entry;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return routingQueueEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RoutingQueueEntry> findEntries(String documentId) throws SQLException {
        ArrayList<RoutingQueueEntry> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<RoutingQueueEntry> list = new ArrayList<RoutingQueueEntry>();
        String sql = "SELECT q.queue_id, q.document_id, q.organization_id, q.doctype, q.iteration, q.is_processed, q.is_deleted, q.created, q.modified FROM ss_queue q WHERE q.document_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, documentId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(new RoutingQueueEntry(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    public boolean createCaseRelation(String documentId, String goproDocumentId, String goproCaseId) throws SQLException {
        boolean bl;
        Connection con = null;
        PreparedStatement stmt = null;
        boolean isUpdated = false;
        String[] cols = new String[]{"gopro_id", "gopro_casenumber", "case_id"};
        String sql = this.createUpdateSQL("ss_cases", cols);
        try {
            con = this.startTransaction();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, goproDocumentId);
            if (goproCaseId != null) {
                stmt.setString(2, goproCaseId);
            } else {
                stmt.setNull(2, 12);
            }
            stmt.setString(3, documentId);
            isUpdated = stmt.executeUpdate() > 0;
            this.commitTransaction();
            bl = isUpdated;
        }
        catch (SQLException ex) {
            try {
                con.rollback();
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return bl;
    }

    public boolean createSubDocumentRelation(String queueId, String documentId, String remoteGoProId) throws SQLException {
        boolean bl;
        Connection con = null;
        PreparedStatement stmt = null;
        boolean isUpdated = false;
        String documentType = this.getSubdocumentType(queueId);
        if (documentType == null) {
            throw new IllegalArgumentException("Could not find subdocument for queue: " + queueId);
        }
        String tableName = "ss_documents";
        String columnName = "document_id";
        if ("Memo".equals(documentType)) {
            tableName = "ss_memos";
            columnName = "memo_id";
        } else if ("Email".equals(documentType)) {
            tableName = "ss_emails";
            columnName = "email_id";
        }
        String[] cols = new String[]{"gopro_id", columnName};
        String sql = this.createUpdateSQL(tableName, cols);
        try {
            con = this.startTransaction();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, remoteGoProId);
            stmt.setString(2, documentId);
            isUpdated = stmt.executeUpdate() > 0;
            this.commitTransaction();
            bl = isUpdated;
        }
        catch (SQLException ex) {
            try {
                con.rollback();
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRoutingQueueEntry(RoutingQueueEntry entry) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"iteration", "modified", "is_processed", "is_deleted", "queue_id"};
        String sql = this.createUpdateSQL("ss_queue", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setInt(1, entry.getIterationCount());
            stmt.setTimestamp(2, new Timestamp(entry.getDateModified()));
            stmt.setInt(3, entry.isProcessed() ? 1 : 0);
            stmt.setInt(4, entry.isDeleted() ? 1 : 0);
            stmt.setString(5, entry.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RoutingQueueInformationEntry> getRoutingQueueStatus(RoutingLogFilter filter) throws SQLException {
        ArrayList<RoutingQueueInformationEntry> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<RoutingQueueInformationEntry> list = new ArrayList<RoutingQueueInformationEntry>();
        ArrayList<BaseDalc.FilterParam> paramList = new ArrayList<BaseDalc.FilterParam>();
        String sql = "SELECT q.queue_id, q.document_id, q.organization_id, q.doctype, q.iteration, q.is_processed, q.is_deleted, q.created, q.modified, dtype, docname, uid, u.fullname, o.subject AS organizationName, e.type AS gopro  FROM ss_queue q INNER JOIN (SELECT 'CASE' AS dtype, subject AS docname, createdby_id AS uid, case_id AS local_id FROM ss_cases UNION SELECT 'CONTACT' AS dtype, fullname AS docname, user_id AS uid, user_id AS local_id FROM ss_users UNION SELECT 'DOCUMENT' AS dtype, subject AS docname, createdby_id AS uid, document_id AS local_id FROM ss_documents UNION SELECT 'MEMO' AS dtype, subject AS docname, createdby_id AS uid, memo_id AS local_id FROM ss_memos ) AS ENTRIES ON ENTRIES.local_id = q.document_id  INNER JOIN ss_users u ON u.user_id = uid INNER JOIN ss_organizations o ON o.organization_id = q.organization_id LEFT OUTER JOIN ss_endpoints e ON e.organization_id = o.organization_id WHERE q.is_deleted = 0 AND q.created > ? AND q.created < ? ";
        Calendar cal = Calendar.getInstance();
        cal.setTime(filter.getStartDate());
        cal.set(10, 0);
        Timestamp tsFrom = new Timestamp(cal.getTime().getTime());
        paramList.add(new BaseDalc.FilterParam(93, tsFrom));
        cal.setTime(filter.getEndDate());
        cal.set(10, 24);
        Timestamp tsTo = new Timestamp(cal.getTime().getTime());
        paramList.add(new BaseDalc.FilterParam(93, tsTo));
        if (StringUtil.isValid(filter.getOrganizationId())) {
            sql = sql + "AND q.organization_id = ? ";
            paramList.add(new BaseDalc.FilterParam(12, filter.getOrganizationId()));
        }
        if (!RoutingLogFilter.DeliveryStatus.ALL.equals((Object)filter.getStatus())) {
            sql = sql + " AND q.is_processed = ? ";
            int iStatus = 0;
            if (RoutingLogFilter.DeliveryStatus.SENT.equals((Object)filter.getStatus())) {
                iStatus = 1;
            }
            paramList.add(new BaseDalc.FilterParam(4, iStatus));
        }
        sql = sql + " ORDER BY q.created DESC";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            int paramCounter = 1;
            for (BaseDalc.FilterParam param : paramList) {
                stmt.setObject(paramCounter, param.getValue(), param.getDataType());
                ++paramCounter;
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(new RoutingQueueInformationEntry(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RoutingQueueInformationEntry> getIncomingRoutingStatus(RoutingLogFilter filter) throws SQLException {
        ArrayList<RoutingQueueInformationEntry> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<RoutingQueueInformationEntry> list = new ArrayList<RoutingQueueInformationEntry>();
        ArrayList<BaseDalc.FilterParam> paramList = new ArrayList<BaseDalc.FilterParam>();
        String sql = "SELECT 'CASE' as doctype, c.case_id AS local_id, c.createdby_id AS uid, c.subject AS title, c.created, o.organization_id, o.subject AS oname, u.fullname AS owner, e.type AS gopro FROM ss_cases c INNER JOIN ss_organizations o ON c.organization_id = o.organization_id LEFT OUTER JOIN ss_users u ON u.user_id = c.createdby_id LEFT OUTER JOIN ss_endpoints e ON e.organization_id = o.organization_id WHERE c.is_fromgopro = 1 AND c.created > ? AND c.created < ? UNION SELECT 'MEMO' as doctype, m.memo_id AS local_id, m.createdby_id AS uid, m.subject AS title, m.created, o.organization_id, o.subject AS oname, u.fullname AS owner, e.type AS gopro FROM ss_memos m  INNER JOIN ss_cases c ON c.case_id = m.case_id INNER JOIN ss_organizations o ON o.organization_id = c.organization_id LEFT OUTER JOIN ss_users u ON u.user_id = m.createdby_id LEFT OUTER JOIN ss_endpoints e ON e.organization_id = o.organization_id WHERE m.is_fromgopro = 1 AND m.created > ? AND m.created < ? UNION SELECT 'DOCUMENT' as doctype, d.document_id AS local_id, d.createdby_id AS uid, d.subject AS title, d.created, o.organization_id, o.subject AS oname, u.fullname AS owner, e.type AS gopro FROM ss_documents d INNER JOIN ss_cases c ON c.case_id = d.case_id INNER JOIN ss_organizations o ON c.organization_id = o.organization_id LEFT OUTER JOIN ss_users u ON u.user_id = d.createdby_id LEFT OUTER JOIN ss_endpoints e ON e.organization_id = o.organization_id WHERE d.is_fromgopro = 1 AND d.created > ? AND d.created < ? ORDER BY created DESC";
        Calendar cal = Calendar.getInstance();
        cal.setTime(filter.getStartDate());
        cal.set(10, 0);
        Timestamp tsFrom = new Timestamp(cal.getTime().getTime());
        cal.setTime(filter.getEndDate());
        cal.set(10, 24);
        Timestamp tsTo = new Timestamp(cal.getTime().getTime());
        paramList.add(new BaseDalc.FilterParam(93, tsFrom));
        paramList.add(new BaseDalc.FilterParam(93, tsTo));
        paramList.add(new BaseDalc.FilterParam(93, tsFrom));
        paramList.add(new BaseDalc.FilterParam(93, tsTo));
        paramList.add(new BaseDalc.FilterParam(93, tsFrom));
        paramList.add(new BaseDalc.FilterParam(93, tsTo));
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            int paramCounter = 1;
            for (BaseDalc.FilterParam param : paramList) {
                stmt.setObject(paramCounter, param.getValue(), param.getDataType());
                ++paramCounter;
            }
            rs = stmt.executeQuery();
            boolean oFilter = StringUtil.isValid(filter.getOrganizationId());
            while (rs.next()) {
                IncomingInformationEntry entry = new IncomingInformationEntry();
                entry.setDocumentType(rs.getString("doctype"));
                entry.setDocumentId(rs.getString("local_id"));
                entry.setUserId(rs.getString("uid"));
                entry.setSubject(rs.getString("title"));
                entry.setDateCreated(rs.getTimestamp("created").getTime());
                entry.setOrganizationId(rs.getString("organization_id"));
                entry.setOrganizationName(rs.getString("oname"));
                entry.setUserFullname(rs.getString("owner"));
                entry.setGoProType(rs.getString("gopro"));
                if (oFilter) {
                    if (!filter.getOrganizationId().equals(entry.getOrganizationId())) continue;
                    list.add(entry);
                    continue;
                }
                list.add(entry);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createQueueLogEntry(QueueLogEntry entry) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"queue_id", "level", "stamp", "message", "stacktrace"};
        String sql = this.createInsertSQL(TBL_QUEUELOG, cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, entry.getQueueId());
            stmt.setInt(2, entry.getLogLevel().getLevel());
            stmt.setTimestamp(3, new Timestamp(entry.getTimestamp()));
            stmt.setString(4, entry.getMessage());
            if (entry.getStacktrace() != null) {
                stmt.setString(5, entry.getStacktrace());
            } else {
                stmt.setNull(5, 12);
            }
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueueLogEntry> getQueueLog(String queueId) throws SQLException {
        ArrayList<QueueLogEntry> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<QueueLogEntry> list = new ArrayList<QueueLogEntry>();
        String sql = "SELECT l.queue_id, l.level, l.stamp, l.message, l.stacktrace FROM ss_queuelog l WHERE l.queue_id = ? ORDER BY stamp DESC";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, queueId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(new QueueLogEntry(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDocumentInBrokerRelation(String documentId) throws SQLException {
        boolean bl;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean inQueue = false;
        String sql = "SELECT COUNT(document_id) AS counter FROM ss_brokerrelations WHERE document_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, documentId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                inQueue = rs.getInt("counter") == 1;
            }
            rs.close();
            bl = inQueue;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createBrokerRelationEntry(BrokerRelationEntry entry) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"document_id", "queue_id", "gopro_id", "transaction_id", "organization_id", "iteration", "is_completed", "is_deleted", "created", "modified"};
        String sql = this.createInsertSQL(TBL_BROKER_RELATION, cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, entry.getId());
            stmt.setString(2, entry.getQueueId());
            stmt.setString(3, entry.getGoproId());
            stmt.setString(4, entry.getTransactionId());
            stmt.setString(5, entry.getOrganizationId());
            stmt.setInt(6, entry.getIterationCount());
            stmt.setInt(7, entry.isCompleted() ? 1 : 0);
            stmt.setInt(8, entry.isDeleted() ? 1 : 0);
            stmt.setTimestamp(9, new Timestamp(entry.getDateCreated()));
            stmt.setTimestamp(10, new Timestamp(entry.getDateModified()));
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrokerRelationEntry getBrokerRelationEntry(String queueId) throws SQLException {
        BrokerRelationEntry brokerRelationEntry;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        BrokerRelationEntry entry = null;
        String sql = "SELECT q.document_id, q.queue_id, q.gopro_id, q.transaction_id, q.organization_id, q.iteration, q.iteration, q.is_completed, q.is_deleted, q.created, q.modified FROM ss_brokerrelations q WHERE q.queue_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, queueId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                entry = new BrokerRelationEntry(rs);
            }
            rs.close();
            brokerRelationEntry = entry;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return brokerRelationEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBrokerRelationEntry(BrokerRelationEntry entry) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"gopro_id", "iteration", "is_completed", "is_deleted", "modified", "queue_id"};
        String sql = this.createUpdateSQL(TBL_BROKER_RELATION, cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, entry.getGoproId());
            stmt.setInt(2, entry.getIterationCount());
            stmt.setInt(3, entry.isCompleted() ? 1 : 0);
            stmt.setInt(4, entry.isDeleted() ? 1 : 0);
            stmt.setTimestamp(5, new Timestamp(entry.getDateModified()));
            stmt.setString(6, entry.getQueueId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BrokerRelationEntry> getBrokerRelations(IQueueEngine.BrokerDocumentType type, IQueueEngine.BrokerRelationStatus status) throws SQLException {
        ArrayList<BrokerRelationEntry> arrayList;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<BrokerRelationEntry> list = new ArrayList<BrokerRelationEntry>();
        String sql = "SELECT q.document_id, q.queue_id, q.gopro_id, q.transaction_id, q.organization_id, q.iteration, q.is_completed, q.is_deleted, q.created, q.modified FROM ss_brokerrelations q ";
        if (type.equals((Object)IQueueEngine.BrokerDocumentType.CASE)) {
            sql = sql + "INNER JOIN ss_cases c ON c.case_id = q.document_id ";
        }
        if (status.equals((Object)IQueueEngine.BrokerRelationStatus.PENDING)) {
            sql = sql + " WHERE q.is_completed = 0 ";
        } else if (status.equals((Object)IQueueEngine.BrokerRelationStatus.FINISHED)) {
            sql = sql + " WHERE q.is_completed = 1 ";
        }
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                list.add(new BrokerRelationEntry(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCaseRelation(BaseCase doc) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"gopro_id", "gopro_casenumber", "case_id"};
        String sql = this.createUpdateSQL("ss_cases", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, doc.getGoProId());
            stmt.setString(2, doc.getGoProCaseNumber());
            stmt.setString(3, doc.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSubdocumentRelation(SubDocument doc) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String colKey = doc instanceof Memo ? "memo_id" : "document_id";
        String[] cols = new String[]{"gopro_id", colKey};
        String sql = this.createUpdateSQL(doc instanceof Memo ? "ss_memos" : "ss_documents", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, doc.getGoProId());
            stmt.setString(2, doc.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSubdocumentType(String queueId) throws SQLException {
        String string;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String documentType = null;
        String sql = "SELECT q.queue_id, q.document_id, documenttype FROM ss_queue q LEFT OUTER JOIN ( SELECT d.document_id AS local_id, 'Attachment' AS documenttype FROM ss_documents d UNION SELECT m.memo_id AS local_id, 'Memo' AS documenttype FROM ss_memos m UNION SELECT e.email_id AS local_id, 'Email' AS documenttype FROM ss_emails e  ) AS DOCS ON DOCS.local_id = q.document_id WHERE q.queue_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, queueId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                documentType = rs.getString("documenttype");
            }
            rs.close();
            string = documentType;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PickUpQueueEntry> getPickupQueue(RoutingLogFilter filter) throws SQLException {
        ArrayList<PickUpQueueEntry> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<PickUpQueueEntry> list = new ArrayList<PickUpQueueEntry>();
        String sql = "SELECT c.case_id AS documentId, c.subject, c.created, c.modified, c.is_deleted, o.subject AS organization, o.organization_id, c.completed, 'CASE' AS documentType, u.user_id AS userId, u.fullname FROM ss_cases c INNER JOIN ss_users u ON u.user_id = c.createdby_id INNER JOIN ss_organizations o ON o.organization_id = c.organization_id INNER JOIN ss_endpoints e ON e.organization_id = o.organization_id WHERE c.completed IS NOT NULL AND e.type = 'BROKER_PICKUP' AND o.is_deleted = 0 AND c.created > ? AND c.created < ? UNION SELECT m.memo_id AS documentId, m.subject, m.created, m.modified, m.is_deleted, o.subject AS organization, o.organization_id, m.completed, 'MEMO' AS documentType, u.user_id AS userId, u.fullname  FROM ss_memos m INNER JOIN ss_cases c ON c.case_id = m.case_id INNER JOIN ss_users u ON u.user_id = m.createdby_id INNER JOIN ss_organizations o ON o.organization_id = c.organization_id INNER JOIN ss_endpoints e ON e.organization_id = o.organization_id WHERE e.type = 'BROKER_PICKUP' AND o.is_deleted = 0 AND m.is_deleted = 0 AND m.is_fromgopro = 0 AND m.is_sent = 1 AND m.created > ? AND m.created < ? UNION SELECT d.document_id AS documentId, d.subject, d.created, d.modified, d.is_deleted, o.subject AS organization, o.organization_id, d.completed, 'DOCUMENT' AS documentType, u.user_id AS userId, u.fullname FROM ss_documents d INNER JOIN ss_cases c ON c.case_id = d.case_id INNER JOIN ss_users u ON d.createdby_id = u.user_id INNER JOIN ss_organizations o ON o.organization_id = c.organization_id INNER JOIN ss_endpoints e ON e.organization_id = o.organization_id WHERE e.type = 'BROKER_PICKUP' AND o.is_deleted = 0 AND d.is_deleted = 0 AND d.is_fromgopro = 0 AND d.is_sent = 1 AND d.classname != ? AND d.created > ? AND d.created < ? ORDER BY completed DESC";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setTimestamp(1, new Timestamp(filter.getStartDate().getTime()));
            stmt.setTimestamp(2, new Timestamp(filter.getEndDate().getTime()));
            stmt.setTimestamp(3, new Timestamp(filter.getStartDate().getTime()));
            stmt.setTimestamp(4, new Timestamp(filter.getEndDate().getTime()));
            stmt.setString(5, ApplicationForm.class.getName());
            stmt.setTimestamp(6, new Timestamp(filter.getStartDate().getTime()));
            stmt.setTimestamp(7, new Timestamp(filter.getEndDate().getTime()));
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(new PickUpQueueEntry(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }
}

