/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.dalc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.gopro.selfservice.dalc.BaseDalc;
import net.gopro.selfservice.data.Announcement;
import net.gopro.selfservice.data.Message;
import net.gopro.selfservice.data.targetgroup.TargetGroup;

public class MessageDalc
extends BaseDalc {
    private static final String TBL_MESSAGES = "ss_messages";
    private static final String TBL_ANNOUNCEMENTS = "ss_announcements";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMessage(Message message) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"message_id", "recipient_id", "createdby_id", "parent_id", "subject", "body", "sender", "is_read", "is_deleted", "created", "modified"};
        String sql = this.createInsertSQL(TBL_MESSAGES, cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, message.getId());
            stmt.setString(2, message.getRecipientId());
            stmt.setString(3, message.getCreatedById());
            stmt.setString(4, message.getParentId());
            stmt.setString(5, message.getSubject());
            stmt.setString(6, message.getBody());
            stmt.setString(7, message.getSenderName());
            stmt.setInt(8, message.isRead() ? 1 : 0);
            stmt.setInt(9, message.isDeleted() ? 1 : 0);
            stmt.setTimestamp(10, new Timestamp(message.getDateCreated()));
            stmt.setTimestamp(11, new Timestamp(message.getDateModified()));
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getMessage(String messageId) throws SQLException {
        Message message;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Message message2 = null;
        String sql = "SELECT m.message_id, m.recipient_id, m.createdby_id, m.parent_id, m.subject, m.body, m.sender, m.is_read, m.is_deleted, m.created, m.modified FROM ss_messages m WHERE m.message_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, messageId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                message2 = new Message(rs);
            }
            rs.close();
            message = message2;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> getMessages(String userId) throws SQLException {
        ArrayList<Message> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Message> list = new ArrayList<Message>();
        String sql = "SELECT m.message_id, m.recipient_id, m.createdby_id, m.parent_id, m.subject, m.body, m.sender, m.is_read, m.is_deleted, m.created, m.modified FROM ss_messages m WHERE m.recipient_id = ? ORDER BY m.created DESC";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, userId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(new Message(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> getMessages(String userId, Date dateSince) throws SQLException {
        ArrayList<Message> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Message> list = new ArrayList<Message>();
        String sql = "SELECT m.message_id, m.recipient_id, m.createdby_id, m.parent_id, m.subject, m.body, m.sender, m.is_read, m.is_deleted, m.created, m.modified FROM ss_messages m WHERE m.recipient_id = ? AND m.created >= ? ORDER BY m.created DESC";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, userId);
            stmt.setTimestamp(2, new Timestamp(dateSince.getTime()));
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(new Message(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMessage(Message message) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"recipient_id", "subject", "body", "sender", "is_read", "is_deleted", "modified", "createdby_id", "parent_id", "message_id"};
        String sql = this.createUpdateSQL(TBL_MESSAGES, cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, message.getRecipientId());
            stmt.setString(2, message.getSubject());
            stmt.setString(3, message.getBody());
            stmt.setString(4, message.getSenderName());
            stmt.setInt(5, message.isRead() ? 1 : 0);
            stmt.setInt(6, message.isDeleted() ? 1 : 0);
            stmt.setTimestamp(7, new Timestamp(message.getDateModified()));
            stmt.setString(8, message.getCreatedById());
            stmt.setString(9, message.getParentId());
            stmt.setString(10, message.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAllMessagesRead(String userId) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String sql = "UPDATE ss_messages SET is_read = 1 WHERE recipient_id = ? AND is_deleted = 0";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, userId);
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnreadMessageCount(String userId) throws SQLException {
        int n;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int messageCount = 0;
        String sql = "SELECT COUNT(m.message_id) FROM ss_messages m WHERE m.recipient_id = ? AND m.is_read = 0 AND m.is_deleted = 0";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, userId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                messageCount = rs.getInt(1);
            }
            rs.close();
            n = messageCount;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAnnouncement(Announcement ann) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"announcement_id", "targetgroup_id", "subject", "body", "recipientcount", "is_internal", "is_email", "is_deleted", "sent", "created", "modified"};
        String sql = this.createInsertSQL(TBL_ANNOUNCEMENTS, cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, ann.getId());
            stmt.setString(2, ann.getTargetGroupId());
            stmt.setString(3, ann.getSubject());
            stmt.setString(4, ann.getBody());
            stmt.setInt(5, ann.getRecipientCount());
            stmt.setInt(6, ann.isInternal() ? 1 : 0);
            stmt.setInt(7, ann.isEmail() ? 1 : 0);
            stmt.setInt(8, ann.isDeleted() ? 1 : 0);
            stmt.setTimestamp(9, new Timestamp(ann.getDateSent()));
            stmt.setTimestamp(10, new Timestamp(ann.getDateCreated()));
            stmt.setTimestamp(11, new Timestamp(ann.getDateModified()));
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAnnouncement(Announcement ann) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"targetgroup_id", "subject", "body", "recipientcount", "is_internal", "is_email", "is_deleted", "sent", "modified", "announcement_id"};
        String sql = this.createUpdateSQL(TBL_ANNOUNCEMENTS, cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, ann.getTargetGroupId());
            stmt.setString(2, ann.getSubject());
            stmt.setString(3, ann.getBody());
            stmt.setInt(4, ann.getRecipientCount());
            stmt.setInt(5, ann.isInternal() ? 1 : 0);
            stmt.setInt(6, ann.isEmail() ? 1 : 0);
            stmt.setInt(7, ann.isDeleted() ? 1 : 0);
            stmt.setTimestamp(8, new Timestamp(ann.getDateSent()));
            stmt.setTimestamp(9, new Timestamp(ann.getDateModified()));
            stmt.setString(10, ann.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Announcement getAnnouncement(String announcementId) throws SQLException {
        Announcement announcement;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Announcement ann = null;
        String sql = "SELECT a.announcement_id, a.targetgroup_id, a.subject, a.body, a.recipientcount, a.is_internal, a.is_email, a.is_deleted, a.sent, a.created, a.modified, t.subject AS groupname, t.generator FROM ss_announcements a INNER JOIN ss_targetgroups t ON t.targetgroup_id = a.targetgroup_id WHERE a.announcement_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, announcementId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                ann = new Announcement(rs);
                TargetGroup.Generator generator = TargetGroup.Generator.valueOf(rs.getString("generator"));
                if (TargetGroup.Generator.CONTACTS.equals((Object)generator)) {
                    ann.setCompanyAnnouncement(true);
                }
            }
            rs.close();
            announcement = ann;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return announcement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Announcement> getAnnouncements() throws SQLException {
        ArrayList<Announcement> arrayList;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<Announcement> list = new ArrayList<Announcement>();
        String sql = "SELECT a.announcement_id, a.targetgroup_id, a.subject, a.body, a.recipientcount, a.is_internal, a.is_email, a.is_deleted, a.sent, a.created, a.modified, t.subject AS groupname, t.generator FROM ss_announcements a INNER JOIN ss_targetgroups t ON t.targetgroup_id = a.targetgroup_id ORDER BY a.subject";
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                Announcement ann = new Announcement(rs);
                TargetGroup.Generator generator = TargetGroup.Generator.valueOf(rs.getString("generator"));
                if (TargetGroup.Generator.CONTACTS.equals((Object)generator)) {
                    ann.setCompanyAnnouncement(true);
                }
                list.add(ann);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }
}

