/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.dalc;

import is.hugvit.util.UID;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import net.gopro.selfservice.FormTemplateFactory;
import net.gopro.selfservice.dalc.BaseDalc;
import net.gopro.selfservice.data.FormGuidance;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.FormTemplateExtras;
import net.gopro.selfservice.data.FormTemplateFile;
import net.gopro.selfservice.data.FormTranslation;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.SecondaryForm;
import net.gopro.selfservice.data.StatusListItem;
import org.apache.commons.lang.RandomStringUtils;

public class FormDalc
extends BaseDalc {
    private static final String TBL_TEMPLATEFILES = "ss_formfiles";
    private static final String TBL_GUIDANCE = "ss_guidance";
    private static final String TBL_FORMSTATUS = "ss_formstatuses";
    private static final String TBL_TRANSLATIONS = "ss_formtranslations";

    public void createFormTemplate(FormTemplate ft) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"template_id", "subject", "description", "category", "valid_from", "valid_to", "is_visible", "is_memos", "is_attachments", "is_deleted", "created", "modified", "classname", "is_postsendfilter", "is_resend", "resendstatus_id", "message_id", "restriction", "version", "is_signature", "is_sensitive", "is_secondary", "sec_handle"};
        String sql = this.createInsertSQL("ss_formtemplates", cols);
        String[] cols2 = new String[]{"file_id", "template_id", "filename", "type", "tag", "stream", "is_deleted", "created", "modified"};
        String fileSql = this.createInsertSQL(TBL_TEMPLATEFILES, cols2);
        String[] cols3 = new String[]{"template_id", "organization_id", "link_id"};
        String orgSql = this.createInsertSQL("ss_formlinks", cols3);
        String[] col4 = new String[]{"template_id", "status_id", "listorder"};
        String statusSql = this.createInsertSQL(TBL_FORMSTATUS, col4);
        try {
            con = this.startTransaction();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, ft.getId());
            stmt.setString(2, ft.getSubject());
            stmt.setString(3, ft.getDescription());
            stmt.setString(4, ft.getCategory());
            if (ft.isDateRestricted()) {
                stmt.setTimestamp(5, new Timestamp(ft.getDateValidFrom()));
                stmt.setTimestamp(6, new Timestamp(ft.getDateValidTo()));
            } else {
                stmt.setNull(5, 93);
                stmt.setNull(6, 93);
            }
            stmt.setInt(7, ft.isVisible() ? 1 : 0);
            stmt.setInt(8, ft.isMemoVisible() ? 1 : 0);
            stmt.setInt(9, ft.isAttachmentVisible() ? 1 : 0);
            stmt.setInt(10, ft.isDeleted() ? 1 : 0);
            stmt.setTimestamp(11, new Timestamp(ft.getDateCreated()));
            stmt.setTimestamp(12, new Timestamp(ft.getDateModified()));
            stmt.setString(13, ft.getClass().getName());
            stmt.setInt(14, ft.isPostSendUsingViewFilter() ? 1 : 0);
            stmt.setInt(15, ft.isResendEnabled() ? 1 : 0);
            stmt.setString(16, ft.getResendStatusId());
            stmt.setString(17, ft.getMessageTemplateId());
            stmt.setInt(18, ft.getRestriction().getCode());
            stmt.setDouble(19, ft.getSchemaVersion());
            stmt.setInt(20, ft.isSignatureRequired() ? 1 : 0);
            stmt.setInt(21, ft.isPersonalSensitive() ? 1 : 0);
            stmt.setInt(22, ft.isSecondaryEnabled() ? 1 : 0);
            stmt.setInt(23, ft.getSecondaryHandling().getCode());
            stmt.executeUpdate();
            this.createFormTemplateExtras(ft.getExtendedData(), ft.getId());
            stmt = con.prepareStatement(fileSql);
            for (FormTemplateFile ff : ft.getTemplateFiles()) {
                stmt.setString(1, UID.getUID());
                stmt.setString(2, ft.getId());
                stmt.setString(3, ff.getFilename());
                stmt.setString(4, ff.getType().toString());
                stmt.setString(5, ff.getTag().toString());
                stmt.setBinaryStream(6, (InputStream)new ByteArrayInputStream(ff.getStream()), ff.getStream().length);
                stmt.setInt(7, ff.isDeleted() ? 1 : 0);
                stmt.setTimestamp(8, new Timestamp(ff.getDateCreated()));
                stmt.setTimestamp(9, new Timestamp(ff.getDateModified()));
                stmt.executeUpdate();
            }
            stmt = con.prepareStatement(orgSql);
            for (Organization org : ft.getOrganizations()) {
                stmt.setString(1, ft.getId());
                stmt.setString(2, org.getId());
                stmt.setString(3, this.generateUniqueLinkId());
                stmt.executeUpdate();
            }
            FormTemplateExtras fex = ft.getExtendedData();
            if (fex != null && fex.getCaseStatusList() != null) {
                int i = 0;
                stmt = con.prepareStatement(statusSql);
                for (StatusListItem item : fex.getCaseStatusList()) {
                    stmt.setString(1, ft.getId());
                    stmt.setString(2, item.getId());
                    stmt.setInt(3, ++i);
                    stmt.executeUpdate();
                }
            }
            if (ft.isSecondaryEnabled()) {
                String secondarySql = this.createInsertSQL("ss_secondaries", new String[]{"parent_id", "template_id", "status_id", "timelimit"});
                stmt = con.prepareStatement(secondarySql);
                for (SecondaryForm sf : ft.getSecondaryReferences()) {
                    stmt.setString(1, ft.getId());
                    stmt.setString(2, sf.getTemplateId());
                    stmt.setString(3, sf.getStatusId());
                    stmt.setInt(4, sf.getTimelimit());
                    stmt.executeUpdate();
                }
            }
            this.commitTransaction();
        }
        catch (SQLException ex) {
            try {
                con.rollback();
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFormTemplateExtras(FormTemplateExtras ext, String templateId) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"template_id", "targetgroup_id", "cssfile", "customclass", "jscript", "gopro_agent", "gopro_alias", "gopro_subject", "filecount", "fee_amount", "fee_currency", "pdftype"};
        String sql = this.createInsertSQL("ss_extras", cols);
        if (ext == null) {
            ext = new FormTemplateExtras();
        }
        try {
            con = this.getTransactionConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, templateId);
            stmt.setString(2, ext.getTargetGroupId());
            stmt.setString(3, ext.getCssFilePath());
            stmt.setString(4, ext.getCustomClass());
            stmt.setString(5, ext.getJavascriptFilePath());
            stmt.setString(6, ext.getGoproAgent());
            stmt.setString(7, ext.getGoproAlias());
            stmt.setInt(8, ext.isGoproSubject() ? 1 : 0);
            stmt.setInt(9, ext.getRequiredAttachmentCount());
            stmt.setDouble(10, ext.getFormFeeAmount());
            stmt.setString(11, ext.getFormFeeCurrency());
            stmt.setString(12, ext.getPdfFoType().toString());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            throw throwable;
        }
        this.closeStatement(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormTemplate getFormTemplate(String formtemplateId, boolean includeStream) throws SQLException, IOException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        FormTemplate ft = null;
        String sql = "SELECT t.template_id, t.subject, t.description, t.category, t.valid_from, t.valid_to, t.is_visible, t.is_postsendfilter, t.is_memos, t.is_resend, t.resendstatus_id, t.message_id, t.restriction, t.is_attachments, t.created, t.is_signature,t.is_sensitive, t.is_secondary, t.sec_handle,t.modified, t.is_deleted, t.classname, t.version, e.targetgroup_id, e.cssfile, e.customclass, e.jscript,e.gopro_agent, e.gopro_alias, e.gopro_subject, e.filecount, e.fee_amount, e.fee_currency, e.pdftype FROM ss_formtemplates t INNER JOIN ss_extras e ON t.template_id = e.template_id WHERE t.template_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, formtemplateId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                ft = FormTemplateFactory.getInstance(rs.getString("classname"), rs);
                ft.setExtendedData(new FormTemplateExtras(rs));
            }
            rs.close();
            if (ft != null) {
                sql = "SELECT s.template_id, s.status_id, s.timelimit, t.subject AS template, e.targetgroup_id, l.subject AS status FROM ss_secondaries s INNER JOIN ss_formtemplates t ON t.template_id = s.template_id INNER JOIN ss_extras e ON e.template_id = t.template_id INNER JOIN ss_listitems l ON l.item_id = s.status_id WHERE t.is_deleted = 0 AND s.parent_id = ?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, formtemplateId);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    SecondaryForm sf = new SecondaryForm(rs);
                    ft.getSecondaryReferences().add(sf);
                }
                rs.close();
                if (ft.isSecondaryEnabled()) {
                    this.setSecondaryFormTemplateLinks(ft);
                }
                sql = "SELECT f.file_id, f.template_id, f.filename, f.type, f.tag, ";
                if (includeStream) {
                    sql = sql + "f.stream,";
                }
                sql = sql + " f.created, f.modified, f.is_deleted FROM ss_formfiles f WHERE f.template_id = ? AND f.is_deleted = 0";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, formtemplateId);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    FormTemplateFile ff = new FormTemplateFile(rs);
                    if (includeStream) {
                        InputStream is = rs.getBinaryStream("stream");
                        byte[] bytes = new byte[is.available()];
                        is.read(bytes);
                        is.close();
                        ff.setStream(bytes);
                    }
                    ft.getTemplateFiles().add(ff);
                }
                rs.close();
                sql = "SELECT o.organization_id, o.subject, o.alias, o.cssfile, o.footer, o.is_signature, o.is_enabled, o.is_remote, o.is_service, o.serviceemail, o.mailoptions, o.customclass, o.is_deleted, o.created, o.modified, l.link_id FROM ss_organizations o INNER JOIN ss_formlinks l ON l.organization_id = o.organization_id WHERE l.template_id = ? AND o.is_deleted = 0";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, formtemplateId);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    Organization o = new Organization(rs);
                    ft.getOrganizations().add(o);
                    ft.getLinkMap().put(o.getId(), rs.getString("link_id"));
                }
                rs.close();
                sql = "SELECT g.guidance_id, g.template_id, g.section_id, g.subject, g.body, g.weblink, g.imagepath, g.is_expanded, g.is_deleted, g.created, g.modified FROM ss_guidance g WHERE g.template_id = ? AND g.is_deleted = 0";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, ft.getId());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    ft.getGuidances().add(new FormGuidance(rs));
                }
                rs.close();
                sql = "SELECT i.item_id, i.list_id, i.subject, i.alias, i.status, i.is_deleted, i.created, i.modified FROM ss_listitems i INNER JOIN ss_formstatuses s ON s.status_id = i.item_id WHERE s.template_id = ? AND i.is_deleted = 0 ORDER BY s.listorder ASC";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, ft.getId());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    ft.getExtendedData().getCaseStatusList().add(new StatusListItem(rs));
                }
                rs.close();
            }
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return ft;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FormTemplate> getFormTemplates() throws SQLException {
        ArrayList<FormTemplate> arrayList;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<FormTemplate> list = new ArrayList<FormTemplate>();
        String sql = "SELECT t.template_id, t.subject, t.description, t.category, t.valid_from, t.valid_to, t.is_visible, t.is_postsendfilter, t.is_memos, t.is_signature, t.is_resend, t.resendstatus_id, t.message_id, t.restriction, t.is_attachments, t.created, t.is_sensitive, t.is_secondary, t.sec_handle,t.modified, t.is_deleted, t.classname, t.version, e.targetgroup_id, e.cssfile, e.customclass, e.jscript,e.gopro_agent, e.gopro_alias, e.gopro_subject, e.filecount, e.fee_amount, e.fee_currency, e.pdftype FROM ss_formtemplates t INNER JOIN ss_extras e ON t.template_id = e.template_id WHERE t.is_deleted = 0";
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                FormTemplate ft = FormTemplateFactory.getInstance(rs.getString("classname"), rs);
                ft.setExtendedData(new FormTemplateExtras(rs));
                list.add(ft);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FormTemplate> getPrimaryFormTemplates() throws SQLException {
        ArrayList<FormTemplate> arrayList;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<FormTemplate> list = new ArrayList<FormTemplate>();
        String sql = "SELECT t.template_id, t.subject, t.description, t.category, t.valid_from, t.valid_to, t.is_visible, t.is_postsendfilter, t.is_memos, t.is_signature, t.is_resend, t.resendstatus_id, t.message_id, t.restriction, t.is_attachments, t.created, t.is_sensitive, t.is_secondary, t.sec_handle,t.modified, t.is_deleted, t.classname, t.version, e.targetgroup_id, e.cssfile, e.customclass, e.jscript,e.gopro_agent, e.gopro_alias, e.gopro_subject, e.filecount, e.fee_amount, e.fee_currency, e.pdftype FROM ss_formtemplates t INNER JOIN ss_extras e ON t.template_id = e.template_id WHERE t.is_deleted = 0 AND t.is_secondary = 1";
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            Hashtable<String, FormTemplate> ht = new Hashtable<String, FormTemplate>();
            while (rs.next()) {
                FormTemplate ft = FormTemplateFactory.getInstance(rs.getString("classname"), rs);
                ft.setExtendedData(new FormTemplateExtras(rs));
                list.add(ft);
                ht.put(ft.getId(), ft);
            }
            rs.close();
            sql = "SELECT s.parent_id, s.template_id, s.status_id, s.timelimit, t.subject AS template, e.targetgroup_id, l.subject AS status FROM ss_secondaries s INNER JOIN ss_formtemplates t ON t.template_id = s.template_id INNER JOIN ss_extras e ON e.template_id = t.template_id INNER JOIN ss_listitems l ON l.item_id = s.status_id WHERE t.is_deleted = 0";
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String parentId = rs.getString("parent_id");
                SecondaryForm sf = new SecondaryForm(rs);
                if (!ht.containsKey(parentId)) continue;
                ((FormTemplate)ht.get(parentId)).getSecondaryReferences().add(sf);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FormTemplate> getFormTemplates(String organizationId) throws SQLException {
        ArrayList<FormTemplate> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<FormTemplate> list = new ArrayList<FormTemplate>();
        String sql = "SELECT t.template_id, t.subject, t.description, t.category, t.valid_from, t.valid_to, t.is_visible, t.is_postsendfilter, t.is_memos, t.is_resend, t.resendstatus_id, t.message_id, t.restriction, t.is_attachments, t.created, t.modified, t.is_deleted, t.classname, t.version, t.is_signature, t.is_sensitive, t.is_secondary, t.sec_handle,e.targetgroup_id, e.cssfile, e.customclass, e.jscript,e.gopro_agent, e.gopro_alias, e.gopro_subject, e.filecount, e.fee_amount, e.fee_currency, e.pdftype FROM ss_formtemplates t INNER JOIN ss_extras e ON t.template_id = e.template_id INNER JOIN ss_formlinks l ON l.template_id = t.template_id INNER JOIN ss_organizations o ON o.organization_id = l.organization_id  WHERE o.organization_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, organizationId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                FormTemplate ft = FormTemplateFactory.getInstance(rs.getString("classname"), rs);
                ft.setExtendedData(new FormTemplateExtras(rs));
                list.add(ft);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    public void updateFormTemplate(FormTemplate ft) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        PreparedStatement stmt2 = null;
        String[] cols = new String[]{"subject", "description", "category", "valid_from", "valid_to", "is_visible", "is_memos", "is_attachments", "is_resend", "resendstatus_id", "message_id", "is_postsendfilter", "restriction", "is_deleted", "modified", "version", "is_signature", "is_secondary", "is_sensitive", "sec_handle", "template_id"};
        String sql = this.createUpdateSQL("ss_formtemplates", cols);
        try {
            con = this.startTransaction();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, ft.getSubject());
            stmt.setString(2, ft.getDescription());
            stmt.setString(3, ft.getCategory());
            if (ft.isDateRestricted()) {
                stmt.setTimestamp(4, new Timestamp(ft.getDateValidFrom()));
                stmt.setTimestamp(5, new Timestamp(ft.getDateValidTo()));
            } else {
                stmt.setNull(4, 93);
                stmt.setNull(5, 93);
            }
            stmt.setInt(6, ft.isVisible() ? 1 : 0);
            stmt.setInt(7, ft.isMemoVisible() ? 1 : 0);
            stmt.setInt(8, ft.isAttachmentVisible() ? 1 : 0);
            stmt.setInt(9, ft.isResendEnabled() ? 1 : 0);
            stmt.setString(10, ft.getResendStatusId());
            stmt.setString(11, ft.getMessageTemplateId());
            stmt.setInt(12, ft.isPostSendUsingViewFilter() ? 1 : 0);
            stmt.setInt(13, ft.getRestriction().getCode());
            stmt.setInt(14, ft.isDeleted() ? 1 : 0);
            stmt.setTimestamp(15, new Timestamp(ft.getDateModified()));
            stmt.setDouble(16, ft.getSchemaVersion());
            stmt.setInt(17, ft.isSignatureRequired() ? 1 : 0);
            stmt.setInt(18, ft.isSecondaryEnabled() ? 1 : 0);
            stmt.setInt(19, ft.isPersonalSensitive() ? 1 : 0);
            stmt.setInt(20, ft.getSecondaryHandling().getCode());
            stmt.setString(21, ft.getId());
            stmt.executeUpdate();
            FormTemplateExtras fte = ft.getExtendedData();
            if (fte != null) {
                String[] cols2 = new String[]{"targetgroup_id", "cssfile", "customclass", "jscript", "gopro_agent", "gopro_alias", "gopro_subject", "filecount", "fee_amount", "fee_currency", "pdftype", "template_id"};
                sql = this.createUpdateSQL("ss_extras", cols2);
                stmt = con.prepareStatement(sql);
                stmt.setString(1, fte.getTargetGroupId());
                stmt.setString(2, fte.getCssFilePath());
                stmt.setString(3, fte.getCustomClass());
                stmt.setString(4, fte.getJavascriptFilePath());
                stmt.setString(5, fte.getGoproAgent());
                stmt.setString(6, fte.getGoproAlias());
                stmt.setInt(7, fte.isGoproSubject() ? 1 : 0);
                stmt.setInt(8, fte.getRequiredAttachmentCount());
                stmt.setDouble(9, fte.getFormFeeAmount());
                stmt.setString(10, fte.getFormFeeCurrency());
                stmt.setString(11, fte.getPdfFoType().toString());
                stmt.setString(12, ft.getId());
                stmt.executeUpdate();
            }
            if (ft.getOrganizations().size() == 0) {
                sql = "DELETE FROM ss_formlinks WHERE template_id = ?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, ft.getId());
                stmt.executeUpdate();
            } else {
                HashSet<String> linkList = new HashSet<String>();
                Set<String> currList = ft.getOrganizationIds();
                sql = "SELECT organization_id FROM ss_formlinks WHERE template_id = ?";
                stmt2 = con.prepareStatement(sql);
                stmt2.setString(1, ft.getId());
                ResultSet rs = stmt2.executeQuery();
                while (rs.next()) {
                    linkList.add(rs.getString("organization_id"));
                }
                rs.close();
                for (String oid : currList) {
                    if (linkList.contains(oid)) {
                        linkList.remove(oid);
                        continue;
                    }
                    sql = this.createInsertSQL("ss_formlinks", new String[]{"template_id", "organization_id", "link_id"});
                    stmt = con.prepareStatement(sql);
                    stmt.setString(1, ft.getId());
                    stmt.setString(2, oid);
                    stmt.setString(3, this.generateUniqueLinkId());
                    stmt.executeUpdate();
                }
                sql = "DELETE FROM ss_formlinks WHERE template_id = ? AND organization_id = ?";
                stmt = con.prepareStatement(sql);
                for (String deleteId : linkList) {
                    stmt.setString(1, ft.getId());
                    stmt.setString(2, deleteId);
                    stmt.executeUpdate();
                }
            }
            sql = "DELETE FROM ss_formstatuses WHERE template_id = ?";
            stmt = con.prepareStatement(sql);
            stmt.setString(1, ft.getId());
            stmt.executeUpdate();
            if (fte != null && fte.getCaseStatusList() != null) {
                String[] col = new String[]{"template_id", "status_id", "listorder"};
                String statusSql = this.createInsertSQL(TBL_FORMSTATUS, col);
                stmt = con.prepareStatement(statusSql);
                int i = 0;
                for (StatusListItem item : fte.getCaseStatusList()) {
                    stmt.setString(1, ft.getId());
                    stmt.setString(2, item.getId());
                    stmt.setInt(3, ++i);
                    stmt.executeUpdate();
                }
            }
            if (ft.isSecondaryEnabled()) {
                sql = "DELETE FROM ss_secondaries WHERE parent_id = ?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, ft.getId());
                stmt.executeUpdate();
                String secondarySql = this.createInsertSQL("ss_secondaries", new String[]{"parent_id", "template_id", "status_id", "timelimit"});
                stmt = con.prepareStatement(secondarySql);
                for (SecondaryForm sf : ft.getSecondaryReferences()) {
                    stmt.setString(1, ft.getId());
                    stmt.setString(2, sf.getTemplateId());
                    stmt.setString(3, sf.getStatusId());
                    stmt.setInt(4, sf.getTimelimit());
                    stmt.executeUpdate();
                }
            }
            sql = this.createUpdateSQL(TBL_TEMPLATEFILES, new String[]{"filename", "stream", "modified", "is_deleted", "file_id"});
            stmt = con.prepareStatement(sql);
            for (FormTemplateFile file : ft.getTemplateFiles()) {
                if (!file.isDirty()) continue;
                stmt.setString(1, file.getFilename());
                stmt.setBinaryStream(2, (InputStream)new ByteArrayInputStream(file.getStream()), file.getStream().length);
                stmt.setTimestamp(3, new Timestamp(new Date().getTime()));
                stmt.setInt(4, file.isDeleted() ? 1 : 0);
                stmt.setString(5, file.getId());
                stmt.executeUpdate();
            }
            this.commitTransaction();
        }
        catch (SQLException ex) {
            try {
                con.rollback();
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeStatement(stmt2);
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        this.closeStatement(stmt2);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createFormTemplateLink(String formtemplateId, String organizationId) throws SQLException {
        String string;
        Connection con = null;
        PreparedStatement stmt = null;
        String sql = this.createInsertSQL("ss_formlinks", new String[]{"template_id", "organization_id", "link_id"});
        String uniqueLinkId = this.generateUniqueLinkId();
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, formtemplateId);
            stmt.setString(2, organizationId);
            stmt.setString(3, uniqueLinkId);
            stmt.executeUpdate();
            string = uniqueLinkId;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGuidance(FormGuidance fg) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"guidance_id", "template_id", "section_id", "subject", "body", "weblink", "imagepath", "is_expanded", "is_deleted", "created", "modified"};
        String sql = this.createInsertSQL(TBL_GUIDANCE, cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, fg.getId());
            stmt.setString(2, fg.getFormtemplateId());
            stmt.setString(3, fg.getSectionId());
            stmt.setString(4, fg.getSubject());
            stmt.setString(5, fg.getBody());
            stmt.setString(6, fg.getUrlLink());
            stmt.setString(7, fg.getImage());
            stmt.setInt(8, fg.isExpanded() ? 1 : 0);
            stmt.setInt(9, fg.isDeleted() ? 1 : 0);
            stmt.setTimestamp(10, new Timestamp(fg.getDateCreated()));
            stmt.setTimestamp(11, new Timestamp(fg.getDateModified()));
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormGuidance getGuidance(String guidanceId) throws SQLException {
        FormGuidance formGuidance;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        FormGuidance fg = null;
        String sql = "SELECT g.guidance_id, g.template_id, g.section_id, g.subject, g.body, g.weblink, g.imagepath, g.is_expanded, g.is_deleted, g.created, g.modified WHERE g.guidance_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, guidanceId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                fg = new FormGuidance(rs);
            }
            rs.close();
            formGuidance = fg;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return formGuidance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGuidance(FormGuidance fg) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"section_id", "subject", "body", "weblink", "imagepath", "is_expanded", "is_deleted", "modified", "guidance_id"};
        String sql = this.createUpdateSQL(TBL_GUIDANCE, cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, fg.getSectionId());
            stmt.setString(2, fg.getSubject());
            stmt.setString(3, fg.getBody());
            stmt.setString(4, fg.getUrlLink());
            stmt.setString(5, fg.getImage());
            stmt.setInt(6, fg.isExpanded() ? 1 : 0);
            stmt.setInt(7, fg.isDeleted() ? 1 : 0);
            stmt.setTimestamp(8, new Timestamp(fg.getDateModified()));
            stmt.setString(9, fg.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, Hashtable<String, String>> getFormTemplateMapping() throws SQLException {
        Hashtable<String, Hashtable<String, String>> hashtable;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        Hashtable<String, Hashtable<String, String>> ht = new Hashtable<String, Hashtable<String, String>>();
        String sql = "SELECT l.template_id, l.organization_id, l.link_id FROM ss_formlinks l ORDER BY l.template_id";
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                Hashtable<Object, Object> map;
                String templateId = rs.getString("template_id");
                String organizationId = rs.getString("organization_id");
                String linkToken = rs.getString("link_id");
                if (ht.containsKey(templateId)) {
                    map = ht.get(templateId);
                    map.put(organizationId, linkToken);
                    continue;
                }
                map = new Hashtable();
                map.put(organizationId, linkToken);
                ht.put(templateId, map);
            }
            rs.close();
            hashtable = ht;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, String> getFormTemplateMapping(String organizationId) throws SQLException {
        Hashtable<String, String> hashtable;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        String sql = "SELECT l.template_id, l.link_id FROM ss_formlinks l WHERE l.organization_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, organizationId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String templateId = rs.getString("template_id");
                String linkToken = rs.getString("link_id");
                ht.put(templateId, linkToken);
            }
            rs.close();
            hashtable = ht;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormTemplateIdByToken(String token) throws SQLException {
        String string;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String templateId = null;
        String sql = "SELECT l.template_id FROM ss_formlinks l WHERE l.link_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, token);
            rs = stmt.executeQuery();
            if (rs.next()) {
                templateId = rs.getString("template_id");
            }
            rs.close();
            string = templateId;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return string;
    }

    private final synchronized String generateUniqueLinkId() throws SQLException {
        Set<String> existingsIds = this.getLinkIds();
        String uid = null;
        while (existingsIds.contains(uid = RandomStringUtils.randomAlphanumeric((int)6).toUpperCase())) {
        }
        return uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getLinkIds() throws SQLException {
        HashSet<String> hashSet;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        HashSet<String> list = new HashSet<String>();
        String sql = "SELECT l.link_id FROM ss_formlinks l";
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                list.add(rs.getString("link_id"));
            }
            rs.close();
            hashSet = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSecondaryFormTemplateLinks(FormTemplate ft) throws SQLException {
        int i;
        if (ft.getSecondaryReferences().isEmpty()) {
            return;
        }
        Hashtable<String, SecondaryForm> ht = new Hashtable<String, SecondaryForm>();
        List<SecondaryForm> refs = ft.getSecondaryReferences();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "SELECT l.template_id, l.organization_id, l.link_id FROM ss_formlinks l WHERE l.template_id = ? ";
        for (i = 0; i < refs.size(); ++i) {
            SecondaryForm sf = refs.get(i);
            ht.put(sf.getTemplateId(), sf);
            if (i <= 0) continue;
            sql = sql + " OR l.template_id = ? ";
        }
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            for (i = 0; i < refs.size(); ++i) {
                stmt.setString(i + 1, refs.get(i).getTemplateId());
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                String templateId = rs.getString("template_id");
                if (!ht.containsKey(templateId)) continue;
                ((SecondaryForm)ht.get(templateId)).getLinkMap().put(rs.getString("organization_id"), rs.getString("link_id"));
            }
            rs.close();
            for (SecondaryForm sf : refs) {
                if (!sf.getLinkMap().isEmpty() || !ht.containsKey(sf.getTemplateId())) continue;
                sf.getLinkMap().putAll(((SecondaryForm)ht.get(sf.getTemplateId())).getLinkMap());
            }
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFormTemplateLinks(String organizationId) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String sql = "DELETE FROM ss_formlinks WHERE organization_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, organizationId);
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormTemplateFile getFormTemplateFile(String templateId, FormTemplateFile.Tag tag, boolean includeStream) throws SQLException, IOException {
        FormTemplateFile formTemplateFile;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        FormTemplateFile templateFile = null;
        String sql = "SELECT f.file_id, f.template_id, f.filename, f.type, f.tag, ";
        if (includeStream) {
            sql = sql + "f.stream,";
        }
        sql = sql + " f.created, f.modified, f.is_deleted FROM ss_formfiles f WHERE f.template_id = ? AND f.tag = ? AND f.is_deleted = 0";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, templateId);
            stmt.setString(2, tag.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                templateFile = new FormTemplateFile(rs);
                if (includeStream) {
                    InputStream is = rs.getBinaryStream("stream");
                    byte[] bytes = new byte[is.available()];
                    is.read(bytes);
                    is.close();
                    templateFile.setStream(bytes);
                }
            }
            rs.close();
            formTemplateFile = templateFile;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return formTemplateFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTranslation(FormTranslation trans) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"translation_id", "template_id", "title", "isocode", "stream", "is_enabled", "is_deleted", "created", "modified"};
        String sql = this.createInsertSQL(TBL_TRANSLATIONS, cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, trans.getId());
            stmt.setString(2, trans.getTemplateId());
            stmt.setString(3, trans.getLanguage());
            stmt.setString(4, trans.getIsocode());
            stmt.setBinaryStream(5, (InputStream)new ByteArrayInputStream(trans.getStream()), trans.getStream().length);
            stmt.setInt(6, trans.isEnabled() ? 1 : 0);
            stmt.setInt(7, trans.isDeleted() ? 1 : 0);
            stmt.setTimestamp(8, new Timestamp(trans.getDateCreated()));
            stmt.setTimestamp(9, new Timestamp(trans.getDateModified()));
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FormTranslation> getTranslations(String templateId) throws SQLException {
        ArrayList<FormTranslation> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<FormTranslation> list = new ArrayList<FormTranslation>();
        String sql = "SELECT t.translation_id, t.template_id, t.title, t.isocode,t.is_enabled, t.is_deleted, t.created, t.modified FROM ss_formtranslations t WHERE t.is_deleted = 0 AND t.template_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, templateId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                FormTranslation trans = new FormTranslation(rs);
                list.add(trans);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormTranslation getTranslation(String translationId) throws SQLException, IOException {
        FormTranslation formTranslation;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        FormTranslation trans = null;
        String sql = "SELECT t.translation_id, t.template_id, t.title, t.isocode,t.stream, t.is_enabled, t.is_deleted, t.created, t.modified FROM ss_formtranslations t WHERE t.is_deleted = 0 AND t.translation_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, translationId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                trans = new FormTranslation(rs);
                InputStream is = rs.getBinaryStream("stream");
                byte[] bytes = new byte[is.available()];
                is.read(bytes);
                is.close();
                trans.setStream(bytes);
            }
            rs.close();
            formTranslation = trans;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return formTranslation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTranslation(FormTranslation trans) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"title", "isocode", "stream", "is_enabled", "is_deleted", "modified", "translation_id"};
        String sql = this.createUpdateSQL(TBL_TRANSLATIONS, cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, trans.getLanguage());
            stmt.setString(2, trans.getIsocode());
            stmt.setBinaryStream(3, (InputStream)new ByteArrayInputStream(trans.getStream()), trans.getStream().length);
            stmt.setInt(4, trans.isEnabled() ? 1 : 0);
            stmt.setInt(5, trans.isDeleted() ? 1 : 0);
            stmt.setTimestamp(6, new Timestamp(trans.getDateModified()));
            stmt.setString(7, trans.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FormTranslation> getTranslations() throws SQLException {
        ArrayList<FormTranslation> arrayList;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<FormTranslation> list = new ArrayList<FormTranslation>();
        String sql = "SELECT t.translation_id, t.template_id, t.title, t.isocode,t.is_enabled, t.is_deleted, t.created, t.modified FROM ss_formtranslations t WHERE t.is_deleted = 0";
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                list.add(new FormTranslation(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }
}

