/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.dalc;

import is.hugvit.util.UID;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import net.gopro.selfservice.CaseFactory;
import net.gopro.selfservice.ExternalDocumentFactory;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.dalc.BaseDalc;
import net.gopro.selfservice.data.AccessControl;
import net.gopro.selfservice.data.Attachment;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.Case;
import net.gopro.selfservice.data.CaseTemplate;
import net.gopro.selfservice.data.CheckoutTicket;
import net.gopro.selfservice.data.Email;
import net.gopro.selfservice.data.EmailAttachment;
import net.gopro.selfservice.data.EmailRecipient;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.Memo;
import net.gopro.selfservice.data.Reference;
import net.gopro.selfservice.data.SecondaryForm;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.StringUtil;

public class CaseDalc
extends BaseDalc {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCase(BaseCase bc) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"case_id", "createdby_id", "organization_id", "gopro_id", "gopro_casenumber", "reference_number", "subject", "body", "is_sent", "is_deleted", "created", "modified", "completed", "classname", "formtemplate_id", "status_id", "is_fromgopro", "is_signed", "is_signaturepending", "is_reopened", "is_shared", "is_sensitive", "responsecount", "targetgroup_id", "company_id", "casetemplate_id", "contact_id", "modifiedby_id", "completedby_id", "parent_id"};
        String sql = this.createInsertSQL("ss_cases", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            String formtemplateId = null;
            String parentId = null;
            String targetgroupId = null;
            boolean isFromGopro = false;
            boolean isShared = false;
            if (bc instanceof FormCase) {
                formtemplateId = ((FormCase)bc).getFormtemplateId();
                isShared = ((FormCase)bc).isShared();
                parentId = ((FormCase)bc).getParentId();
            } else if (bc instanceof Case) {
                isFromGopro = ((Case)bc).isFromGoPro();
                targetgroupId = ((Case)bc).getTargetGroupId();
            }
            stmt.setString(1, bc.getId());
            stmt.setString(2, bc.getCreatedById());
            stmt.setString(3, bc.getOrganizationId());
            stmt.setString(4, bc.getGoProId());
            stmt.setString(5, bc.getGoProCaseNumber());
            stmt.setString(6, bc.getReferenceNumber());
            stmt.setString(7, bc.getSubject());
            stmt.setString(8, bc.getBody());
            stmt.setInt(9, bc.isSent() ? 1 : 0);
            stmt.setInt(10, bc.isDeleted() ? 1 : 0);
            stmt.setTimestamp(11, new Timestamp(bc.getDateCreated()));
            stmt.setTimestamp(12, new Timestamp(bc.getDateModified()));
            if (bc.getDateCompleted() == 0L) {
                stmt.setNull(13, 93);
            } else {
                stmt.setTimestamp(13, new Timestamp(bc.getDateCompleted()));
            }
            stmt.setString(14, bc.getClass().getName());
            stmt.setString(15, formtemplateId);
            stmt.setString(16, bc.getStatusId());
            stmt.setInt(17, isFromGopro ? 1 : 0);
            stmt.setInt(18, bc.isSigned() ? 1 : 0);
            stmt.setInt(19, bc.isSignaturePending() ? 1 : 0);
            stmt.setInt(20, 0);
            stmt.setInt(21, isShared ? 1 : 0);
            stmt.setInt(22, bc.isPersonalSensitive() ? 1 : 0);
            stmt.setInt(23, bc.getResponseCount());
            stmt.setString(24, targetgroupId);
            stmt.setString(25, bc.getCompanyId());
            stmt.setString(26, bc.getCaseTemplateId());
            stmt.setString(27, bc.getContactId());
            stmt.setString(28, bc.getModifiedById());
            stmt.setString(29, bc.getCompletedById());
            stmt.setString(30, parentId);
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseCase getCase(String caseId, String userContextId) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        BaseCase bc = null;
        String sql = this.getQuery("getCase");
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, caseId);
            stmt.setString(2, userContextId);
            stmt.setString(3, userContextId);
            stmt.setString(4, userContextId);
            stmt.setString(5, userContextId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                bc = CaseFactory.getInstance(rs.getString("classname"), rs);
            }
            rs.close();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return bc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseCase getCaseByGoProId(String goproDocumentId, String organizationId, String userContextId) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        BaseCase bc = null;
        String sql = organizationId != null ? this.getQuery("getCaseByGoProIdAndOid") : this.getQuery("getCaseByGoProId");
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, goproDocumentId);
            if (organizationId != null) {
                stmt.setString(2, organizationId);
                stmt.setString(3, userContextId);
                stmt.setString(4, userContextId);
                stmt.setString(5, userContextId);
                stmt.setString(6, userContextId);
            } else {
                stmt.setString(2, userContextId);
                stmt.setString(3, userContextId);
                stmt.setString(4, userContextId);
                stmt.setString(5, userContextId);
            }
            rs = stmt.executeQuery();
            if (rs.next()) {
                bc = CaseFactory.getInstance(rs.getString("classname"), rs);
            }
            rs.close();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return bc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCase(BaseCase bc) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"gopro_id", "gopro_casenumber", "subject", "body", "is_sent", "is_deleted", "modified", "completed", "formtemplate_id", "status_id", "targetgroup_id", "company_id", "casetemplate_id", "is_signed", "is_signaturepending", "is_reopened", "is_shared", "is_sensitive", "contact_id", "modifiedby_id", "completedby_id", "createdby_id", "parent_id", "case_id"};
        String sql = this.createUpdateSQL("ss_cases", cols);
        try {
            String formtemplateId = null;
            String parentId = null;
            String targetgroupId = null;
            boolean isShared = false;
            if (bc instanceof FormCase) {
                formtemplateId = ((FormCase)bc).getFormtemplateId();
                isShared = ((FormCase)bc).isShared();
                parentId = ((FormCase)bc).getParentId();
            } else if (bc instanceof Case) {
                targetgroupId = ((Case)bc).getTargetGroupId();
            }
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, bc.getGoProId());
            stmt.setString(2, bc.getGoProCaseNumber());
            stmt.setString(3, bc.getSubject());
            stmt.setString(4, bc.getBody());
            stmt.setInt(5, bc.isSent() ? 1 : 0);
            stmt.setInt(6, bc.isDeleted() ? 1 : 0);
            stmt.setTimestamp(7, new Timestamp(bc.getDateModified()));
            if (bc.getDateCompleted() == 0L) {
                stmt.setNull(8, 93);
            } else {
                stmt.setTimestamp(8, new Timestamp(bc.getDateCompleted()));
            }
            stmt.setString(9, formtemplateId);
            stmt.setString(10, bc.getStatusId());
            stmt.setString(11, targetgroupId);
            stmt.setString(12, bc.getCompanyId());
            stmt.setString(13, bc.getCaseTemplateId());
            stmt.setInt(14, bc.isSigned() ? 1 : 0);
            stmt.setInt(15, bc.isSignaturePending() ? 1 : 0);
            stmt.setInt(16, bc.isReOpened() ? 1 : 0);
            stmt.setInt(17, isShared ? 1 : 0);
            stmt.setInt(18, bc.isPersonalSensitive() ? 1 : 0);
            stmt.setString(19, bc.getContactId());
            stmt.setString(20, bc.getModifiedById());
            stmt.setString(21, bc.getCompletedById());
            stmt.setString(22, bc.getCreatedById());
            stmt.setString(23, parentId);
            stmt.setString(24, bc.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    public void createExternalDocument(ExternalDocument doc) throws SQLException {
        Connection con = null;
        PreparedStatement stmtStream = null;
        PreparedStatement stmt = null;
        String[] colsStream = new String[]{"stream_id", "stream"};
        String[] colsDocs = new String[]{"document_id", "case_id", "parent_id", "gopro_id", "subject", "body", "is_sent", "filesize", "filename", "mimetype", "stream_id", "is_deleted", "created", "modified", "completed", "classname", "is_fromgopro", "createdby_id", "status_id", "savecounter", "responsecount", "modifiedby_id", "completedby_id", "is_signed", "is_signaturepending", "is_sensitive"};
        String streamId = UID.getUID();
        try {
            con = this.startTransaction();
            String sql = this.createInsertSQL("ss_streams", colsStream);
            stmtStream = con.prepareStatement(sql);
            stmtStream.setString(1, streamId);
            stmtStream.setBinaryStream(2, (InputStream)new ByteArrayInputStream(doc.getStream()), doc.getStream().length);
            stmtStream.execute();
            sql = this.createInsertSQL("ss_documents", colsDocs);
            stmt = con.prepareStatement(sql);
            stmt.setString(1, doc.getId());
            stmt.setString(2, doc.getCaseId());
            stmt.setString(3, doc.getParentId());
            stmt.setString(4, doc.getGoProId());
            stmt.setString(5, doc.getSubject());
            stmt.setString(6, doc.getBody());
            stmt.setInt(7, doc.isSent() ? 1 : 0);
            stmt.setLong(8, doc.getFilesize());
            stmt.setString(9, doc.getFilename());
            stmt.setString(10, doc.getMimetype());
            stmt.setString(11, streamId);
            stmt.setInt(12, doc.isDeleted() ? 1 : 0);
            stmt.setTimestamp(13, new Timestamp(doc.getDateCreated()));
            stmt.setTimestamp(14, new Timestamp(doc.getDateModified()));
            if (doc.getDateCompleted() == 0L) {
                stmt.setNull(15, 93);
            } else {
                stmt.setTimestamp(15, new Timestamp(doc.getDateCompleted()));
            }
            stmt.setString(16, doc.getClass().getName());
            stmt.setInt(17, doc.isFromGoPro() ? 1 : 0);
            stmt.setString(18, doc.getCreatedById());
            stmt.setString(19, doc.getStatusId());
            stmt.setInt(20, doc.getSaveCounter());
            stmt.setInt(21, doc.getResponseCount());
            stmt.setString(22, doc.getModifiedById());
            stmt.setString(23, doc.getCompletedById());
            boolean isSigned = false;
            boolean isSignaturePending = false;
            if (doc instanceof Attachment) {
                isSigned = ((Attachment)doc).isSigned();
                isSignaturePending = ((Attachment)doc).isSignaturePending();
            }
            stmt.setInt(24, isSigned ? 1 : 0);
            stmt.setInt(25, isSignaturePending ? 1 : 0);
            stmt.setInt(26, doc.isPersonalSensitive() ? 1 : 0);
            stmt.execute();
            this.commitTransaction();
        }
        catch (SQLException ex) {
            try {
                con.rollback();
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeStatement(stmtStream);
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        this.closeStatement(stmtStream);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMemo(Memo memo) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"memo_id", "case_id", "parent_id", "gopro_id", "createdby_id", "status_id", "subject", "body", "savecounter", "responsecount", "is_sent", "is_fromgopro", "is_deleted", "created", "modified", "completed", "modifiedby_id", "completedby_id", "is_sensitive"};
        String sql = this.createInsertSQL("ss_memos", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, memo.getId());
            stmt.setString(2, memo.getCaseId());
            stmt.setString(3, memo.getParentId());
            stmt.setString(4, memo.getGoProId());
            stmt.setString(5, memo.getCreatedById());
            stmt.setString(6, memo.getStatusId());
            stmt.setString(7, memo.getSubject());
            stmt.setString(8, memo.getBody());
            stmt.setInt(9, memo.getSaveCounter());
            stmt.setInt(10, memo.getResponseCount());
            stmt.setInt(11, memo.isSent() ? 1 : 0);
            stmt.setInt(12, memo.isFromGoPro() ? 1 : 0);
            stmt.setInt(13, memo.isDeleted() ? 1 : 0);
            stmt.setTimestamp(14, new Timestamp(memo.getDateCreated()));
            stmt.setTimestamp(15, new Timestamp(memo.getDateModified()));
            if (memo.getDateCompleted() == 0L) {
                stmt.setNull(16, 93);
            } else {
                stmt.setTimestamp(16, new Timestamp(memo.getDateCompleted()));
            }
            stmt.setString(17, memo.getModifiedById());
            stmt.setString(18, memo.getCompletedById());
            stmt.setInt(19, memo.isPersonalSensitive() ? 1 : 0);
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMemo(Memo memo) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"gopro_id", "parent_id", "status_id", "subject", "body", "savecounter", "responsecount", "is_sent", "is_deleted", "is_sensitive", "modified", "completed", "modifiedby_id", "completedby_id", "memo_id"};
        String sql = this.createUpdateSQL("ss_memos", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, memo.getGoProId());
            stmt.setString(2, memo.getParentId());
            stmt.setString(3, memo.getStatusId());
            stmt.setString(4, memo.getSubject());
            stmt.setString(5, memo.getBody());
            stmt.setInt(6, memo.getSaveCounter());
            stmt.setInt(7, memo.getResponseCount());
            stmt.setInt(8, memo.isSent() ? 1 : 0);
            stmt.setInt(9, memo.isDeleted() ? 1 : 0);
            stmt.setInt(10, memo.isPersonalSensitive() ? 1 : 0);
            stmt.setTimestamp(11, new Timestamp(memo.getDateModified()));
            if (memo.getDateCompleted() == 0L) {
                stmt.setNull(12, 93);
            } else {
                stmt.setTimestamp(12, new Timestamp(memo.getDateCompleted()));
            }
            stmt.setString(13, memo.getModifiedById());
            stmt.setString(14, memo.getCompletedById());
            stmt.setString(15, memo.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    public void updateExternalDocument(ExternalDocument doc) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        PreparedStatement stmtStream = null;
        String[] cols = new String[]{"case_id", "gopro_id", "parent_id", "createdby_id", "status_id", "subject", "body", "is_sent", "is_fromgopro", "filesize", "filename", "mimetype", "is_deleted", "modified", "completed", "savecounter", "responsecount", "modifiedby_id", "completedby_id", "is_signed", "is_signaturepending", "is_sensitive", "document_id"};
        String sql = this.createUpdateSQL("ss_documents", cols);
        try {
            con = this.startTransaction();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, doc.getCaseId());
            stmt.setString(2, doc.getGoProId());
            stmt.setString(3, doc.getParentId());
            stmt.setString(4, doc.getCreatedById());
            stmt.setString(5, doc.getStatusId());
            stmt.setString(6, doc.getSubject());
            stmt.setString(7, doc.getBody());
            stmt.setInt(8, doc.isSent() ? 1 : 0);
            stmt.setInt(9, doc.isFromGoPro() ? 1 : 0);
            stmt.setLong(10, doc.getFilesize());
            stmt.setString(11, doc.getFilename());
            stmt.setString(12, doc.getMimetype());
            stmt.setInt(13, doc.isDeleted() ? 1 : 0);
            stmt.setTimestamp(14, new Timestamp(doc.getDateModified()));
            if (doc.getDateCompleted() == 0L) {
                stmt.setNull(15, 93);
            } else {
                stmt.setTimestamp(15, new Timestamp(doc.getDateCompleted()));
            }
            stmt.setInt(16, doc.getSaveCounter());
            stmt.setInt(17, doc.getResponseCount());
            stmt.setString(18, doc.getModifiedById());
            stmt.setString(19, doc.getCompletedById());
            boolean isSigned = false;
            boolean isSignaturePending = false;
            if (doc instanceof Attachment) {
                isSigned = ((Attachment)doc).isSigned();
                isSignaturePending = ((Attachment)doc).isSignaturePending();
            }
            stmt.setInt(20, isSigned ? 1 : 0);
            stmt.setInt(21, isSignaturePending ? 1 : 0);
            stmt.setInt(22, doc.isPersonalSensitive() ? 1 : 0);
            stmt.setString(23, doc.getId());
            stmt.executeUpdate();
            boolean isMSSQL = "Microsoft SQL Server".equalsIgnoreCase(this.getSqlServiceType(con));
            sql = isMSSQL ? "UPDATE ss_streams SET stream = ? FROM ss_documents d JOIN ss_streams s ON d.stream_id  = s.stream_id WHERE d.document_id = ?" : "UPDATE ss_streams s JOIN ss_documents d ON d.stream_id = s.stream_id SET s.stream = ? WHERE d.document_id = ?";
            stmtStream = con.prepareStatement(sql);
            stmtStream.setBinaryStream(1, (InputStream)new ByteArrayInputStream(doc.getStream()), doc.getStream().length);
            stmtStream.setString(2, doc.getId());
            stmtStream.executeUpdate();
            this.commitTransaction();
        }
        catch (SQLException ex) {
            try {
                con.rollback();
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeStatement(stmtStream);
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        this.closeStatement(stmtStream);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BaseCase> getCases(String userId) throws SQLException {
        ArrayList<BaseCase> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<BaseCase> caseList = new ArrayList<BaseCase>();
        String sql = this.getQuery("getCases");
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, userId);
            stmt.setString(2, userId);
            stmt.setString(3, userId);
            stmt.setString(4, userId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                BaseCase bc = CaseFactory.getInstance(rs.getString("classname"), rs);
                caseList.add(bc);
            }
            rs.close();
            arrayList = caseList;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BaseCase> getCasesByParentId(String parentId, String userContextId) throws SQLException {
        ArrayList<BaseCase> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<BaseCase> caseList = new ArrayList<BaseCase>();
        String sql = this.getQuery("getCasesByParentId");
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, parentId);
            stmt.setString(2, userContextId);
            stmt.setString(3, userContextId);
            stmt.setString(4, userContextId);
            stmt.setString(5, userContextId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                BaseCase bc = CaseFactory.getInstance(rs.getString("classname"), rs);
                caseList.add(bc);
            }
            rs.close();
            arrayList = caseList;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FormCase> getCasesByFormTemplate(String userId, String templateId, String userContextId) throws SQLException {
        ArrayList<FormCase> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<FormCase> caseList = new ArrayList<FormCase>();
        String sql = this.getQuery("getCasesByFormTemplate");
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, templateId);
            stmt.setString(2, userContextId);
            stmt.setString(3, userContextId);
            stmt.setString(4, userContextId);
            stmt.setString(5, userContextId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                BaseCase bc = CaseFactory.getInstance(rs.getString("classname"), rs);
                caseList.add((FormCase)bc);
            }
            rs.close();
            arrayList = caseList;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SubDocument> getMemos(String caseId, String userContextId) throws SQLException {
        ArrayList<SubDocument> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<SubDocument> list = new ArrayList<SubDocument>();
        String sql = this.getQuery("getMemos");
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, caseId);
            stmt.setString(2, userContextId);
            stmt.setString(3, userContextId);
            stmt.setString(4, userContextId);
            stmt.setString(5, userContextId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                Memo memo = new Memo(rs);
                memo.setStatusText(rs.getString("statusname"));
                memo.setAuthorName(rs.getString("authorName"));
                list.add(memo);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SubDocument> getExternalDocuments(String caseId, boolean includeStream, String userContextId) throws SQLException, IOException {
        ArrayList<SubDocument> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<SubDocument> list = new ArrayList<SubDocument>();
        String sql = this.getQuery("getExternalDocuments");
        if (!includeStream) {
            sql = sql.replace("s.stream,", "");
        }
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, caseId);
            stmt.setString(2, userContextId);
            stmt.setString(3, userContextId);
            stmt.setString(4, userContextId);
            stmt.setString(5, userContextId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String className = rs.getString("classname");
                ExternalDocument doc = ExternalDocumentFactory.getInstance(className, rs);
                doc.setStatusText(rs.getString("statusname"));
                doc.setAuthorName(rs.getString("authorName"));
                if (doc instanceof ExternalDocument && includeStream) {
                    InputStream is = rs.getBinaryStream("stream");
                    byte[] bytes = new byte[is.available()];
                    is.read(bytes);
                    is.close();
                    doc.setStream(bytes);
                }
                list.add(doc);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Memo getMemo(String documentId, String userContextId) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Memo memo = null;
        String sql = this.getQuery("getMemo");
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, documentId);
            stmt.setString(2, userContextId);
            stmt.setString(3, userContextId);
            stmt.setString(4, userContextId);
            stmt.setString(5, userContextId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                memo = new Memo(rs);
            }
            rs.close();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return memo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Memo getMemoByGoProId(String documentId, String userContextId) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Memo memo = null;
        String sql = this.getQuery("getMemoByGoProId");
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, this.getUUIDHyphened(documentId));
            stmt.setString(2, this.getUUIDStripped(documentId));
            stmt.setString(3, userContextId);
            stmt.setString(4, userContextId);
            stmt.setString(5, userContextId);
            stmt.setString(6, userContextId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                memo = new Memo(rs);
            }
            rs.close();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return memo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Email getEmailByGoProId(String documentId) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Email email = null;
        String sql = "SELECT e.email_id, e.case_id, e.parent_id, e.gopro_id, e.createdby_id, e.status_id,e.subject, e.body, e.fromname, e.fromemail, e.savecounter, e.responsecount, e.is_sent, e.is_sensitive, e.is_fromgopro, e.is_deleted, e.created, e.modified, e.completed, e.modifiedby_id, e.completedby_id FROM ss_emails e WHERE e.gopro_id = ? OR e.gopro_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, this.getUUIDStripped(documentId));
            stmt.setString(2, this.getUUIDHyphened(documentId));
            rs = stmt.executeQuery();
            if (rs.next()) {
                email = new Email(rs);
            }
            rs.close();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return email;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalDocument getExternalDocument(String documentId, boolean includeStream, String userContextId) throws SQLException, IOException {
        ExternalDocument externalDocument;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ExternalDocument doc = null;
        String sql = includeStream ? this.getQuery("getExternalDocumentStream") : this.getQuery("getExternalDocument");
        try {
            String className;
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, documentId);
            stmt.setString(2, userContextId);
            stmt.setString(3, userContextId);
            stmt.setString(4, userContextId);
            stmt.setString(5, userContextId);
            rs = stmt.executeQuery();
            if (rs.next() && (doc = ExternalDocumentFactory.getInstance(className = rs.getString("classname"), rs)) != null && includeStream) {
                InputStream is = rs.getBinaryStream("stream");
                byte[] bytes = new byte[is.available()];
                is.read(bytes);
                is.close();
                doc.setStream(bytes);
            }
            rs.close();
            externalDocument = doc;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return externalDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalDocument getExternalDocumentByGoProId(String goproDocumentId, boolean includeStream, String userContextId) throws SQLException, IOException {
        ExternalDocument externalDocument;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ExternalDocument doc = null;
        String sql = includeStream ? this.getQuery("getExternalDocumentByGoProIdStream") : this.getQuery("getExternalDocumentByGoProId");
        try {
            String className;
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, this.getUUIDHyphened(goproDocumentId));
            stmt.setString(2, this.getUUIDStripped(goproDocumentId));
            stmt.setString(3, userContextId);
            stmt.setString(4, userContextId);
            stmt.setString(5, userContextId);
            stmt.setString(6, userContextId);
            rs = stmt.executeQuery();
            if (rs.next() && (doc = ExternalDocumentFactory.getInstance(className = rs.getString("classname"), rs)) != null && includeStream) {
                InputStream is = rs.getBinaryStream("stream");
                byte[] bytes = new byte[is.available()];
                is.read(bytes);
                is.close();
                doc.setStream(bytes);
            }
            rs.close();
            externalDocument = doc;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return externalDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMemo(Memo doc) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"is_deleted", "modified", "memo_id"};
        String sql = this.createUpdateSQL("ss_memos", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setInt(1, doc.isDeleted() ? 1 : 0);
            stmt.setTimestamp(2, new Timestamp(doc.getDateModified()));
            stmt.setString(3, doc.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEmail(Email doc) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"is_deleted", "modified", "email_id"};
        String sql = this.createUpdateSQL("ss_emails", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setInt(1, doc.isDeleted() ? 1 : 0);
            stmt.setTimestamp(2, new Timestamp(doc.getDateModified()));
            stmt.setString(3, doc.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteExternalDocument(ExternalDocument doc) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"is_deleted", "modified", "document_id"};
        String sql = this.createUpdateSQL("ss_documents", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setInt(1, doc.isDeleted() ? 1 : 0);
            stmt.setTimestamp(2, new Timestamp(doc.getDateModified()));
            stmt.setString(3, doc.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateCaseStatus(BaseCase bc) throws SQLException, SelfServiceException {
        boolean bl;
        Connection con = null;
        PreparedStatement stmt = null;
        String sql = this.createUpdateSQL("ss_cases", new String[]{"status_id", "modified", "case_id"});
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, bc.getStatusId());
            stmt.setTimestamp(2, new Timestamp(bc.getDateModified()));
            stmt.setString(3, bc.getId());
            bl = stmt.executeUpdate() == 1;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSubdocumentStatus(SubDocument doc) throws SQLException, SelfServiceException {
        Connection con = null;
        PreparedStatement stmt = null;
        String sql = "";
        if (doc instanceof ExternalDocument) {
            sql = this.createUpdateSQL("ss_documents", new String[]{"status_id", "modified", "document_id"});
        } else if (doc instanceof Memo) {
            sql = this.createUpdateSQL("ss_memos", new String[]{"status_id", "modified", "memo_id"});
        } else if (doc instanceof Email) {
            sql = this.createUpdateSQL("ss_emails", new String[]{"status_id", "modified", "email_id"});
        } else {
            throw new SelfServiceException("The Document Type: " + doc.getClass().getName() + " is not supported.");
        }
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, doc.getStatusId());
            stmt.setTimestamp(2, new Timestamp(doc.getDateModified()));
            stmt.setString(3, doc.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSubdocumentSentStatus(SubDocument doc, boolean isSent) throws SQLException, SelfServiceException {
        Connection con = null;
        PreparedStatement stmt = null;
        String sql = "";
        if (doc instanceof ExternalDocument) {
            sql = this.createUpdateSQL("ss_documents", new String[]{"is_sent", "completed", "completedby_id", "document_id"});
        } else if (doc instanceof Memo) {
            sql = this.createUpdateSQL("ss_memos", new String[]{"is_sent", "completed", "completedby_id", "memo_id"});
        } else {
            throw new SelfServiceException("The Document Type: " + doc.getClass().getName() + " is not supported.");
        }
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setInt(1, isSent ? 1 : 0);
            stmt.setTimestamp(2, new Timestamp(doc.getDateCompleted()));
            stmt.setString(3, doc.getCompletedById());
            stmt.setString(4, doc.getId());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, String> getCaseTypesInUse(String userId) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        String sql = this.getQuery("getCaseTypesInUse");
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, userId);
            stmt.setString(2, userId);
            stmt.setString(3, userId);
            stmt.setString(4, userId);
            stmt.setString(5, "00278849E25F336B0000012E156D54D9");
            stmt.setString(6, userId);
            stmt.setString(7, userId);
            stmt.setString(8, userId);
            stmt.setString(9, userId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ht.put(rs.getString("template"), rs.getString("subject"));
            }
            rs.close();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return ht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, String> getFormTypesInUse(String userId) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        String sql = "SELECT DISTINCT t.template_id, t.subject FROM ss_formtemplates t INNER JOIN ss_cases c ON c.formtemplate_id = t.template_id WHERE c.createdby_id = ? AND c.is_deleted = 0 AND t.is_deleted = 0 ";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, userId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ht.put(rs.getString("template_id"), rs.getString("subject"));
            }
            rs.close();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return ht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCaseTemplate(CaseTemplate ct) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"casetemplate_id", "subject", "description", "category_id", "customclass", "timelimit", "is_system", "is_visible", "is_inview", "is_secondary", "sec_handle", "created", "modified", "is_deleted"};
        String sql = this.createInsertSQL("ss_casetemplates", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, ct.getId());
            stmt.setString(2, ct.getSubject());
            stmt.setString(3, ct.getDescription());
            stmt.setString(4, ct.getCategoryId());
            stmt.setString(5, ct.getCustomClass());
            stmt.setInt(6, ct.getTimeLimitInDays());
            stmt.setInt(7, ct.isSystemTemplate() ? 1 : 0);
            stmt.setInt(8, ct.isVisible() ? 1 : 0);
            stmt.setInt(9, ct.isVisibleInDefaultView() ? 1 : 0);
            stmt.setInt(10, ct.isSecondaryEnabled() ? 1 : 0);
            stmt.setInt(11, ct.getSecondaryHandling().getCode());
            stmt.setTimestamp(12, new Timestamp(ct.getDateCreated()));
            stmt.setTimestamp(13, new Timestamp(ct.getDateModified()));
            stmt.setInt(14, ct.isDeleted() ? 1 : 0);
            stmt.executeUpdate();
            stmt.close();
            if (ct.isSecondaryEnabled()) {
                String secondarySql = this.createInsertSQL("ss_secondaries", new String[]{"parent_id", "template_id", "status_id", "timelimit"});
                stmt = con.prepareStatement(secondarySql);
                for (SecondaryForm sf : ct.getSecondaryReferences()) {
                    stmt.setString(1, ct.getId());
                    stmt.setString(2, sf.getTemplateId());
                    stmt.setString(3, sf.getStatusId());
                    stmt.setInt(4, sf.getTimelimit());
                    stmt.executeUpdate();
                }
            }
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CaseTemplate getCaseTemplate(String caseTemplateId) throws SQLException {
        CaseTemplate ct;
        PreparedStatement stmt;
        Connection con;
        block5: {
            con = null;
            stmt = null;
            ResultSet rs = null;
            ct = null;
            String sql = "SELECT c.casetemplate_id, c.subject, c.description, c.category_id, c.timelimit, c.is_system, c.is_visible, c.is_secondary, c.sec_handle, c.is_inview, c.customclass, c.created, c.modified, c.is_deleted, l.subject AS categoryname FROM ss_casetemplates c LEFT OUTER JOIN ss_listitems l on c.category_id = l.item_id WHERE c.casetemplate_id = ?";
            try {
                con = this.getConnection();
                stmt = con.prepareStatement(sql);
                stmt.setString(1, caseTemplateId);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    ct = new CaseTemplate(rs);
                    ct.setCategoryName(rs.getString("categoryname"));
                }
                rs.close();
                stmt.close();
                if (ct == null || "00278849E25F336B0000012E156D54D9".equals(ct.getId())) break block5;
                sql = "SELECT s.template_id, s.status_id, s.timelimit, t.subject AS template, e.targetgroup_id, l.subject AS status FROM ss_secondaries s INNER JOIN ss_formtemplates t ON t.template_id = s.template_id INNER JOIN ss_extras e ON e.template_id = t.template_id INNER JOIN ss_listitems l ON l.item_id = s.status_id WHERE t.is_deleted = 0 AND s.parent_id = ?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, caseTemplateId);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    SecondaryForm sf = new SecondaryForm(rs);
                    ct.getSecondaryReferences().add(sf);
                }
                rs.close();
                if (ct.isSecondaryEnabled()) {
                    this.setSecondaryFormTemplateLinks(ct);
                }
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CaseTemplate> getCaseTemplates() throws SQLException {
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<CaseTemplate> list = new ArrayList<CaseTemplate>();
        String sql = "SELECT c.casetemplate_id, c.subject, c.description, c.category_id, c.timelimit, c.is_system, c.is_visible, c.is_secondary, c.sec_handle, c.is_inview, c.customclass, c.created, c.modified, c.is_deleted FROM ss_casetemplates c ";
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                list.add(new CaseTemplate(rs));
            }
            rs.close();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCaseTemplate(CaseTemplate ct) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"subject", "description", "category_id", "timelimit", "is_visible", "is_inview", "is_secondary", "sec_handle", "is_deleted", "modified", "customclass", "casetemplate_id"};
        String sql = this.createUpdateSQL("ss_casetemplates", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, ct.getSubject());
            stmt.setString(2, ct.getDescription());
            stmt.setString(3, ct.getCategoryId());
            stmt.setInt(4, ct.getTimeLimitInDays());
            stmt.setInt(5, ct.isVisible() ? 1 : 0);
            stmt.setInt(6, ct.isVisibleInDefaultView() ? 1 : 0);
            stmt.setInt(7, ct.isSecondaryEnabled() ? 1 : 0);
            stmt.setInt(8, ct.getSecondaryHandling().getCode());
            stmt.setInt(9, ct.isDeleted() ? 1 : 0);
            stmt.setTimestamp(10, new Timestamp(ct.getDateModified()));
            stmt.setString(11, ct.getCustomClass());
            stmt.setString(12, ct.getId());
            stmt.executeUpdate();
            stmt.close();
            if (ct.isSecondaryEnabled()) {
                sql = "DELETE FROM ss_secondaries WHERE parent_id = ?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, ct.getId());
                stmt.executeUpdate();
                stmt.close();
                String secondarySql = this.createInsertSQL("ss_secondaries", new String[]{"parent_id", "template_id", "status_id", "timelimit"});
                stmt = con.prepareStatement(secondarySql);
                for (SecondaryForm sf : ct.getSecondaryReferences()) {
                    stmt.setString(1, ct.getId());
                    stmt.setString(2, sf.getTemplateId());
                    stmt.setString(3, sf.getStatusId());
                    stmt.setInt(4, sf.getTimelimit());
                    stmt.executeUpdate();
                }
            }
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BaseCase> getCasesByOrganizationId(String organizationId, String userContextId) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<BaseCase> list = new ArrayList<BaseCase>();
        String sql = this.getQuery("getCasesByOrganization");
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, organizationId);
            stmt.setString(2, userContextId);
            stmt.setString(3, userContextId);
            stmt.setString(4, userContextId);
            stmt.setString(5, userContextId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                BaseCase bc = CaseFactory.getInstance(rs.getString("classname"), rs);
                list.add(bc);
            }
            rs.close();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BaseCase> getCasesByCaseTemplate(String templateId, String userId) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<BaseCase> list = new ArrayList<BaseCase>();
        String sql = this.getQuery("getCasesByCaseTemplate");
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, templateId);
            stmt.setString(2, userId);
            stmt.setString(3, userId);
            stmt.setString(4, userId);
            stmt.setString(5, userId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                BaseCase bc = CaseFactory.getInstance(rs.getString("classname"), rs);
                list.add(bc);
            }
            rs.close();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BaseCase> getCasesByCompany(String companyId, String userContextId) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<BaseCase> list = new ArrayList<BaseCase>();
        String sql = this.getQuery("getCasesByCompany");
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, companyId);
            stmt.setString(2, companyId);
            stmt.setString(3, userContextId);
            stmt.setString(4, userContextId);
            stmt.setString(5, userContextId);
            stmt.setString(6, userContextId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                BaseCase bc = CaseFactory.getInstance(rs.getString("classname"), rs);
                list.add(bc);
            }
            rs.close();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Memo> getMemosByUser(String authorId, String userContextId) throws SQLException {
        ArrayList<Memo> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Memo> list = new ArrayList<Memo>();
        String sql = this.getQuery("getMemosByUser");
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, authorId);
            stmt.setString(2, userContextId);
            stmt.setString(3, userContextId);
            stmt.setString(4, userContextId);
            stmt.setString(5, userContextId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                Memo memo = new Memo(rs);
                list.add(memo);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SubDocument> getExternalDocumentsByUser(String authorId, String userContextId) throws SQLException {
        ArrayList<SubDocument> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<SubDocument> list = new ArrayList<SubDocument>();
        String sql = this.getQuery("getExternalDocumentsByUser");
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, authorId);
            stmt.setString(2, userContextId);
            stmt.setString(3, userContextId);
            stmt.setString(4, userContextId);
            stmt.setString(5, userContextId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String className = rs.getString("classname");
                ExternalDocument doc = ExternalDocumentFactory.getInstance(className, rs);
                list.add(doc);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    public void createEmail(Email email) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"email_id", "case_id", "parent_id", "gopro_id", "createdby_id", "status_id", "subject", "body", "fromname", "fromemail", "savecounter", "responsecount", "is_sensitive", "is_sent", "is_fromgopro", "is_deleted", "created", "modified", "completed", "modifiedby_id", "completedby_id"};
        String sql = this.createInsertSQL("ss_emails", cols);
        String[] recCols = new String[]{"email_id", "name", "email", "type"};
        String recSql = this.createInsertSQL("ss_emailrecipients", recCols);
        String[] attCols = new String[]{"attachment_id", "email_id", "filename", "filesize", "mimetype", "stream"};
        String attSql = this.createInsertSQL("ss_emailattachments", attCols);
        try {
            con = this.startTransaction();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, email.getId());
            stmt.setString(2, email.getCaseId());
            stmt.setString(3, email.getParentId());
            stmt.setString(4, email.getGoProId());
            stmt.setString(5, email.getCreatedById());
            stmt.setString(6, email.getStatusId());
            stmt.setString(7, email.getSubject());
            stmt.setString(8, email.getBody());
            stmt.setString(9, email.getFromName());
            stmt.setString(10, email.getFromEmail());
            stmt.setInt(11, email.getSaveCounter());
            stmt.setInt(12, email.getResponseCount());
            stmt.setInt(13, email.isPersonalSensitive() ? 1 : 0);
            stmt.setInt(14, email.isSent() ? 1 : 0);
            stmt.setInt(15, email.isFromGoPro() ? 1 : 0);
            stmt.setInt(16, email.isDeleted() ? 1 : 0);
            stmt.setTimestamp(17, new Timestamp(email.getDateCreated()));
            stmt.setTimestamp(18, new Timestamp(email.getDateModified()));
            if (email.getDateCompleted() == 0L) {
                stmt.setNull(19, 93);
            } else {
                stmt.setTimestamp(19, new Timestamp(email.getDateCompleted()));
            }
            stmt.setString(20, email.getModifiedById());
            stmt.setString(21, email.getCompletedById());
            stmt.executeUpdate();
            for (EmailRecipient rec : email.getRecipients()) {
                stmt = con.prepareStatement(recSql);
                stmt.setString(1, email.getId());
                stmt.setString(2, rec.getName());
                stmt.setString(3, rec.getEmailaddress());
                stmt.setString(4, rec.getType().toString());
                stmt.executeUpdate();
            }
            for (EmailAttachment att : email.getAttachments()) {
                stmt = con.prepareStatement(attSql);
                stmt.setString(1, att.getAttachmentId());
                stmt.setString(2, email.getId());
                stmt.setString(3, att.getFileName());
                stmt.setLong(4, att.getFileSize());
                stmt.setString(5, att.getMimeType());
                stmt.setBinaryStream(6, (InputStream)new ByteArrayInputStream(att.getStream()), att.getStream().length);
                stmt.executeUpdate();
            }
            this.commitTransaction();
        }
        catch (SQLException ex) {
            try {
                con.rollback();
                throw ex;
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Email getEmail(String emailId, boolean includeStream, String userContextId) throws SQLException, IOException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Email email = null;
        String sql = this.getQuery("getEmail");
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, emailId);
            stmt.setString(2, userContextId);
            stmt.setString(3, userContextId);
            stmt.setString(4, userContextId);
            stmt.setString(5, userContextId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                email = new Email(rs);
            }
            rs.close();
            stmt.close();
            if (email != null) {
                sql = "SELECT r.name, r.email, r.type FROM ss_emailrecipients r WHERE r.email_id = ?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, emailId);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    email.getRecipients().add(new EmailRecipient(rs));
                }
                rs.close();
                sql = "SELECT a.attachment_id, a.email_id, a.filename, a.filesize, a.mimetype ";
                if (includeStream) {
                    sql = sql + ",a.stream ";
                }
                sql = sql + "FROM ss_emailattachments a WHERE a.email_id = ?";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, emailId);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    EmailAttachment ea = new EmailAttachment(rs);
                    if (includeStream) {
                        InputStream is = rs.getBinaryStream("stream");
                        byte[] bytes = new byte[is.available()];
                        is.read(bytes);
                        is.close();
                        ea.setStream(bytes);
                    }
                    email.getAttachments().add(ea);
                }
                rs.close();
            }
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return email;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SubDocument> getEmails(String caseId, boolean includeStream, String userContextId) throws SQLException, IOException {
        ArrayList<SubDocument> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<SubDocument> list = new ArrayList<SubDocument>();
        String sql = this.getQuery("getEmails");
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, caseId);
            stmt.setString(2, userContextId);
            stmt.setString(3, userContextId);
            stmt.setString(4, userContextId);
            stmt.setString(5, userContextId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                Email email = new Email(rs);
                email.setStatusText(rs.getString("statusname"));
                email.setAuthorName(rs.getString("authorName"));
                list.add(email);
            }
            rs.close();
            stmt.close();
            if (list.size() > 0) {
                BaseDocument doc;
                String emailId;
                sql = "SELECT r.email_id, r.name, r.email, r.type FROM ss_emailrecipients r WHERE r.email_id IN (SELECT e.email_id FROM ss_emails e WHERE e.case_id = ?)";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, caseId);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    emailId = rs.getString("email_id");
                    EmailRecipient recipient = new EmailRecipient(rs);
                    doc = BaseDocumentUtil.getDocumentFromList(emailId, list);
                    if (doc == null) continue;
                    ((Email)doc).getRecipients().add(recipient);
                }
                rs.close();
                sql = "SELECT a.email_id, a.attachment_id, a.filename, a.filesize, a.mimetype ";
                if (includeStream) {
                    sql = sql + " ,a.stream ";
                }
                sql = sql + "FROM ss_emailattachments a WHERE a.email_id IN (SELECT e.email_id FROM ss_emails e WHERE e.case_id = ?)";
                stmt = con.prepareStatement(sql);
                stmt.setString(1, caseId);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    emailId = rs.getString("email_id");
                    EmailAttachment att = new EmailAttachment(rs);
                    if (includeStream) {
                        InputStream is = rs.getBinaryStream("stream");
                        byte[] bytes = new byte[is.available()];
                        is.read(bytes);
                        is.close();
                        att.setStream(bytes);
                    }
                    if ((doc = BaseDocumentUtil.getDocumentFromList(emailId, list)) == null) continue;
                    ((Email)doc).getAttachments().add(att);
                }
                rs.close();
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCaseResponseCount(String parentId) throws SQLException {
        int n;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int responseCount = 0;
        String sql = "SELECT c.case_id, (SELECT COUNT(m.memo_id) FROM ss_memos m WHERE c.case_id = m.parent_id AND m.is_deleted = 0) AS memocount, (SELECT COUNT(d.document_id) FROM ss_documents d WHERE c.case_id = d.parent_id AND d.is_deleted = 0 AND d.classname = ?) AS documentcount, (SELECT COUNT(e.email_id) FROM ss_emails e WHERE c.case_id = e.parent_id AND e.is_deleted = 0) AS emailcount FROM ss_cases c WHERE c.case_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, Attachment.class.getName());
            stmt.setString(2, parentId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                responseCount += rs.getInt("memocount");
                responseCount += rs.getInt("documentcount");
                responseCount += rs.getInt("emailcount");
            }
            rs.close();
            n = responseCount;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateResponseCount(Class<? extends BaseDocument> parentType, String parentId, int responseCount) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = null;
        String tableName = null;
        if (parentType.equals(BaseCase.class)) {
            tableName = "ss_cases";
            cols = new String[]{"responsecount", "case_id"};
        } else if (parentType.equals(Attachment.class)) {
            tableName = "ss_documents";
            cols = new String[]{"responsecount", "document_id"};
        } else if (parentType.equals(Memo.class)) {
            tableName = "ss_memos";
            cols = new String[]{"responsecount", "memo_id"};
        } else if (parentType.equals(Email.class)) {
            tableName = "ss_emails";
            cols = new String[]{"responsecount", "email_id"};
        } else {
            return;
        }
        String sql = this.createUpdateSQL(tableName, cols);
        try {
            con = this.startTransaction();
            stmt = con.prepareStatement(sql);
            stmt.setInt(1, responseCount);
            stmt.setString(2, parentId);
            stmt.executeUpdate();
            this.commitTransaction();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResponseCount(Class<? extends SubDocument> parentType, String parentId) throws SQLException {
        int n;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int responseCount = 0;
        String columnName = null;
        String tableName = null;
        if (parentType.equals(Attachment.class)) {
            columnName = "c.document_id";
            tableName = "ss_documents";
        } else if (parentType.equals(Memo.class)) {
            columnName = "c.memo_id";
            tableName = "ss_memos";
        } else if (parentType.equals(Email.class)) {
            columnName = "c.email_id";
            tableName = "ss_emails";
        } else {
            return 0;
        }
        String sql = "SELECT " + columnName + ", (SELECT COUNT(m.memo_id) FROM " + "ss_memos" + " m WHERE " + columnName + " = m.parent_id AND m.is_deleted = 0) AS memocount, (SELECT COUNT(d.document_id) FROM " + "ss_documents" + " d WHERE " + columnName + " = d.parent_id AND d.is_deleted = 0 AND d.classname = ?) AS documentcount, (SELECT COUNT(e.email_id) FROM " + "ss_emails" + " e WHERE " + columnName + " = e.parent_id AND e.is_deleted = 0) AS emailcount FROM " + tableName + " c WHERE " + columnName + " = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, Attachment.class.getName());
            stmt.setString(2, parentId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                responseCount += rs.getInt("memocount");
                responseCount += rs.getInt("documentcount");
                responseCount += rs.getInt("emailcount");
            }
            rs.close();
            n = responseCount;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return n;
    }

    protected String getUUIDStripped(String id) {
        return id.replace("-", "");
    }

    protected String getUUIDHyphened(String id) {
        if (id.length() == 32) {
            return StringUtil.toUUID(id);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkOutDocument(CheckoutTicket ticket) throws SQLException {
        boolean bl;
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"ticket_id", "document_id", "user_id", "checkout", "checkin"};
        String sql = this.createInsertSQL("ss_checkouts", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, ticket.getTicketId());
            stmt.setString(2, ticket.getDocumentId());
            stmt.setString(3, ticket.getUserId());
            stmt.setTimestamp(4, new Timestamp(ticket.getDateCheckedOut()));
            stmt.setNull(5, 93);
            bl = stmt.executeUpdate() > 0;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckoutTicket getCheckoutStatus(String documentId) throws SQLException {
        CheckoutTicket checkoutTicket;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        CheckoutTicket ticket = null;
        String sql = "SELECT c.ticket_id, c.document_id, c.user_id, u.fullname, c.checkout, c.checkin FROM ss_checkouts c INNER JOIN ss_users u ON c.user_id = u.user_id WHERE c.document_id = ? AND c.checkin IS NULL";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, documentId);
            rs = stmt.executeQuery();
            if (rs.next()) {
                ticket = new CheckoutTicket(rs);
                ticket.setCheckedOutByUser(rs.getString("fullname"));
            }
            rs.close();
            checkoutTicket = ticket;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return checkoutTicket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkInDocument(CheckoutTicket ticket) throws SQLException {
        boolean bl;
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"checkin", "ticket_id"};
        String sql = this.createUpdateSQL("ss_checkouts", cols);
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setTimestamp(1, new Timestamp(ticket.getDateCheckedIn()));
            stmt.setString(2, ticket.getTicketId());
            bl = stmt.executeUpdate() > 0;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CheckoutTicket> getCheckedOutDocuments() throws SQLException {
        ArrayList<CheckoutTicket> arrayList;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<CheckoutTicket> list = new ArrayList<CheckoutTicket>();
        String sql = "SELECT c.ticket_id, c.document_id, c.user_id, u.fullname, c.checkout, c.checkin FROM ss_checkouts c INNER JOIN ss_users u ON c.user_id = u.user_id WHERE c.checkin IS NULL ORDER BY checkout desc";
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                CheckoutTicket ticket = new CheckoutTicket(rs);
                ticket.setCheckedOutByUser(rs.getString("fullname"));
                list.add(ticket);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createAccessControl(String documentId, List<AccessControl> accessControlList, boolean flushExistingAcl) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"document_id", "entity_id", "entity_type", "bitmask"};
        String sql = this.createInsertSQL("ss_acl", cols);
        try {
            con = this.startTransaction();
            if (flushExistingAcl) {
                String fsql = "DELETE FROM ss_acl WHERE document_id = ?";
                stmt = con.prepareStatement(fsql);
                stmt.setString(1, documentId);
                stmt.execute();
                stmt.close();
            }
            stmt = con.prepareStatement(sql);
            for (int i = 0; i < accessControlList.size(); ++i) {
                AccessControl acl = accessControlList.get(i);
                stmt.setString(1, documentId);
                stmt.setString(2, acl.getEntityId());
                stmt.setInt(3, acl.getEntityType().getValue());
                stmt.setInt(4, acl.getBitmask());
                stmt.addBatch();
            }
            stmt.executeBatch();
            this.commitTransaction();
        }
        catch (BatchUpdateException ex) {
            try {
                throw new SQLException("Access Control batch creation failed: " + ex.getMessage(), ex);
                catch (SQLException ex2) {
                    con.rollback();
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessControl> getAccessControlList(String documentId) throws SQLException {
        ArrayList<AccessControl> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<AccessControl> list = new ArrayList<AccessControl>();
        String sql = "SELECT a.document_id, a.entity_id, a.entity_type, a.bitmask, u.fullname AS FullName, t.subject AS GroupName, c.name AS CompanyName, r.rolename AS RoleName FROM ss_acl a LEFT JOIN ss_users u ON (u.user_id = a.entity_id AND a.entity_type = 1) LEFT JOIN ss_targetgroups t ON (t.targetgroup_id = a.entity_id AND a.entity_type = 2) LEFT JOIN ss_companies c ON (c.company_id = a.entity_id AND a.entity_type = 3) LEFT JOIN ss_userroles r ON (r.role_id = a.entity_id AND a.entity_type = 4) WHERE a.document_id = ?";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, documentId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                AccessControl acl = new AccessControl(rs);
                if (AccessControl.AccessControlType.USER.equals((Object)acl.getEntityType())) {
                    acl.setEntityReference(new Reference(acl.getEntityId(), rs.getString("Fullname")));
                } else if (AccessControl.AccessControlType.GROUP.equals((Object)acl.getEntityType())) {
                    acl.setEntityReference(new Reference(acl.getEntityId(), rs.getString("GroupName")));
                } else if (AccessControl.AccessControlType.COMPANY.equals((Object)acl.getEntityType())) {
                    acl.setEntityReference(new Reference(acl.getEntityId(), rs.getString("CompanyName")));
                } else if (AccessControl.AccessControlType.ROLE.equals((Object)acl.getEntityType())) {
                    acl.setEntityReference(new Reference(acl.getEntityId(), rs.getString("RoleName")));
                }
                list.add(acl);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AccessControl> getAccessControlList(List<String> collectionIds) throws SQLException {
        ArrayList<AccessControl> arrayList;
        int i;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<AccessControl> list = new ArrayList<AccessControl>();
        if (collectionIds.size() == 0) {
            return list;
        }
        String sql = "SELECT a.document_id, a.entity_id, a.entity_type, a.bitmask, u.fullname AS FullName, t.subject AS GroupName, c.name AS CompanyName, r.rolename AS RoleName FROM ss_acl a LEFT JOIN ss_users u ON (u.user_id = a.entity_id AND a.entity_type = 1) LEFT JOIN ss_targetgroups t ON (t.targetgroup_id = a.entity_id AND a.entity_type = 2) LEFT JOIN ss_companies c ON (c.company_id = a.entity_id AND a.entity_type = 3) LEFT JOIN ss_userroles r ON (r.role_id = a.entity_id AND a.entity_type = 4) WHERE ";
        for (i = 0; i < collectionIds.size(); ++i) {
            sql = sql + " a.document_id = ? ";
            if (i >= collectionIds.size() - 1) continue;
            sql = sql + " OR ";
        }
        sql = sql + " ORDER BY a.document_id";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            for (i = 0; i < collectionIds.size(); ++i) {
                stmt.setString(i + 1, collectionIds.get(i));
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                AccessControl acl = new AccessControl(rs);
                if (AccessControl.AccessControlType.USER.equals((Object)acl.getEntityType())) {
                    acl.setEntityReference(new Reference(acl.getEntityId(), rs.getString("Fullname")));
                } else if (AccessControl.AccessControlType.GROUP.equals((Object)acl.getEntityType())) {
                    acl.setEntityReference(new Reference(acl.getEntityId(), rs.getString("GroupName")));
                } else if (AccessControl.AccessControlType.COMPANY.equals((Object)acl.getEntityType())) {
                    acl.setEntityReference(new Reference(acl.getEntityId(), rs.getString("CompanyName")));
                } else if (AccessControl.AccessControlType.ROLE.equals((Object)acl.getEntityType())) {
                    acl.setEntityReference(new Reference(acl.getEntityId(), rs.getString("RoleName")));
                }
                list.add(acl);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CaseTemplate> getPrimaryCaseTemplates() throws SQLException {
        ArrayList<CaseTemplate> arrayList;
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<CaseTemplate> list = new ArrayList<CaseTemplate>();
        String sql = "SELECT c.casetemplate_id, c.subject, c.description, c.category_id, c.timelimit, c.is_system, c.is_visible, c.is_secondary, c.sec_handle, c.customclass, c.is_inview, c.created, c.modified, c.is_deleted FROM ss_casetemplates c WHERE c.is_secondary = 1 AND c.is_deleted = 0";
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            Hashtable<String, CaseTemplate> ht = new Hashtable<String, CaseTemplate>();
            while (rs.next()) {
                CaseTemplate ct = new CaseTemplate(rs);
                list.add(ct);
                ht.put(ct.getId(), ct);
            }
            rs.close();
            stmt.close();
            sql = "SELECT s.parent_id, s.template_id, s.status_id, s.timelimit, t.subject AS template, e.targetgroup_id, l.subject AS status FROM ss_secondaries s INNER JOIN ss_formtemplates t ON t.template_id = s.template_id INNER JOIN ss_extras e ON e.template_id = t.template_id INNER JOIN ss_listitems l ON l.item_id = s.status_id WHERE t.is_deleted = 0";
            stmt = con.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String parentId = rs.getString("parent_id");
                SecondaryForm sf = new SecondaryForm(rs);
                if (!ht.containsKey(parentId)) continue;
                ((CaseTemplate)ht.get(parentId)).getSecondaryReferences().add(sf);
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSecondaryFormTemplateLinks(CaseTemplate ct) throws SQLException {
        int i;
        if (ct.getSecondaryReferences().isEmpty()) {
            return;
        }
        Hashtable<String, SecondaryForm> ht = new Hashtable<String, SecondaryForm>();
        List<SecondaryForm> refs = ct.getSecondaryReferences();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "SELECT l.template_id, l.organization_id, l.link_id FROM ss_formlinks l WHERE l.template_id = ? ";
        for (i = 0; i < refs.size(); ++i) {
            SecondaryForm sf = refs.get(i);
            ht.put(sf.getTemplateId(), sf);
            if (i <= 0) continue;
            sql = sql + " OR l.template_id = ? ";
        }
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            for (i = 0; i < refs.size(); ++i) {
                stmt.setString(i + 1, refs.get(i).getTemplateId());
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                String templateId = rs.getString("template_id");
                if (!ht.containsKey(templateId)) continue;
                ((SecondaryForm)ht.get(templateId)).getLinkMap().put(rs.getString("organization_id"), rs.getString("link_id"));
            }
            rs.close();
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    static {
        queryPathMap.put(CaseDalc.class.getSimpleName(), "cases");
    }
}

