/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.dalc;

import is.hugvit.bird.BirdException;
import is.hugvit.util.UID;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.dalc.queries.Queries;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.MetaData;

public abstract class BaseDalc {
    protected static final String TBL_COMPANIES = "ss_companies";
    protected static final String TBL_TEMPLATES = "ss_formtemplates";
    protected static final String TBL_LINKS = "ss_formlinks";
    protected static final String TBL_CASES = "ss_cases";
    protected static final String TBL_DOCUMENTS = "ss_documents";
    protected static final String TBL_STREAMS = "ss_streams";
    protected static final String TBL_MEMOS = "ss_memos";
    protected static final String TBL_ORGANIZATION = "ss_organizations";
    protected static final String TBL_METADATA = "ss_metadata";
    protected static final String TBL_USERS = "ss_users";
    protected static final String TBL_CONTACTS = "ss_contacts";
    protected static final String TBL_LISTS = "ss_lists";
    protected static final String TBL_LISTITEMS = "ss_listitems";
    protected static final String TBL_ENDPOINTS = "ss_endpoints";
    protected static final String TBL_TARGETGROUPS = "ss_targetgroups";
    protected static final String TBL_TARGETUSERS = "ss_targetgroupusers";
    protected static final String TBL_CASETEMPLATES = "ss_casetemplates";
    protected static final String TBL_EMAILS = "ss_emails";
    protected static final String TBL_RECIPIENTS = "ss_emailrecipients";
    protected static final String TBL_EMAILFILES = "ss_emailattachments";
    protected static final String TBL_CHECKOUTS = "ss_checkouts";
    protected static final String TBL_ACL = "ss_acl";
    protected static final String TBL_USERROLES = "ss_userroles";
    protected static final String TBL_ROLEMAP = "ss_userrolemap";
    protected static final String TBL_SECONDARIES = "ss_secondaries";
    protected static final String TBL_QUEUE = "ss_queue";
    protected static final String TBL_MESSAGETEMPLATES = "ss_messagetemplates";
    protected static final String TBL_EXTRAS = "ss_extras";
    private Connection con = null;
    private boolean isTransaction = false;
    protected static HashMap<String, String> queryPathMap = new HashMap();

    protected Connection startTransaction() throws SQLException {
        this.con = this.getConnection();
        this.con.setAutoCommit(false);
        this.isTransaction = true;
        return this.con;
    }

    protected Connection getTransactionConnection() throws SQLException {
        if (this.con == null) {
            throw new SQLException("No connection has been initiated.");
        }
        if (this.con.isClosed()) {
            throw new SQLException("Current connection has been committed and closed.");
        }
        if (!this.isTransaction) {
            throw new SQLException("No transaction is taking place, cannot return connection.");
        }
        return this.con;
    }

    protected void commitTransaction() throws SQLException {
        if (!this.isTransaction || this.con == null) {
            throw new IllegalArgumentException("Transaction has not been started!");
        }
        this.con.commit();
        this.con.setAutoCommit(true);
        this.isTransaction = false;
    }

    protected void closeConnection(Connection con) throws SQLException {
        if (con != null && !SelfServiceEngine.isCustomConnection()) {
            con.close();
        }
    }

    protected void closeStatement(Statement stmt) throws SQLException {
        if (stmt != null && !stmt.isClosed()) {
            stmt.close();
        }
    }

    protected Connection getConnection() throws SQLException {
        try {
            return SelfServiceEngine.getConnection();
        }
        catch (BirdException ex) {
            throw new SQLException(ex);
        }
    }

    protected String getSqlServiceType(Connection con) throws SQLException {
        return con.getMetaData().getDatabaseProductName();
    }

    protected int getSqlServerVersion(Connection con) throws SQLException {
        return con.getMetaData().getDatabaseMajorVersion();
    }

    protected final String createInsertSQL(String table, String[] columns) {
        String sql = "INSERT INTO " + table + " (";
        String sq = "";
        for (int i = 0; i < columns.length; ++i) {
            sql = sql + columns[i];
            sq = sq + "?";
            if (i >= columns.length - 1) continue;
            sql = sql + ",";
            sq = sq + ",";
        }
        sql = sql + ") VALUES (" + sq + ")";
        return sql;
    }

    protected final String createUpdateSQL(String table, String[] columns) {
        if (columns == null || columns.length < 2) {
            throw new IllegalArgumentException("At least 2 items needed for columns.");
        }
        int columnKey = columns.length - 1;
        String sql = "UPDATE " + table + " SET ";
        for (int i = 0; i < columns.length; ++i) {
            if (i < columnKey) {
                sql = sql + columns[i] + " = ?";
                if (i >= columnKey - 1) continue;
                sql = sql + ", ";
                continue;
            }
            sql = sql + " WHERE " + columns[i] + " = ?";
        }
        return sql;
    }

    protected final String getQuery(String queryName) throws SQLException {
        if (queryPathMap.containsKey(this.getClass().getSimpleName())) {
            return Queries.getQuery(queryPathMap.get(this.getClass().getSimpleName()) + "/" + queryName);
        }
        return Queries.getQuery(queryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MetaData> getMetData(List<String> documentIds) throws SQLException {
        ArrayList<MetaData> arrayList;
        int i;
        if (documentIds.isEmpty()) {
            return new ArrayList<MetaData>();
        }
        if (documentIds.size() == 1) {
            return this.getMetaData(documentIds.get(0), false);
        }
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<MetaData> list = new ArrayList<MetaData>();
        String sql = "SELECT m.metadata_id, m.document_id, m.user_id, m.datakey, m.datavalue, m.created, m.modified, m.is_deleted FROM ss_metadata m WHERE m.is_deleted = 0 AND (";
        for (i = 0; i < documentIds.size(); ++i) {
            sql = i < documentIds.size() - 1 ? sql + " m.document_id = ? OR " : sql + " m.document_id = ?";
        }
        sql = sql + ")";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            for (i = 0; i < documentIds.size(); ++i) {
                stmt.setString(i + 1, documentIds.get(i));
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(new MetaData(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MetaData> getMetaData(String baseDocumentId, boolean includeDeleted) throws SQLException {
        ArrayList<MetaData> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<MetaData> list = new ArrayList<MetaData>();
        String sql = "SELECT m.metadata_id, m.document_id, m.user_id, m.datakey, m.datavalue, m.created, m.modified, m.is_deleted FROM ss_metadata m WHERE m.document_id = ? ";
        if (!includeDeleted) {
            sql = sql + " AND m.is_deleted = 0";
        }
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, baseDocumentId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(new MetaData(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void createMetaData(BaseDocument doc) throws SQLException {
        Connection con = null;
        PreparedStatement stmt = null;
        String[] cols = new String[]{"metadata_id", "document_id", "user_id", "datakey", "datavalue", "is_deleted", "created", "modified"};
        String sql = this.createInsertSQL(TBL_METADATA, cols);
        try {
            con = this.startTransaction();
            stmt = con.prepareStatement(sql);
            for (int i = 0; i < doc.getMetadata().size(); ++i) {
                MetaData meta = doc.getMetadata().get(i);
                stmt.setString(1, meta.getId());
                stmt.setString(2, meta.getReferenceId());
                stmt.setString(3, meta.getUserId());
                stmt.setString(4, this.sanitizeMetaDataKey(meta.getKey()));
                stmt.setString(5, meta.getValue());
                stmt.setInt(6, meta.isDeleted() ? 1 : 0);
                stmt.setTimestamp(7, new Timestamp(meta.getDateCreated()));
                stmt.setTimestamp(8, new Timestamp(meta.getDateModified()));
                stmt.addBatch();
            }
            stmt.executeBatch();
            this.commitTransaction();
        }
        catch (BatchUpdateException ex) {
            try {
                throw new SQLException("Batch update failed: " + ex.getMessage(), ex);
                catch (SQLException ex2) {
                    con.rollback();
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                this.closeStatement(stmt);
                this.closeConnection(con);
                throw throwable;
            }
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateMetaData(BaseDocument doc, BaseDalc dalc) throws SQLException {
        Connection con = null;
        PreparedStatement stmt1 = null;
        PreparedStatement stmt2 = null;
        PreparedStatement stmt3 = null;
        List<MetaData> list = doc.getMetadata();
        try {
            con = this.getConnection();
            stmt1 = con.prepareStatement(this.createUpdateSQL(TBL_METADATA, new String[]{"is_deleted", "modified", "metadata_id"}));
            stmt2 = con.prepareStatement(this.createUpdateSQL(TBL_METADATA, new String[]{"datavalue", "modified", "metadata_id"}));
            String[] cols = new String[]{"metadata_id", "document_id", "user_id", "datakey", "datavalue", "is_deleted", "created", "modified"};
            stmt3 = con.prepareStatement(this.createInsertSQL(TBL_METADATA, cols));
            for (MetaData meta : list) {
                if (meta.isDeleted()) {
                    stmt1.setInt(1, 1);
                    stmt1.setTimestamp(2, new Timestamp(new Date().getTime()));
                    stmt1.setString(3, meta.getId());
                    stmt1.executeUpdate();
                    continue;
                }
                if (meta.isDirty()) {
                    stmt2.setString(1, meta.getValue());
                    stmt2.setTimestamp(2, new Timestamp(new Date().getTime()));
                    stmt2.setString(3, meta.getId());
                    stmt2.executeUpdate();
                    continue;
                }
                if (meta.getId() != null) continue;
                meta.setId(UID.getUID());
                meta.setReferenceId(doc.getId());
                stmt3.setString(1, meta.getId());
                stmt3.setString(2, meta.getReferenceId());
                stmt3.setString(3, meta.getUserId());
                stmt3.setString(4, this.sanitizeMetaDataKey(meta.getKey()));
                stmt3.setString(5, meta.getValue());
                stmt3.setInt(6, meta.isDeleted() ? 1 : 0);
                stmt3.setTimestamp(7, new Timestamp(meta.getDateCreated()));
                stmt3.setTimestamp(8, new Timestamp(meta.getDateModified()));
                stmt3.executeUpdate();
            }
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt1);
            this.closeStatement(stmt2);
            this.closeStatement(stmt3);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt1);
        this.closeStatement(stmt2);
        this.closeStatement(stmt3);
        this.closeConnection(con);
    }

    private final String sanitizeMetaDataKey(String key) {
        if (key != null && key.length() > 64) {
            return key.substring(0, 64);
        }
        return key;
    }

    protected class FilterParam {
        private int dataType;
        private Object value;

        public FilterParam(int dataType, Object value) {
            this.dataType = dataType;
            this.value = value;
        }

        public final int getDataType() {
            return this.dataType;
        }

        public final Object getValue() {
            return this.value;
        }
    }
}

