/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.communications;

import java.text.DateFormat;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.data.Address;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.Memo;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.Task;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;

public final class Translator {
    public static final String translate(BaseDocument doc, String message) {
        String translated = message;
        if (doc instanceof User) {
            translated = Translator.translate((User)doc, message);
        } else if (doc instanceof ApplicationForm) {
            translated = Translator.translate((ApplicationForm)doc, message);
        } else if (doc instanceof BaseCase) {
            translated = Translator.translate((BaseCase)doc, message);
        } else if (doc instanceof SubDocument) {
            translated = Translator.translate((SubDocument)doc, message);
        } else if (doc instanceof Company) {
            translated = Translator.translate((Company)doc, message);
        } else if (doc instanceof Task) {
            translated = Translator.translate((Task)doc, message);
        } else if (doc instanceof FormTemplate) {
            translated = Translator.translate((FormTemplate)doc, message);
        }
        if (doc.getMetadata().size() > 0 && Translator.containsKey("meta", translated)) {
            for (MetaData md : doc.getMetadata()) {
                translated = translated.replace("[meta." + md.getKey() + "]", md.getValue());
            }
        }
        return Translator.translate(translated);
    }

    public static final String translate(List<BaseDocument> list, String message) {
        String translated = message;
        for (BaseDocument bc : list) {
            translated = Translator.translate(bc, translated);
        }
        return translated;
    }

    private static final String translate(User user, String message) {
        if (!Translator.containsKey("user", message)) {
            return message;
        }
        String translated = message;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("username", Translator.getValue(user.getUsername()));
        ht.put("fullname", Translator.getValue(user.getFullname()));
        ht.put("firstname", Translator.getValue(user.getFirstName()));
        ht.put("middlename", Translator.getValue(user.getMiddleName()));
        ht.put("lastname", Translator.getValue(user.getLastName()));
        ht.put("initials", Translator.getValue(user.getInitials()));
        ht.put("email", Translator.getValue(user.getEmail()));
        ht.put("mobilenumber", Translator.getValue(user.getMobilephoneNumber()));
        ht.put("homenumber", Translator.getValue(user.getHomephoneNumber()));
        ht.put("language", Translator.getValue(user.getLocale()));
        for (String key : ht.keySet()) {
            translated = translated.replace("[user." + key + "]", (CharSequence)ht.get(key));
        }
        if (user.getAddress() != null) {
            return Translator.translate(user.getAddress(), translated);
        }
        return translated;
    }

    private static final String translate(Company company, String message) {
        if (!Translator.containsKey("company", message)) {
            return message;
        }
        String translated = message;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("subject", Translator.getValue(company.getName()));
        if (company.getAddress() != null) {
            Address address = company.getAddress();
            ht.put("streetname", Translator.getValue(address.getStreetName()));
            ht.put("city", Translator.getValue(address.getCity()));
            ht.put("postcode", Translator.getValue(address.getPostcode()));
            ht.put("state", Translator.getValue(address.getState()));
            ht.put("country", Translator.getValue(address.getCountry()));
        }
        for (String key : ht.keySet()) {
            translated = translated.replace("[company." + key + "]", (CharSequence)ht.get(key));
        }
        return translated;
    }

    private static final String translate(Task task, String message) {
        if (!Translator.containsKey("task", message)) {
            return message;
        }
        DateFormat df = LocaleUtil.getTimeFormat();
        String translated = message;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("subject", Translator.getValue(task.getSubject()));
        ht.put("responsible", Translator.getValue(task.getResponsibleName()));
        ht.put("created", Translator.getValue(df.format(task.getDateCreated())));
        ht.put("modified", Translator.getValue(df.format(task.getDateModified())));
        ht.put("deadline", Translator.getValue(df.format(task.getDeadline())));
        ht.put("category", Translator.getValue(task.getCategorySubject()));
        ht.put("description", Translator.getValue(task.getDescription()));
        ht.put("priority", Translator.getValue(task.getPrioritySubject()));
        ht.put("status", Translator.getValue(task.getStatus().name()));
        for (String key : ht.keySet()) {
            translated = translated.replace("[task." + key + "]", (CharSequence)ht.get(key));
        }
        if (task.getMetadata().size() > 0 && Translator.containsKey("meta", translated)) {
            for (MetaData md : task.getMetadata()) {
                translated = translated.replace("[meta." + md.getKey() + "]", md.getValue());
            }
        }
        return translated;
    }

    private static final String translate(Address address, String message) {
        if (!Translator.containsKey("address", message)) {
            return message;
        }
        String translated = message;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("streetname", Translator.getValue(address.getStreetName()));
        ht.put("city", Translator.getValue(address.getCity()));
        ht.put("postcode", Translator.getValue(address.getPostcode()));
        ht.put("state", Translator.getValue(address.getState()));
        ht.put("country", Translator.getValue(address.getCountry()));
        for (String key : ht.keySet()) {
            translated = translated.replace("[address." + key + "]", (CharSequence)ht.get(key));
        }
        return translated;
    }

    private static final String translate(FormTemplate template, String message) {
        if (!Translator.containsKey("template", message)) {
            return message;
        }
        String translated = message;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("subject", Translator.getValue(template.getSubject()));
        ht.put("category", Translator.getValue(template.getCategory()));
        ht.put("description", Translator.getValue(template.getDescription()));
        for (String key : ht.keySet()) {
            translated = translated.replace("[template." + key + "]", (CharSequence)ht.get(key));
        }
        return translated;
    }

    private static final String translate(ApplicationForm doc, String message) {
        String translated = Translator.translate((SubDocument)doc, message);
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("id", Translator.getValue(doc.getId()));
        ht.put("subject", Translator.getValue(doc.getSubject()));
        for (String key : ht.keySet()) {
            translated = translated.replace("[application." + key + "]", (CharSequence)ht.get(key));
        }
        return translated;
    }

    private static final String translate(SubDocument doc, String message) {
        if (!Translator.containsKey("doc", message)) {
            return message;
        }
        DateFormat df = LocaleUtil.getTimeFormat();
        String translated = message;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("id", Translator.getValue(doc.getId()));
        ht.put("subject", Translator.getValue(doc.getSubject()));
        ht.put("body", Translator.getValue(doc.getBody()));
        ht.put("created", Translator.getValue(df.format(doc.getDateCreated())));
        ht.put("modified", Translator.getValue(df.format(doc.getDateModified())));
        if (doc instanceof Memo) {
            ht.put("link", Translator.createDocLink(doc.getId(), DocType.MEMO));
        } else if (doc instanceof ExternalDocument) {
            ht.put("link", Translator.createDocLink(doc.getId(), DocType.ATTACHMENT));
        }
        for (String key : ht.keySet()) {
            translated = translated.replace("[doc." + key + "]", (CharSequence)ht.get(key));
        }
        return translated;
    }

    private static final String translate(BaseCase bc, String message) {
        if (!Translator.containsKey("case", message)) {
            return message;
        }
        DateFormat df = LocaleUtil.getTimeFormat();
        String translated = message;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("id", Translator.getValue(bc.getId()));
        ht.put("goproid", Translator.getValue(bc.getGoProId()));
        ht.put("casenumber", Translator.getValue(bc.getGoProCaseNumber()));
        ht.put("reference", Translator.getValue(bc.getReferenceNumber()));
        ht.put("subject", Translator.getValue(bc.getSubject()));
        ht.put("created", Translator.getValue(df.format(bc.getDateCreated())));
        ht.put("modified", Translator.getValue(df.format(bc.getDateModified())));
        ht.put("link", Translator.createDocLink(bc.getId(), DocType.CASE));
        if (bc.getStatus() != null) {
            ht.put("status", Translator.getValue(bc.getStatus().getSubject()));
        }
        for (String key : ht.keySet()) {
            translated = translated.replace("[case." + key + "]", (CharSequence)ht.get(key));
        }
        return translated;
    }

    private static final String translate(String message) {
        String translated = message;
        translated = translated.replace("[web.url]", SelfServiceEngine.getConfig("web.domain"));
        translated = translated.replace("[web.domain]", SelfServiceEngine.getConfig("web.domain"));
        translated = translated.replace("[web.title]", SelfServiceEngine.getConfig("web.title"));
        return translated;
    }

    private static boolean containsKey(String key, String source) {
        String regex = "\\[" + key + "\\.(.*?)\\]";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(source);
        return matcher.find();
    }

    private static final String getValue(String s) {
        if (StringUtil.isValid(s)) {
            return s;
        }
        return "";
    }

    private static String createDocLink(String documentId, DocType dc) {
        String url = SelfServiceEngine.getConfig("web.domain");
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        if (dc.equals((Object)DocType.CASE)) {
            url = url + "web/portal/case.html?id=" + documentId;
        } else if (dc.equals((Object)DocType.MEMO)) {
            url = url + "web/portal/memo.html?id=" + documentId;
        } else if (dc.equals((Object)DocType.ATTACHMENT)) {
            url = url + "web/portal/attachment.html?id=" + documentId;
        }
        return url;
    }

    private static enum DocType {
        CASE,
        MEMO,
        ATTACHMENT;

    }
}

