/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.communications;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.activation.DataSource;
import net.gopro.selfservice.IMessageProcessHookIn;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.communications.Messenger;
import net.gopro.selfservice.communications.Translator;
import net.gopro.selfservice.data.Attachment;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.Case;
import net.gopro.selfservice.data.CaseTemplate;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.Memo;
import net.gopro.selfservice.data.MessageTemplate;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.SecondaryForm;
import net.gopro.selfservice.data.SimpleMessage;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.CommunicationException;
import net.gopro.selfservice.exceptions.HookInException;
import net.gopro.selfservice.exceptions.MessageException;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.util.LocaleUtil;
import net.gopro.selfservice.util.StringUtil;
import org.apache.commons.mail.ByteArrayDataSource;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.MultiPartEmail;

public final class MessageHelper {
    public static final void sendIncomingFileMessage(User user, Attachment att, BaseCase parentCase) throws SelfServiceException {
        try {
            ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages");
            String subject = Translator.translate(Arrays.asList(user, att, parentCase), rb.getString("file.new.subject"));
            String body = rb.getString("file.new.body");
            body = Translator.translate(Arrays.asList(user, att, parentCase), body);
            Organization involvedOrg = MessageHelper.getInvolvedOrganization(parentCase.getOrganizationId());
            SimpleMessage sm = new SimpleMessage(subject, body);
            sm.setDocumentId(att.getId());
            sm.setDocumentStatusId(att.getStatusId());
            IMessageProcessHookIn messageHookin = involvedOrg.getMessageProcessHookIn();
            boolean doSend = true;
            if (messageHookin != null) {
                doSend = messageHookin.processMessage(Organization.MailPreference.NewCaseDocuments, sm, involvedOrg, user);
            }
            if (doSend) {
                Messenger.sendMessage(user, sm, true, involvedOrg, Organization.MailPreference.NewCaseDocuments, parentCase.getId());
            }
        }
        catch (CommunicationException ex) {
            SelfServiceEngine.getLogger().error("Error sending message: ", (Exception)ex);
        }
        catch (MessageException ex) {
            SelfServiceEngine.getLogger().error("Error sending message: ", (Exception)ex);
        }
        catch (HookInException ex) {
            SelfServiceEngine.getLogger().error("Error sending message: HookIn error ", (Exception)ex);
        }
    }

    public static final void sendIncomingMemoMessage(User user, Memo memo, BaseCase parentCase) throws SelfServiceException {
        try {
            ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages");
            String subject = Translator.translate(Arrays.asList(user, memo, parentCase), rb.getString("memo.new.subject"));
            String body = rb.getString("memo.new.body");
            body = Translator.translate(Arrays.asList(user, memo, parentCase), body);
            Organization involvedOrg = MessageHelper.getInvolvedOrganization(parentCase.getOrganizationId());
            SimpleMessage sm = new SimpleMessage(subject, body);
            sm.setDocumentId(memo.getId());
            sm.setDocumentStatusId(memo.getStatusId());
            IMessageProcessHookIn messageHookin = involvedOrg.getMessageProcessHookIn();
            boolean doSend = true;
            if (messageHookin != null) {
                doSend = messageHookin.processMessage(Organization.MailPreference.NewCaseDocuments, sm, involvedOrg, user);
            }
            if (doSend) {
                Messenger.sendMessage(user, sm, true, involvedOrg, Organization.MailPreference.NewCaseDocuments, parentCase.getId());
            }
        }
        catch (CommunicationException ex) {
            SelfServiceEngine.getLogger().error("Error sending message: ", (Exception)ex);
        }
        catch (MessageException ex) {
            SelfServiceEngine.getLogger().error("Error sending message: ", (Exception)ex);
        }
        catch (HookInException ex) {
            SelfServiceEngine.getLogger().error("Error sending message: HookIn error ", (Exception)ex);
        }
    }

    public static final void sendUpdatedCaseStatusMessage(User user, BaseCase bc) throws SelfServiceException {
        try {
            ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages");
            String subject = Translator.translate(Arrays.asList(user, bc), rb.getString("case.updated.subject"));
            String body = rb.getString("case.updated.body");
            List<SecondaryForm> secondaries = MessageHelper.getSecondaryApplicationsList(bc);
            if (!secondaries.isEmpty()) {
                String secList = "";
                for (SecondaryForm sf : secondaries) {
                    secList = secList + "* " + sf.getTemplateName() + "\n";
                }
                String sec = rb.getString("case.secondaries");
                if (sec != null) {
                    sec = sec.replace("[applications.list]", secList);
                }
                body = body + "\n\n" + sec;
            }
            body = Translator.translate(Arrays.asList(user, bc), body);
            Organization involvedOrg = MessageHelper.getInvolvedOrganization(bc.getOrganizationId());
            SimpleMessage sm = new SimpleMessage(subject, body);
            sm.setDocumentId(bc.getId());
            sm.setDocumentStatusId(bc.getStatusId());
            IMessageProcessHookIn messageHookin = involvedOrg.getMessageProcessHookIn();
            boolean doSend = true;
            if (messageHookin != null) {
                doSend = messageHookin.processMessage(Organization.MailPreference.CaseStatusUpdates, sm, involvedOrg, user);
            }
            if (doSend) {
                Messenger.sendMessage(user, sm, true, involvedOrg, Organization.MailPreference.CaseStatusUpdates, bc.getId());
            }
        }
        catch (CommunicationException ex) {
            SelfServiceEngine.getLogger().error("Error sending message: ", (Exception)ex);
        }
        catch (MessageException ex) {
            SelfServiceEngine.getLogger().error("Error sending message: ", (Exception)ex);
        }
        catch (HookInException ex) {
            SelfServiceEngine.getLogger().error("Error sending message: HookIn error ", (Exception)ex);
        }
    }

    public static final void sendCaseReopenedMessage(User user, FormCase bc) throws SelfServiceException {
        try {
            ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages");
            String subject = Translator.translate(Arrays.asList(user, bc), rb.getString("case.reopen.subject"));
            String body = rb.getString("case.reopen.body");
            body = Translator.translate(Arrays.asList(user, bc), body);
            Organization involvedOrg = MessageHelper.getInvolvedOrganization(bc.getOrganizationId());
            SimpleMessage sm = new SimpleMessage(subject, body);
            sm.setDocumentId(bc.getId());
            sm.setDocumentStatusId(bc.getStatusId());
            IMessageProcessHookIn messageHookin = involvedOrg.getMessageProcessHookIn();
            boolean doSend = true;
            if (messageHookin != null) {
                doSend = messageHookin.processMessage(Organization.MailPreference.CaseStatusUpdates, sm, involvedOrg, user);
            }
            if (doSend) {
                Messenger.sendMessage(user, sm, true, involvedOrg, Organization.MailPreference.CaseStatusUpdates, bc.getId());
            }
        }
        catch (CommunicationException ex) {
            SelfServiceEngine.getLogger().error("Error sending message: ", (Exception)ex);
        }
        catch (MessageException ex) {
            SelfServiceEngine.getLogger().error("Error sending message: ", (Exception)ex);
        }
        catch (HookInException ex) {
            SelfServiceEngine.getLogger().error("Error sending message: HookIn error ", (Exception)ex);
        }
    }

    public static final void sendApplicationSendMessage(User user, FormTemplate ft, List<? extends BaseDocument> list) throws SelfServiceException {
        try {
            ArrayList<BaseDocument> docList = new ArrayList<BaseDocument>();
            docList.addAll(list);
            docList.add(user);
            ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages");
            MessageTemplate messageTemplate = MessageHelper.getMessageTemplate(ft.getMessageTemplateId());
            String subject = Translator.translate(docList, LocaleUtil.getStringSafe(rb, "application.new.subject", "portal.messages"));
            if (messageTemplate != null) {
                subject = Translator.translate(docList, messageTemplate.getSubject());
            }
            String bodyToTranslate = LocaleUtil.getStringSafe(rb, "application.new.body", "portal.messages");
            if (messageTemplate != null) {
                bodyToTranslate = messageTemplate.getBody();
            }
            String body = Translator.translate(docList, bodyToTranslate);
            Organization involvedOrg = null;
            String parentCaseId = null;
            BaseDocument fc = null;
            for (BaseDocument baseDocument : list) {
                if (!(baseDocument instanceof FormCase)) continue;
                fc = (FormCase)baseDocument;
                involvedOrg = MessageHelper.getInvolvedOrganization(((FormCase)baseDocument).getOrganizationId());
                parentCaseId = baseDocument.getId();
                break;
            }
            SimpleMessage sm = new SimpleMessage(subject, body);
            sm.setDocumentId(fc.getId());
            sm.setDocumentStatusId(((BaseCase)fc).getStatusId());
            IMessageProcessHookIn iMessageProcessHookIn = involvedOrg.getMessageProcessHookIn();
            boolean doSend = true;
            if (iMessageProcessHookIn != null) {
                doSend = iMessageProcessHookIn.processMessage(Organization.MailPreference.ApplicationConfirmation, sm, involvedOrg, user);
            }
            if (doSend) {
                Messenger.sendMessage(user, sm, true, involvedOrg, Organization.MailPreference.ApplicationConfirmation, parentCaseId);
            }
        }
        catch (CommunicationException ex) {
            SelfServiceEngine.getLogger().error("Error sending message: ", (Exception)ex);
        }
        catch (MessageException ex) {
            SelfServiceEngine.getLogger().error("Error sending message: ", (Exception)ex);
        }
        catch (HookInException ex) {
            SelfServiceEngine.getLogger().error("Error sending message: HookIn error ", (Exception)ex);
        }
    }

    public static final boolean sendExportedCase(String emailAddress, User user, BaseCase bc, File file) throws SelfServiceException {
        try {
            if (file == null) {
                throw new SelfServiceException("The file is null. Possibly ACL issues on documents.");
            }
            MultiPartEmail email = new MultiPartEmail();
            String senderEmail = SelfServiceEngine.getConfig("mail.sender");
            String senderName = SelfServiceEngine.getConfig("mail.sendername");
            String username = SelfServiceEngine.getConfig("mail.username");
            String password = SelfServiceEngine.getConfig("mail.password");
            String portNumber = SelfServiceEngine.getConfig("mail.port");
            String encryption = SelfServiceEngine.getConfig("mail.encryption");
            email.setSubject(bc.getReferenceNumber());
            email.setCharset(SelfServiceEngine.getEncoding());
            email.addTo(emailAddress);
            email.setFrom(senderEmail, senderName);
            email.setHostName(SelfServiceEngine.getConfig("mail.hostname"));
            if (StringUtil.isValid(username) && StringUtil.isValid(password)) {
                email.setAuthentication(username, password);
            }
            if (StringUtil.isValid(portNumber)) {
                email.setSmtpPort(Integer.parseInt(portNumber));
            }
            if (StringUtil.isValid(encryption) && "TLS".equalsIgnoreCase(encryption)) {
                email.setStartTLSEnabled(true);
            } else if (StringUtil.isValid(encryption) && "SSL".equalsIgnoreCase(encryption)) {
                email.setSSLOnConnect(true);
            }
            email.setMsg(bc.getReferenceNumber() + " / " + bc.getSubject());
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            ByteArrayDataSource source = new ByteArrayDataSource((InputStream)is, "application/zip");
            EmailAttachment attachment = new EmailAttachment();
            attachment.setDisposition("attachment");
            email.attach((DataSource)source, bc.getReferenceNumber().replace("/", "-") + ".zip", "Exported Case");
            email.send();
            return true;
        }
        catch (EmailException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
        catch (FileNotFoundException ex) {
            throw new SelfServiceException(ex);
        }
        catch (IOException ex) {
            throw new SelfServiceException(ex);
        }
    }

    public static final boolean sendCollaborationInvite(String emailAddress, User user, BaseCase bc) throws SelfServiceException {
        try {
            ResourceBundle rb = LocaleUtil.getResourceBundle("portal.messages");
            ArrayList<BaseDocument> docList = new ArrayList<BaseDocument>();
            docList.add(user);
            docList.add(bc);
            String subject = Translator.translate(docList, rb.getString("collaboration.invitation.subject"));
            String body = String.format(Translator.translate(docList, rb.getString("collaboration.invitation.body")), emailAddress);
            HtmlEmail email = new HtmlEmail();
            String senderEmail = SelfServiceEngine.getConfig("mail.sender");
            String senderName = SelfServiceEngine.getConfig("mail.sendername");
            String username = SelfServiceEngine.getConfig("mail.username");
            String password = SelfServiceEngine.getConfig("mail.password");
            String portNumber = SelfServiceEngine.getConfig("mail.port");
            String encryption = SelfServiceEngine.getConfig("mail.encryption");
            email.setSubject(subject);
            email.setHtmlMsg("<html>" + body.replaceAll("\\n", "<br/>") + "</html>");
            email.setCharset(SelfServiceEngine.getEncoding());
            email.addTo(emailAddress);
            email.setFrom(senderEmail, senderName);
            email.setHostName(SelfServiceEngine.getConfig("mail.hostname"));
            if (StringUtil.isValid(username) && StringUtil.isValid(password)) {
                email.setAuthentication(username, password);
            }
            if (StringUtil.isValid(portNumber)) {
                email.setSmtpPort(Integer.parseInt(portNumber));
            }
            if (StringUtil.isValid(encryption) && "TLS".equalsIgnoreCase(encryption)) {
                email.setStartTLSEnabled(true);
            } else if (StringUtil.isValid(encryption) && "SSL".equalsIgnoreCase(encryption)) {
                email.setSSLOnConnect(true);
            }
            email.send();
            return true;
        }
        catch (EmailException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
    }

    private static MessageTemplate getMessageTemplate(String templateId) throws SelfServiceException {
        MessageTemplate mt = null;
        if (templateId != null) {
            mt = ConfigService.getMessageTemplate(templateId);
        }
        return mt;
    }

    private static Organization getInvolvedOrganization(String organizationId) throws SelfServiceException {
        return ConfigService.getOrganization(organizationId);
    }

    private static List<SecondaryForm> getSecondaryApplicationsList(BaseCase bc) throws SelfServiceException {
        ArrayList<SecondaryForm> list;
        block3: {
            block2: {
                list = new ArrayList<SecondaryForm>();
                if (!(bc instanceof FormCase)) break block2;
                FormTemplate formTemplate = FormService.getFormTemplate(((FormCase)bc).getFormtemplateId(), false);
                for (SecondaryForm sf : formTemplate.getSecondaryReferences()) {
                    if (!bc.getStatusId().equalsIgnoreCase(sf.getStatusId())) continue;
                    list.add(sf);
                }
                break block3;
            }
            if (!(bc instanceof Case)) break block3;
            CaseTemplate caseTemplate = CaseService.getCaseTemplate(bc.getCaseTemplateId());
            for (SecondaryForm sf : caseTemplate.getSecondaryReferences()) {
                if (!bc.getStatusId().equalsIgnoreCase(sf.getStatusId())) continue;
                list.add(sf);
            }
        }
        return list;
    }
}

