/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.broker;

import is.hugvit.bird.BirdFile;
import java.io.InputStream;
import java.util.Date;
import net.gopro.gdf.data.AddressType;
import net.gopro.gdf.data.CaseTemplateRefType;
import net.gopro.gdf.data.CaseType;
import net.gopro.gdf.data.CategoryRefType;
import net.gopro.gdf.data.CompanyRefType;
import net.gopro.gdf.data.CompanyType;
import net.gopro.gdf.data.ContactType;
import net.gopro.gdf.data.ExternalDocumentType;
import net.gopro.gdf.data.ExternalDocumentVersionType;
import net.gopro.gdf.data.FileAttachmentType;
import net.gopro.gdf.data.IndividualRefType;
import net.gopro.gdf.data.IndividualType;
import net.gopro.gdf.data.ListValueRefType;
import net.gopro.gdf.data.MemoType;
import net.gopro.gdf.data.MetaDataType;
import net.gopro.gdf.data.NameType;
import net.gopro.gdf.data.PhoneNumberType;
import net.gopro.gdf.data.UserRefType;
import net.gopro.gdf.data.types.CommunicationCodeType;
import net.gopro.gdf.data.types.MetaValueType;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.Address;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.Company;
import net.gopro.selfservice.data.Contact;
import net.gopro.selfservice.data.ExternalDocument;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.Memo;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.gdf.helpers.GDFCase;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.util.StringUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class BrokerGDFHelper {
    public static CaseType createCaseType(FormCase fc) throws SelfServiceException {
        ApplicationForm form = fc.getApplicationForm();
        if (form == null) {
            throw new SelfServiceException("The application form for the case is missing.");
        }
        FormTemplate formTemplate = FormService.getFormTemplate(fc.getFormtemplateId(), false);
        if (formTemplate == null) {
            throw new SelfServiceException("The form template for the Form Case was not found!");
        }
        String caseTemplateName = formTemplate.getExtendedData().getGoproAlias();
        if (!StringUtil.isValid(caseTemplateName)) {
            caseTemplateName = formTemplate.getSubject();
        }
        CaseType mycase = new CaseType();
        mycase.setID(fc.getId());
        mycase.setSubject(fc.getSubject());
        mycase.setBody("");
        mycase.setCompletedDate(new Date(form.getDateModified()));
        mycase.setCreationDate(new Date(form.getDateCreated()));
        mycase.setStartDate(new Date(form.getDateCreated()));
        CaseTemplateRefType caseTemplate = new CaseTemplateRefType();
        caseTemplate.setName(caseTemplateName);
        mycase.setCaseTemplate(caseTemplate);
        CategoryRefType category = new CategoryRefType();
        category.setName("Self Service");
        mycase.setCategory(category);
        if (fc.getStatus() != null) {
            ListValueRefType lStatus = new ListValueRefType();
            lStatus.setID("00000000-0000-0000-0000-000000000000");
            lStatus.setName(fc.getStatus().getSubject());
            mycase.setStatus(lStatus);
        }
        GDFCase.setMetaData(mycase, form);
        return mycase;
    }

    public static final ExternalDocumentType createExternalDocumentType(ExternalDocument exDoc, User user) {
        ExternalDocumentType doc = new ExternalDocumentType();
        doc.setID(doc.getID());
        doc.setSubject(exDoc.getSubject());
        doc.setBody(exDoc.getBody());
        doc.setOriginalDate(new Date(exDoc.getDateModified()));
        doc.setCreationDate(new Date(exDoc.getDateCreated()));
        doc.setDirection(CommunicationCodeType.OUTGOING);
        doc.setNumberOfVersions(1);
        ListValueRefType lStatus = new ListValueRefType();
        lStatus.setName("");
        doc.setStatus(lStatus);
        UserRefType userRef = new UserRefType();
        userRef.setName(user.getFullname());
        doc.setCreatedBy(userRef);
        FileAttachmentType ft = new FileAttachmentType();
        ft.setStream(exDoc.getStream());
        ft.setFileName(exDoc.getFilename());
        ft.setFileSize(exDoc.getFilesize());
        ft.setMimeType(exDoc.getMimetype());
        ExternalDocumentVersionType version = new ExternalDocumentVersionType();
        version.setAttachment(ft);
        version.setID("00000000-0000-0000-0000-000000000000");
        version.setCreatedBy(userRef);
        version.setCreationDate(new Date(exDoc.getDateCreated()));
        version.setSubject(exDoc.getSubject());
        doc.setCurrentVersion(version);
        MetaDataType mt = new MetaDataType();
        mt.setName("SelfServiceId");
        mt.setValue(exDoc.getId());
        mt.setValueType(MetaValueType.STRING);
        doc.addMetaDataEntry(mt);
        return doc;
    }

    public static final MemoType createMemoType(Memo memo, User user) {
        MemoType m = new MemoType();
        m.setID(memo.getId());
        m.setSubject(memo.getSubject());
        m.setBody(memo.getBody());
        m.setCreationDate(new Date(memo.getDateCreated()));
        m.setCompletedDate(new Date(memo.getDateModified()));
        m.setDirection(CommunicationCodeType.OUTGOING);
        ListValueRefType lStatus = new ListValueRefType();
        lStatus.setName("");
        m.setStatus(lStatus);
        UserRefType userRef = new UserRefType();
        userRef.setName(user.getFullname());
        m.setCreatedBy(userRef);
        MetaDataType mt = new MetaDataType();
        mt.setName("SelfServiceId");
        mt.setValue(memo.getId());
        mt.setValueType(MetaValueType.STRING);
        m.addMetaDataEntry(mt);
        return m;
    }

    public static CompanyType createCompanyType(Company comp) {
        CompanyType companyType = new CompanyType();
        companyType.setID(comp.getId());
        companyType.setSubject(comp.getName());
        Address address = comp.getAddress();
        if (address != null) {
            AddressType addressType = new AddressType();
            addressType.setStreetName(address.getStreetName());
            addressType.setCity(address.getCity());
            addressType.setPostCode(address.getPostcode());
            addressType.setState(address.getState());
            if (StringUtil.isValid(address.getCountry())) {
                ListValueRefType refCountry = new ListValueRefType();
                refCountry.setName(address.getCountry());
                addressType.setCountry(refCountry);
            }
            companyType.addAddress(addressType);
        }
        return companyType;
    }

    public static ContactType createContactType(Contact contact, User user) {
        ContactType contactType = new ContactType();
        contactType.setID(contact.getId());
        contactType.setSubject(user.getFullname());
        if (StringUtil.isValid(contact.getEmail())) {
            contactType.addEmailAddress(contact.getEmail());
        }
        IndividualRefType refIndividual = new IndividualRefType();
        refIndividual.setID(contact.getUserId());
        refIndividual.setName(user.getFullname());
        contactType.setPersonalInformation(refIndividual);
        CompanyRefType refCompany = new CompanyRefType();
        refCompany.setID(contact.getCompanyId());
        refCompany.setName(contact.getCompanyName());
        contactType.setCompany(refCompany);
        return contactType;
    }

    public static IndividualType createIndividualType(User user) {
        IndividualType ind = new IndividualType();
        ind.setID(user.getId());
        ind.addEmailAddress(user.getEmail());
        NameType nt = new NameType();
        nt.setFirstName(user.getFirstName());
        nt.setMiddleName(user.getMiddleName());
        nt.setLastName(user.getLastName());
        nt.setInitials(user.getInitials());
        ind.setName(nt);
        ind.setSubject(nt.getFirstName() + " " + nt.getLastName());
        if (StringUtil.isValid(user.getMobilephoneNumber())) {
            ind.addPhoneNumber(BrokerGDFHelper.createPhoneNumberType(user.getMobilephoneNumber(), "Mobile"));
        }
        if (StringUtil.isValid(user.getHomephoneNumber())) {
            ind.addPhoneNumber(BrokerGDFHelper.createPhoneNumberType(user.getHomephoneNumber(), "Home"));
        }
        if (user.getAddress() != null) {
            ind.addAddress(BrokerGDFHelper.createAddressType(user.getAddress()));
        }
        try {
            if (StringUtil.isValid(user.getProfileImage())) {
                String filename = "profile-" + user.getUsername();
                BirdFile profileFile = SelfServiceEngine.getBirdSession().getDatabase().getFileByName(filename);
                if (profileFile != null) {
                    byte[] image = IOUtils.toByteArray((InputStream)profileFile.getBody());
                    FileAttachmentType ft = new FileAttachmentType();
                    ft.setEncoding("UTF-8");
                    ft.setFileName(FilenameUtils.getName((String)user.getProfileImage()));
                    ft.setFileSize((long)image.length);
                    ft.setMimeType("image/" + FilenameUtils.getExtension((String)ft.getFileName()).toLowerCase());
                    ft.setStream(image);
                    ind.setPhoto(ft);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ind;
    }

    private static AddressType createAddressType(Address address) {
        AddressType a = new AddressType();
        a.setStreetName(address.getStreetName());
        a.setCity(address.getCity());
        a.setState(address.getState());
        a.setPostCode(address.getPostcode());
        if (StringUtil.isValid(address.getCountry())) {
            ListValueRefType ref = new ListValueRefType();
            ref.setName(address.getCountry());
            a.setCountry(ref);
        }
        return a;
    }

    private static PhoneNumberType createPhoneNumberType(String number, String type) {
        PhoneNumberType p = new PhoneNumberType();
        p.setNumber(number);
        ListValueRefType ref = new ListValueRefType();
        ref.setName(type);
        p.setType(ref);
        return p;
    }
}

