/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.av;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import net.gopro.selfservice.IVirusScanner;
import net.gopro.selfservice.data.Attachment;
import net.gopro.selfservice.exceptions.VirusFoundException;
import net.gopro.selfservice.exceptions.VirusScannerException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AVGImpl
implements IVirusScanner {
    private static Logger logger = Logger.getLogger(AVGImpl.class);
    private String programPath;
    private String paramScanFolder;

    @Override
    public void setConfiguration(String hostname, Integer port, Properties config) throws VirusScannerException {
        if (config != null) {
            this.programPath = config.getProperty("av.win.scanner");
            this.paramScanFolder = config.getProperty("av.win.param.folder");
        }
    }

    @Override
    public void initialize() throws VirusScannerException {
        File file;
        if (this.programPath != null) {
            file = new File(this.programPath);
            if (file.isDirectory()) {
                throw new VirusScannerException("The given program path is invalid, is should point to a executable not folder path");
            }
            if (!file.exists()) {
                throw new VirusScannerException("The given program path is invalid, file not found at given path: " + this.programPath);
            }
        } else {
            throw new VirusScannerException("The config key \"av.win.scanner\" is missing from the configuration.");
        }
        if (this.paramScanFolder != null) {
            file = new File(this.paramScanFolder);
            if (!file.exists() || !file.isDirectory()) {
                throw new VirusScannerException("The given folder path is invalid.  The folder must exist: " + this.paramScanFolder);
            }
        } else {
            throw new VirusScannerException("The config key \"av.win.param.folder\" is missing from the configuration.");
        }
    }

    @Override
    public void scan(Attachment att) throws VirusFoundException, VirusScannerException {
        this.scan(att, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void scan(Attachment att, int userInteruptCounter) throws VirusFoundException, VirusScannerException {
        String scanId = UUID.randomUUID().toString();
        String reportfile = "scan-" + scanId + ".txt";
        if (att == null || att.getStream() == null) throw new VirusScannerException("Nothing to scan or empty file.");
        try {
            ReturnCode returnCode = this.scan(att, scanId);
            if (ReturnCode.VIRUSDETECTED.equals((Object)returnCode)) {
                File report = new File(this.paramScanFolder + "/" + reportfile);
                String result = this.readReport(report);
                if (result != null && !result.equals("")) throw new VirusFoundException("The uploaded file is infected: " + result);
                throw new VirusScannerException("Anti virus scan failed, not report was written by AVG!");
            }
            if (ReturnCode.PUPDETECTED.equals((Object)returnCode)) {
                throw new VirusScannerException("The Virus scan detected Potentially Unwanted Program.");
            }
            if (ReturnCode.USERSTOP.equals((Object)returnCode)) {
                if (userInteruptCounter >= 5) return;
                logger.debug((Object)("Return Code: Interupt: retry: " + ++userInteruptCounter));
                this.scan(att, userInteruptCounter);
                return;
            } else {
                if (ReturnCode.PWDARCHIVE.equals((Object)returnCode)) {
                    throw new VirusScannerException("The uploaded file is a password protected archive, file rejected.");
                }
                if (!ReturnCode.ERROR.equals((Object)returnCode)) return;
                throw new VirusScannerException("The virus scan could not be executed, please inform webmaster.");
            }
        }
        catch (InterruptedException ex) {
            logger.debug((Object)"Virus Scan Thread was interupted ..");
            logger.error((Object)ex);
            throw new VirusScannerException(ex);
        }
        catch (MalformedURLException ex) {
            throw new VirusScannerException(ex);
        }
        catch (IOException ex) {
            logger.error((Object)ex);
            throw new VirusScannerException(ex);
        }
    }

    /*
     * Exception decompiling
     */
    private synchronized ReturnCode scan(Attachment att, String scanId) throws InterruptedException, VirusScannerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 18[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized String readReport(File report) throws IOException {
        List lines = FileUtils.readLines((File)report);
        Iterator it = lines.iterator();
        int lineCounter = 1;
        String scanResults = "";
        while (it.hasNext()) {
            String line = (String)it.next();
            if (lineCounter == 5) {
                scanResults = line;
            }
            ++lineCounter;
        }
        String[] results = StringUtils.split((String)scanResults, (String)" ");
        String output = "";
        for (int i = 0; i < results.length; ++i) {
            if (i == 0) continue;
            output = output + results[i] + " ";
        }
        return output.trim();
    }

    private static enum ReturnCode {
        OK(0),
        USERSTOP(1),
        ERROR(2),
        WARNING(3),
        PUPDETECTED(4),
        VIRUSDETECTED(5),
        PWDARCHIVE(6);

        private Integer code;

        private ReturnCode(Integer num) {
            this.code = num;
        }
    }
}

