/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.agents;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.ResourceBundle;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.communications.Messenger;
import net.gopro.selfservice.communications.Translator;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.Message;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.Task;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.CommunicationException;
import net.gopro.selfservice.exceptions.MessageException;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.TaskService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.ImpersonationUtil;
import net.gopro.selfservice.util.LocaleUtil;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class TaskAgent
implements Job {
    private static int TASK_AGE_IN_HOURS = 48;
    private static final String METAKEY = "user.reminder";
    private static final Logger logger = Logger.getLogger(TaskAgent.class);

    public TaskAgent() {
        TASK_AGE_IN_HOURS = this.getTaskReminderAge();
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            ImpersonationUtil.impersonate();
            logger.info((Object)("Task age used from config: " + TASK_AGE_IN_HOURS + " hours."));
            List<Task> taskList = TaskService.getTasks();
            ArrayList<Task> reminderList = new ArrayList<Task>();
            for (Task task : taskList) {
                if (!this.isReminderNeeded(task)) continue;
                reminderList.add(task);
            }
            if (reminderList.size() > 0) {
                logger.info((Object)String.format("Sending reminder for %d tasks.", reminderList.size()));
                this.processTaskList(reminderList);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new JobExecutionException((Throwable)ex);
        }
        finally {
            ImpersonationUtil.destroy();
        }
    }

    private synchronized void processTaskList(List<Task> taskList) throws MessageException, CommunicationException, SelfServiceException {
        for (Task task : taskList) {
            User responsible = UserService.getUser(task.getResponsibleId());
            if (responsible == null) {
                logger.warn((Object)String.format("No responsible user found for task: %s. Task Id: %s", task.getSubject(), task.getId()));
                continue;
            }
            ResourceBundle rb = null;
            rb = LocaleUtil.isAvailableLocale(responsible.getLocale()) ? LocaleUtil.getResourceBundle("portal.messages", responsible.getLocale()) : LocaleUtil.getResourceBundle("portal.messages");
            String subject = Translator.translate(Arrays.asList(task, responsible), rb.getString("task.reminder.subject"));
            String body = Translator.translate(Arrays.asList(task, responsible), rb.getString("task.reminder.body"));
            Message reminder = new Message();
            reminder.setSubject(subject);
            reminder.setBody(body);
            reminder.setTemplateKey("task.reminder");
            reminder.setRecipientId(responsible.getId());
            reminder.setSenderName("GoPro Case Agent");
            reminder.setParentId(task.getId());
            MetaData meta = new MetaData();
            meta.setKey(METAKEY);
            meta.setUserId(task.getResponsibleId());
            meta.setReferenceId(task.getId());
            meta.setValue(String.valueOf(Calendar.getInstance().getTimeInMillis()));
            Organization org = this.resolveOrganization(task);
            logger.info((Object)String.format("Sending reminder to user %s for Task \"%s\"", responsible.getFullname(), task.getSubject()));
            if (org != null) {
                if (!Messenger.sendMessage(responsible, reminder, org, Organization.MailPreference.TaskReminders)) continue;
                ConfigService.createMetaData(meta);
                continue;
            }
            if (!Messenger.sendMessage(responsible, reminder)) continue;
            ConfigService.createMetaData(meta);
        }
    }

    private Organization resolveOrganization(Task task) throws SelfServiceException {
        if (task.getParentId() != null) {
            BaseCase parentCase;
            String parentDocumentId = task.getParentId();
            BaseCase bc = CaseService.getCase(parentDocumentId);
            if (bc != null) {
                return ConfigService.getOrganization(bc.getOrganizationId());
            }
            SubDocument sub = CaseService.getSubDocument(parentDocumentId, false);
            if (sub != null && (parentCase = CaseService.getCase(sub.getCaseId())) != null) {
                return ConfigService.getOrganization(parentCase.getOrganizationId());
            }
        }
        List<Organization> organizations = ConfigService.getOrganizations();
        BaseDocumentUtil.removeDeletedDocuments(organizations);
        if (organizations.size() == 1) {
            return organizations.get(0);
        }
        return null;
    }

    private synchronized boolean isReminderNeeded(Task task) throws SelfServiceException {
        MetaData meta;
        Task theTask;
        if (task.isDeleted() || task.isCompleted()) {
            return false;
        }
        if (task.getDeadline() == 0L) {
            return false;
        }
        Calendar deadline = Calendar.getInstance();
        deadline.setTimeInMillis(task.getDeadline());
        Calendar dateLimit = Calendar.getInstance();
        dateLimit.add(11, -TASK_AGE_IN_HOURS);
        return dateLimit.getTimeInMillis() > deadline.getTimeInMillis() && (theTask = TaskService.getTask(task.getId())) != null && (meta = theTask.getMetaDataByKey(METAKEY)) == null;
    }

    private int getTaskReminderAge() {
        String hours = SelfServiceEngine.getConfig("tasks.reminder.hours");
        try {
            return Integer.parseInt(hours);
        }
        catch (Exception ex) {
            logger.warn((Object)"TASK_REMINDER_HOURS is not properly set in the selfservice-config.xml file.");
            return 48;
        }
    }
}

