/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.agents;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.gopro.selfservice.ITargetGroupGenerator;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.data.DirectoryUser;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.targetgroup.TargetGroup;
import net.gopro.selfservice.data.targetgroup.TargetGroupUser;
import net.gopro.selfservice.exceptions.CommunicationException;
import net.gopro.selfservice.exceptions.TargetGroupException;
import net.gopro.selfservice.filters.UserFilter;
import net.gopro.selfservice.services.TargetgroupService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.AdminUtil;
import net.gopro.selfservice.util.ImpersonationUtil;
import net.gopro.selfservice.util.StringUtil;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class TargetGroupAgent
implements Job {
    private static final Logger logger = Logger.getLogger(TargetGroupAgent.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        block13: {
            TargetGroup group = null;
            try {
                ImpersonationUtil.impersonate();
                JobDataMap map = context.getJobDetail().getJobDataMap();
                String targetGroupId = map.getString("id");
                group = TargetgroupService.getTargetGroup(targetGroupId, false);
                if (group == null || !group.getGenerator().equals((Object)TargetGroup.Generator.CLASS) || !group.isEnabled() || group.isDeleted()) break block13;
                logger.info((Object)("Updating Target Group: " + group.getSubject()));
                ITargetGroupGenerator generator = group.getGeneratorInstance();
                if (generator instanceof ITargetGroupGenerator) {
                    Properties props = group.getParametersAsProperties();
                    generator.setProperties(props);
                    List<DirectoryUser> directoryUserList = generator.getAudience(group);
                    ArrayList<User> userList = new ArrayList<User>();
                    for (DirectoryUser directoryUser : directoryUserList) {
                        User user = null;
                        if (StringUtil.isValid(directoryUser.getSelfServiceUserId())) {
                            user = UserService.getUser(directoryUser.getSelfServiceUserId());
                        }
                        if (user == null && StringUtil.isValid(directoryUser.getEmail())) {
                            user = UserService.getUserByEmail(directoryUser.getEmail());
                        }
                        if (user == null && StringUtil.isValid(directoryUser.getFullName())) {
                            UserFilter userFilter = new UserFilter();
                            userFilter.setSearchString(directoryUser.getFullName());
                            List<User> uResults = UserService.getUsers(userFilter);
                            if (uResults.size() == 1) {
                                user = uResults.get(0);
                            }
                        }
                        if (user == null || userList.contains(user)) continue;
                        userList.add(user);
                    }
                    generator.getAudienceCallback(userList);
                    ArrayList<TargetGroupUser> targetGroupUserList = new ArrayList<TargetGroupUser>();
                    for (User u : userList) {
                        TargetGroupUser tu = new TargetGroupUser(group.getId(), u.getId());
                        targetGroupUserList.add(tu);
                    }
                    group.getGroupUsers().addAll(targetGroupUserList);
                    TargetgroupService.updateTargetGroupUsers(group);
                    break block13;
                }
                throw new SelfServiceException("The Generator Class could not be loaded: " + group.getClassName());
            }
            catch (TargetGroupException ex) {
                logger.error((Object)"Error updating Target Group", (Throwable)ex);
                this.sendErrorReport(group, ex);
                throw new JobExecutionException((Throwable)ex);
            }
            catch (SelfServiceException ex) {
                logger.error((Object)"Error updating Target Group", (Throwable)ex);
                this.sendErrorReport(group, ex);
                throw new JobExecutionException((Throwable)ex);
            }
            finally {
                ImpersonationUtil.destroy();
            }
        }
    }

    private void sendErrorReport(TargetGroup group, Exception ex) {
        try {
            String subject = "Error updating Target Group";
            String body = "There was an error in a scheduled agent updating Target Group. The stacktrace is included.";
            if (group != null) {
                subject = subject + ": " + group.getSubject();
            }
            AdminUtil.sendErrorReport(subject, body, ex);
        }
        catch (CommunicationException cex) {
            logger.error((Object)"Error sending Target Group Error Report", (Throwable)cex);
        }
    }
}

