/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.agents;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.dalc.BaseDalc;
import net.gopro.selfservice.data.ApplicationForm;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.gopro.RemoteGoPro;
import net.gopro.selfservice.data.routing.RoutingQueueEntry;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.QueueService;
import net.gopro.selfservice.util.ImpersonationUtil;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class QueueHitAgent
extends BaseDalc
implements Job {
    private static final Logger logger = Logger.getLogger(QueueHitAgent.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            ImpersonationUtil.impersonate();
            logger.info((Object)(QueueHitAgent.class.getCanonicalName() + " running."));
            ArrayList<MissingEntry> entries = new ArrayList<MissingEntry>();
            for (Organization org : ConfigService.getOrganizations()) {
                if (!org.isEnabled() || org.isDeleted() || RemoteGoPro.GoPro.BROKER_PICKUP.equals((Object)org.getEndpoint().getGoproType())) continue;
                entries.addAll(this.getMissingRoutingQueueEntries(org));
            }
            logger.info((Object)("Possible missing entries found: " + entries.size()));
            if (!entries.isEmpty()) {
                int entryCount = this.insertMissingEntries(entries);
                logger.info((Object)String.format("Added %d entries to the routing queue.", entryCount));
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new JobExecutionException((Throwable)ex);
        }
        catch (SelfServiceException ex) {
            logger.error((Object)ex);
            throw new JobExecutionException((Throwable)ex);
        }
        finally {
            ImpersonationUtil.destroy();
        }
    }

    private int insertMissingEntries(List<MissingEntry> entries) throws SelfServiceException {
        int insertions = 0;
        for (MissingEntry entry : entries) {
            RoutingQueueEntry ret = new RoutingQueueEntry(entry.id, entry.organizationId, RoutingQueueEntry.DocumentType.SUBDOCUMENT);
            ret.setResend(false);
            if (!QueueService.createRoutingQueueEntry(ret)) continue;
            ++insertions;
        }
        return insertions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MissingEntry> getMissingRoutingQueueEntries(Organization org) throws SQLException {
        ArrayList<MissingEntry> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<MissingEntry> list = new ArrayList<MissingEntry>();
        String sql = "SELECT d.document_id, d.subject, c.organization_id FROM ss_documents d INNER JOIN ss_cases c ON c.case_id = d.case_id WHERE c.is_sent = 1 AND c.is_deleted = 0 AND c.gopro_id IS NOT NULL AND d.is_sent = 1 AND d.is_deleted = 0 AND d.gopro_id IS NULL AND d.classname <> ? AND d.document_id NOT IN (SELECT q.document_id FROM ss_queue q)";
        try {
            con = this.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setString(1, ApplicationForm.class.getName());
            rs = stmt.executeQuery();
            while (rs.next()) {
                list.add(new MissingEntry(rs));
            }
            rs.close();
            arrayList = list;
        }
        catch (Throwable throwable) {
            this.closeStatement(stmt);
            this.closeConnection(con);
            throw throwable;
        }
        this.closeStatement(stmt);
        this.closeConnection(con);
        return arrayList;
    }

    private class MissingEntry {
        private String id;
        private String title;
        private String organizationId;

        public MissingEntry(ResultSet rs) throws SQLException {
            this.id = rs.getString("document_id");
            this.title = rs.getString("subject");
            this.organizationId = rs.getString("organization_id");
        }
    }
}

