/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.agents;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.communications.Messenger;
import net.gopro.selfservice.communications.Translator;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.ConfigEntry;
import net.gopro.selfservice.data.FormCase;
import net.gopro.selfservice.data.FormTemplate;
import net.gopro.selfservice.data.Message;
import net.gopro.selfservice.data.MetaData;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.CommunicationException;
import net.gopro.selfservice.exceptions.ConfigException;
import net.gopro.selfservice.exceptions.MessageException;
import net.gopro.selfservice.filters.DocumentFilter;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.FormService;
import net.gopro.selfservice.services.SearchService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.ImpersonationUtil;
import net.gopro.selfservice.util.LocaleUtil;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public final class FormCaseReminder
implements Job {
    private static int CASE_AGE_IN_HOURS = 48;
    private static final String lastRunConfigKey = "agent.formreminder.lastrun";
    private static final String METAKEY = "user.reminder";
    private static final Logger logger = Logger.getLogger(FormCaseReminder.class);

    public FormCaseReminder() {
        CASE_AGE_IN_HOURS = this.getCaseReminderAge();
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            ImpersonationUtil.impersonate();
            Date runTimeStart = new Date();
            logger.info((Object)("Case age used from config: " + CASE_AGE_IN_HOURS + " hours."));
            ConfigEntry entry = this.getStamp();
            Calendar lastRunDate = this.getLastStamp(entry);
            Calendar startingDate = Calendar.getInstance();
            startingDate.setTime(lastRunDate.getTime());
            startingDate.add(11, -(CASE_AGE_IN_HOURS + 24));
            logger.info((Object)String.format("Last successful run finished at %s", lastRunDate.getTime().toGMTString()));
            logger.info((Object)String.format("Get cases modified after %s", startingDate.getTime().toGMTString()));
            DocumentFilter filter = new DocumentFilter();
            filter.addDocumentType(FormCase.class);
            filter.setDeletionStatus(DocumentFilter.DeletionStatus.NOT_DELETED);
            filter.setCaseTemplateId("00278849E25F336B0000012E156D54D9");
            filter.setModifiedDateFrom(startingDate.getTime());
            List<BaseDocument> caseList = SearchService.getDocuments(filter);
            logger.info((Object)String.format("Case list size to examine: %d", caseList.size()));
            ArrayList<FormCase> reminderList = new ArrayList<FormCase>();
            for (BaseDocument bc : caseList) {
                if (bc.isDeleted() || !(bc instanceof FormCase) || !this.isReminderNeeded((FormCase)bc)) continue;
                reminderList.add((FormCase)bc);
            }
            if (reminderList.size() > 0) {
                this.processCaseList(reminderList);
            }
            entry.setValue(String.valueOf(runTimeStart.getTime()));
            this.updateStamp(entry);
            logger.info((Object)String.format("Form Case reminder finised. Sent %d notifications", reminderList.size()));
        }
        catch (SelfServiceException ex) {
            logger.error((Object)ex);
            throw new JobExecutionException((Throwable)ex);
        }
        catch (MessageException ex) {
            logger.error((Object)ex);
            throw new JobExecutionException((Throwable)ex);
        }
        catch (CommunicationException ex) {
            logger.error((Object)ex);
            throw new JobExecutionException((Throwable)ex);
        }
        finally {
            ImpersonationUtil.destroy();
        }
    }

    private synchronized void processCaseList(List<FormCase> caseList) throws MessageException, CommunicationException, SelfServiceException {
        for (FormCase fc : caseList) {
            User author = UserService.getUser(fc.getCreatedById());
            FormTemplate ft = FormService.getFormTemplate(fc.getFormtemplateId(), false);
            ResourceBundle rb = null;
            rb = LocaleUtil.isAvailableLocale(author.getLocale()) ? LocaleUtil.getResourceBundle("portal.messages", author.getLocale()) : LocaleUtil.getResourceBundle("portal.messages");
            String subject = Translator.translate(Arrays.asList(fc, ft, author), rb.getString("case.reminder.subject"));
            String body = Translator.translate(Arrays.asList(fc, ft, author), rb.getString("case.reminder.body"));
            Message reminder = new Message();
            reminder.setSubject(subject);
            reminder.setBody(body);
            reminder.setTemplateKey("case.reminder");
            reminder.setRecipientId(author.getId());
            reminder.setSenderName("GoPro Case Agent");
            reminder.setParentId(fc.getId());
            Organization org = ConfigService.getOrganization(fc.getOrganizationId());
            logger.info((Object)String.format("Sending reminder to user %s for application \"%s\"", author.getFullname(), fc.getSubject()));
            if (!Messenger.sendMessage(author, reminder, org, Organization.MailPreference.CaseReminders)) continue;
            MetaData meta = new MetaData();
            meta.setKey(METAKEY);
            meta.setUserId(fc.getCreatedById());
            meta.setReferenceId(fc.getId());
            meta.setValue(String.valueOf(Calendar.getInstance().getTimeInMillis()));
            ConfigService.createMetaData(meta);
        }
    }

    private synchronized boolean isReminderNeeded(FormCase fc) throws SelfServiceException {
        MetaData meta;
        BaseCase bc;
        if (fc.isDeleted() || fc.isSent()) {
            return false;
        }
        Calendar lastModified = Calendar.getInstance();
        lastModified.setTimeInMillis(fc.getDateModified());
        Calendar dateLimit = Calendar.getInstance();
        dateLimit.add(11, -CASE_AGE_IN_HOURS);
        return dateLimit.getTimeInMillis() > lastModified.getTimeInMillis() && (bc = CaseService.getCase(fc.getId())) != null && (meta = bc.getMetaDataByKey(METAKEY)) == null;
    }

    private Calendar getLastStamp(ConfigEntry entry) throws SelfServiceException {
        long stamp = Long.parseLong(entry.getValue());
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(stamp);
        return cal;
    }

    private synchronized void updateStamp(ConfigEntry entry) throws SelfServiceException {
        try {
            ConfigService.updateConfig(entry);
        }
        catch (ConfigException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private synchronized ConfigEntry getStamp() throws SelfServiceException {
        try {
            ConfigEntry entry = ConfigService.getConfigByKey(lastRunConfigKey);
            if (entry != null) {
                return entry;
            }
            Calendar cal = Calendar.getInstance();
            cal.set(2000, 0, 1, 0, 0);
            entry = new ConfigEntry();
            entry.setKey(lastRunConfigKey);
            entry.setVisible(false);
            entry.setValue(String.valueOf(cal.getTimeInMillis()));
            entry.setSection("agent");
            ConfigService.createConfig(entry);
            return entry;
        }
        catch (ConfigException ex) {
            throw new SelfServiceException(ex);
        }
    }

    private int getCaseReminderAge() {
        String hours = SelfServiceEngine.getConfig("agent.casereminder.hours");
        try {
            return Integer.parseInt(hours);
        }
        catch (Exception ex) {
            logger.warn((Object)"AGENT_CASE_REMINDER_HOURS is not properly set in the selfservice-config.xml file.");
            return 48;
        }
    }
}

