/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.agents;

import java.net.InetAddress;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.data.routing.QueueLogEntry;
import net.gopro.selfservice.data.routing.RoutingQueueInformationEntry;
import net.gopro.selfservice.exceptions.CommunicationException;
import net.gopro.selfservice.filters.RoutingLogFilter;
import net.gopro.selfservice.services.QueueService;
import net.gopro.selfservice.util.AdminUtil;
import net.gopro.selfservice.util.ImpersonationUtil;
import net.gopro.selfservice.util.LocaleUtil;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DataQueueAgent
implements Job {
    private static final Logger logger = Logger.getLogger(DataQueueAgent.class);
    private int documentCounter = 1;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            logger.info((Object)"Data Queue agent running.");
            ImpersonationUtil.impersonate();
            StringBuffer sb = new StringBuffer();
            Calendar start = Calendar.getInstance();
            start.add(1, -1);
            Calendar yesterday = Calendar.getInstance();
            yesterday.set(5, -1);
            yesterday.set(11, 0);
            RoutingLogFilter filter = new RoutingLogFilter(start.getTime(), new Date());
            filter.setStatus(RoutingLogFilter.DeliveryStatus.NOTSENT);
            List<RoutingQueueInformationEntry> list = QueueService.getRoutingQueueStatus(filter);
            if (list != null && list.size() > 0) {
                for (RoutingQueueInformationEntry entry : list) {
                    if (entry.getDateCreated() >= yesterday.getTimeInMillis()) continue;
                    QueueLogEntry logEntry = null;
                    List<QueueLogEntry> logList = QueueService.getQueueLog(entry.getId());
                    if (logList != null && logList.size() > 0) {
                        logEntry = logList.get(0);
                    }
                    this.createItemReport(sb, entry, logEntry, false);
                }
            }
            filter = new RoutingLogFilter(start.getTime(), new Date());
            filter.setBrokerFilter(true);
            filter.setStatus(RoutingLogFilter.DeliveryStatus.NOTSENT);
            list = QueueService.getRoutingQueueStatus(filter);
            if (list != null && list.size() > 0) {
                for (RoutingQueueInformationEntry entry : list) {
                    if (entry.getDateCreated() >= yesterday.getTimeInMillis()) continue;
                    this.createItemReport(sb, entry, null, true);
                }
            }
            if (sb.length() > 0) {
                this.sendErrorReport(sb);
            }
            logger.info((Object)"Data Queue agent finished.");
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new JobExecutionException((Throwable)ex);
        }
        finally {
            ImpersonationUtil.destroy();
        }
    }

    private void createItemReport(StringBuffer sb, RoutingQueueInformationEntry entry, QueueLogEntry log, boolean isBrokerQueue) {
        String queueType = "Self Service Queue";
        if (isBrokerQueue) {
            queueType = "Broker Queue";
        }
        String s = this.documentCounter + ". " + entry.getDocumentType().toString();
        s = s + " (Iterations:" + entry.getIterationCount() + " - Queue:" + queueType + ") \n";
        s = s + "Author: " + entry.getFullname() + ".  Created on: " + LocaleUtil.formatDate(entry.getDateCreated()) + "\n";
        s = s + "Target GoPro: " + entry.getOrganizationName() + " \n\n";
        if (log != null) {
            s = s + "Error message: " + log.getMessage() + "\n";
            s = s + "Error stacktrace: \n";
            s = s + log.getStacktrace();
        }
        s = s + "\n\n\n";
        ++this.documentCounter;
        sb.append(s);
    }

    private String createServerHeader() {
        String s = "";
        try {
            s = s + "Self Service url: " + SelfServiceEngine.getConfig("web.domain") + "\n";
            s = s + "Host name: " + InetAddress.getLocalHost().getHostName() + "\n\n";
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return s;
    }

    private void sendErrorReport(StringBuffer sb) {
        try {
            String subject = "Undelivered documents in routing queue";
            String body = this.createServerHeader() + sb.toString();
            AdminUtil.sendErrorReport("Undelivered documents in routing queue", body);
        }
        catch (CommunicationException ex) {
            logger.error((Object)"Error sending Routing queue Report", (Throwable)ex);
        }
    }
}

