/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice.agents;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.communications.Messenger;
import net.gopro.selfservice.communications.Translator;
import net.gopro.selfservice.data.AuditLog;
import net.gopro.selfservice.data.AuditLogEntry;
import net.gopro.selfservice.data.BaseCase;
import net.gopro.selfservice.data.BaseDocument;
import net.gopro.selfservice.data.CheckoutTicket;
import net.gopro.selfservice.data.Organization;
import net.gopro.selfservice.data.SimpleMessage;
import net.gopro.selfservice.data.SubDocument;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.exceptions.CommunicationException;
import net.gopro.selfservice.exceptions.MessageException;
import net.gopro.selfservice.filters.AuditLogFilter;
import net.gopro.selfservice.services.CaseService;
import net.gopro.selfservice.services.ConfigService;
import net.gopro.selfservice.services.LogService;
import net.gopro.selfservice.services.UserService;
import net.gopro.selfservice.util.ImpersonationUtil;
import net.gopro.selfservice.util.LocaleUtil;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class CheckInAgent
implements Job {
    private static final int HOUR_BUFFER = 4;
    private static final Logger logger = Logger.getLogger(CheckInAgent.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            ImpersonationUtil.impersonate();
            int maxCheckOutHours = Integer.parseInt(SelfServiceEngine.getConfig("agent.checkout.maxhours"));
            logger.debug((Object)("Max Checkout time is: " + maxCheckOutHours + " hours."));
            List<SubDocument> list = CaseService.getCheckedOutDocuments();
            for (SubDocument sub : list) {
                CheckoutTicket ticket = sub.getCheckoutTicket();
                long checkedOutMinutes = (new Date().getTime() - ticket.getDateCheckedOut()) / 1000L / 60L;
                long modifiedSinceMinutes = (new Date().getTime() - sub.getDateModified()) / 1000L / 60L;
                if (checkedOutMinutes <= (long)(maxCheckOutHours * 60)) continue;
                AuditLogFilter filter = new AuditLogFilter();
                filter.addAction(AuditLogEntry.Action.LOGIN);
                filter.addDataType(AuditLogEntry.DataType.USER);
                filter.addUserId(ticket.getUserId());
                Calendar startDate = Calendar.getInstance();
                startDate.add(11, -(maxCheckOutHours + 4));
                filter.setDateFilter(startDate.getTime(), new Date());
                AuditLog auditLog = LogService.getAuditLog(filter);
                if (auditLog.getEntries().size() == 0) {
                    if (!CaseService.checkInDocument(ticket.getDocumentId())) continue;
                    logger.info((Object)("System has forced check-in for document: " + sub.getSubject() + ". It has been checked out for " + checkedOutMinutes + " minutes without modifications."));
                    User user = UserService.getUser(ticket.getUserId());
                    this.sendCheckinMessage(user, sub);
                    continue;
                }
                long minuteThreshold = 240L;
                long minutesSinceLastLogin = this.minutesSinceLastLogin(auditLog);
                if (minutesSinceLastLogin < 240L) {
                    logger.debug((Object)("Checking will not be forced on document " + sub.getSubject() + ".  The user was last active " + minutesSinceLastLogin + " minutes ago."));
                    continue;
                }
                if (modifiedSinceMinutes < 240L) {
                    logger.debug((Object)("Checking will not be forced on document " + sub.getSubject() + ".  The document was last modified" + minutesSinceLastLogin + " minutes ago."));
                    continue;
                }
                if (!CaseService.checkInDocument(ticket.getDocumentId())) continue;
                logger.info((Object)("System has forced check-in for document: " + sub.getSubject() + ". It has been checked out for " + checkedOutMinutes + " minutes without modifications."));
                User user = UserService.getUser(ticket.getUserId());
                this.sendCheckinMessage(user, sub);
            }
        }
        catch (SelfServiceException ex) {
            throw new JobExecutionException((Throwable)ex);
        }
        catch (CommunicationException ex) {
            throw new JobExecutionException((Throwable)ex);
        }
        catch (MessageException ex) {
            throw new JobExecutionException((Throwable)ex);
        }
        finally {
            ImpersonationUtil.destroy();
        }
    }

    private final long minutesSinceLastLogin(AuditLog log) {
        long lastLogin = -1L;
        for (AuditLogEntry entry : log.getEntries()) {
            long minutesSinceLogin = (new Date().getTime() - entry.getTimestamp()) / 1000L / 60L;
            if (lastLogin == -1L) {
                lastLogin = minutesSinceLogin;
                continue;
            }
            if (minutesSinceLogin >= lastLogin) continue;
            lastLogin = minutesSinceLogin;
        }
        return lastLogin;
    }

    private final void sendCheckinMessage(User user, SubDocument doc) throws CommunicationException, MessageException, SelfServiceException {
        String userLocale = user.getLocale();
        ResourceBundle rb = null;
        rb = LocaleUtil.isAvailableLocale(userLocale) ? LocaleUtil.getResourceBundle("portal.messages", userLocale) : LocaleUtil.getResourceBundle("portal.messages");
        List<BaseDocument> transObjects = Arrays.asList(user, doc);
        String subject = Translator.translate(transObjects, rb.getString("system.checkin.subject"));
        String message = Translator.translate(transObjects, rb.getString("system.checkin.body"));
        BaseCase bc = CaseService.getCase(doc.getCaseId());
        Organization org = ConfigService.getOrganization(bc.getOrganizationId());
        Messenger.sendMessage(user, new SimpleMessage(subject, message), true, org, Organization.MailPreference.CaseReminders, bc.getId());
    }
}

