/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice;

import is.hugvit.bird.DefaultRealm;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.SelfServicePrincipal;
import net.gopro.selfservice.data.User;
import net.gopro.selfservice.data.UserRole;
import net.gopro.selfservice.exceptions.AuthenticationException;
import net.gopro.selfservice.services.SecurityService;
import net.gopro.selfservice.services.UserService;

public class SelfServiceRealm
extends DefaultRealm {
    public Principal authenticate(String username, String credentials) {
        SelfServicePrincipal principal = null;
        try {
            User user = SecurityService.authenticate(username, credentials);
            if (user != null) {
                principal = user.getPrincipal();
            }
        }
        catch (AuthenticationException ex) {
            SelfServiceEngine.getLogger().info("Authentication failure: " + ex.getMessage());
            return null;
        }
        catch (SelfServiceException ex) {
            SelfServiceEngine.getLogger().info("Authentication error: " + ex.getMessage());
            return null;
        }
        return principal;
    }

    public String getInfo() {
        return "SelfService Realm 1.3";
    }

    public String[] getRoles() {
        try {
            ArrayList<String> roleList = new ArrayList<String>();
            for (String s : super.getRoles()) {
                roleList.add(s);
            }
            List<UserRole> selfserviceRoles = UserService.getUserRoles();
            for (UserRole role : selfserviceRoles) {
                roleList.add(role.getSubject());
            }
            String[] roles = new String[roleList.size()];
            for (int i = 0; i < roleList.size(); ++i) {
                roles[i] = (String)roleList.get(i);
            }
            return roles;
        }
        catch (SelfServiceException ex) {
            SelfServiceEngine.getLogger().error(ex.getMessage());
            return null;
        }
    }
}

