/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice;

import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdSession;
import is.hugvit.log.Log;
import is.hugvit.util.Cache;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import net.gopro.selfservice.EngineFactory;
import net.gopro.selfservice.SelfServiceException;
import net.gopro.selfservice.SelfServiceLogger;
import net.gopro.selfservice.agents.CheckInAgent;
import net.gopro.selfservice.agents.ConfigUpdate;
import net.gopro.selfservice.agents.DataQueueAgent;
import net.gopro.selfservice.agents.DataRetentionPolicyAgent;
import net.gopro.selfservice.agents.FormCaseReminder;
import net.gopro.selfservice.agents.QueueHitAgent;
import net.gopro.selfservice.agents.ScheduleCheckerAgent;
import net.gopro.selfservice.agents.TaskAgent;
import net.gopro.selfservice.data.ConfigEntry;
import net.gopro.selfservice.data.targetgroup.TargetGroup;
import net.gopro.selfservice.exceptions.TargetGroupException;
import net.gopro.selfservice.services.TargetgroupService;
import net.gopro.selfservice.util.BaseDocumentUtil;
import net.gopro.selfservice.util.SaxReader;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;
import org.quartz.impl.StdSchedulerFactory;
import org.xml.sax.SAXException;

public final class SelfServiceEngine {
    private static final Logger logger = Logger.getLogger(SelfServiceEngine.class);
    private static final String CONFIG_FILE = "selfservice-config.xml";
    private static BirdSession context;
    private static Properties config;
    private static boolean isInitialized;
    private static Cache cache;
    private static Scheduler scheduler;
    private static Connection connection;
    private static int configUpdateInterval;

    public static final void init(BirdSession s) throws BirdException {
        context = s;
        SelfServiceEngine.readConfig(null);
        SelfServiceEngine.startScheduler();
        SelfServiceEngine.getLogger().info("SelfService v." + SelfServiceEngine.getConfig("version") + " started.");
        isInitialized = true;
        try {
            Set<ConfigEntry> set = EngineFactory.getConfigEngine().getConfig();
            for (ConfigEntry c : set) {
                config.put(c.getKey(), c.getValue());
            }
            SelfServiceEngine.createInternalSchedules();
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public static final void init(ServletContext context, Connection con) throws BirdException {
        connection = con;
        cache = new Cache(100);
        SelfServiceEngine.readConfig(context);
        try {
            Set<ConfigEntry> set = EngineFactory.getConfigEngine().getConfig();
            for (ConfigEntry c : set) {
                cache.put((Object)c.getKey(), (Object)c.getValue());
            }
        }
        catch (SelfServiceException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public static final void addToCache(Object id, Object data) {
        cache.put(id, data);
    }

    public static final void removeFromCache(Object id) {
        cache.remove(id);
    }

    public static final Log getLogger() {
        if (context != null) {
            return context.getLog();
        }
        return new SelfServiceLogger();
    }

    public static Locale getServerLocale() {
        return context.getLocale();
    }

    public static final ServletContext getContext() {
        return context.getServletContext();
    }

    public static final String getEncoding() {
        String configKey = "encoding";
        if (context != null && context.getConfig().containsKey("encoding")) {
            return (String)context.getConfig().get("encoding");
        }
        return "ISO-8859-1";
    }

    public static final String getConfig(String key) {
        Object o = cache.get((Object)key);
        if (o != null) {
            return (String)o;
        }
        return config.getProperty(key);
    }

    public static BirdSession getBirdSession() {
        return context;
    }

    public static final List<String> getConfigKeys(String section) {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<Object> keys = config.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith(section)) continue;
            list.add(key);
        }
        return list;
    }

    public static final String getConfig(String key, String defaultValue) {
        String value = SelfServiceEngine.getConfig(key);
        return value == null ? defaultValue : value;
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static Connection getConnection() throws BirdException {
        if (connection != null) {
            return connection;
        }
        return context.getDatabase().connect();
    }

    public static final boolean isCustomConnection() {
        return connection != null;
    }

    public static final void setConnection(Connection con) throws BirdException {
        connection = con;
    }

    public static final void closeConnection() throws BirdException {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public static final Scheduler getScheduler() {
        return scheduler;
    }

    private static final void startScheduler() throws BirdException {
        try {
            StdSchedulerFactory schedFact = new StdSchedulerFactory();
            scheduler = schedFact.getScheduler();
            scheduler.start();
        }
        catch (SchedulerException ex) {
            throw new BirdException((Exception)((Object)ex));
        }
    }

    private static final void readConfig(ServletContext sContext) throws BirdException {
        try {
            InputStream in;
            if (sContext == null) {
                sContext = context.getServletContext();
            }
            if ((in = sContext.getResourceAsStream("/WEB-INF/selfservice-config.xml")) == null) {
                throw new BirdException("SelfService config file was not found! (selfservice-config.xml)");
            }
            SAXReader reader = SaxReader.createReader();
            Document doc = reader.read(in);
            in.close();
            String updateInterval = doc.getRootElement().valueOf("@update-interval");
            if (updateInterval != null) {
                try {
                    configUpdateInterval = Integer.parseInt(updateInterval);
                    if (configUpdateInterval > 0) {
                        logger.debug((Object)String.format("Config update interval set to %d minutes.", configUpdateInterval));
                    }
                }
                catch (Exception ex) {
                    logger.warn((Object)("Could not read update interval: " + ex.getMessage()));
                }
            }
            List items = doc.selectNodes("//property", ".");
            for (Node node : items) {
                String key = node.valueOf("@name");
                String val = node.valueOf("@value");
                if (key == null || val == null) continue;
                config.put(key, val);
            }
        }
        catch (DocumentException ex) {
            throw new BirdException("Error reading config file.", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new BirdException((Exception)ex);
        }
        catch (SAXException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public static String getModuleDirectory(String moduleName) {
        String basePath = context.getServletContext().getRealPath("/WEB-INF/modules/" + moduleName);
        File moduleDirectory = new File(basePath);
        if (moduleDirectory.exists()) {
            return moduleDirectory.getAbsolutePath();
        }
        return null;
    }

    public static Properties getModuleConfiguration(String moduleName) throws SelfServiceException {
        String basePath = context.getServletContext().getRealPath("/WEB-INF/modules/");
        String moduleFileName = "module-" + moduleName + ".xml".toLowerCase();
        try {
            if (new File(basePath).exists()) {
                Iterator fileIterator = FileUtils.iterateFiles((File)new File(basePath), (String[])new String[]{"xml"}, (boolean)false);
                while (fileIterator.hasNext()) {
                    File file = (File)fileIterator.next();
                    if (!file.isFile() || !file.getName().equals(moduleFileName)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)String.format("Loading configuration for module %s from file \"%s\"", moduleName, file.getName()));
                    }
                    Properties p = new Properties();
                    SAXReader reader = SaxReader.createReader();
                    Document doc = reader.read(file);
                    for (Node node : doc.selectNodes("//property", ".")) {
                        String key = node.valueOf("@name");
                        String val = node.valueOf("@value");
                        if (key == null || val == null) continue;
                        p.put(key, val);
                    }
                    return p;
                }
            }
            return null;
        }
        catch (Exception ex) {
            throw new SelfServiceException(ex);
        }
    }

    public static void forceConfigUpdate() throws BirdException {
        SelfServiceEngine.readConfig(null);
    }

    private static void createInternalSchedules() throws SelfServiceException {
        try {
            boolean isDisabled = "false".equalsIgnoreCase(SelfServiceEngine.getConfig("agent.schedules.active"));
            if (!isDisabled) {
                String groupName = "SelfService";
                JobDataMap map = new JobDataMap();
                JobDetail jobDetail = new JobDetail("Case Reminder", "SelfService", FormCaseReminder.class);
                jobDetail.setJobDataMap(map);
                Trigger trigger = TriggerUtils.makeDailyTrigger((int)3, (int)0);
                trigger.setStartTime(new Date());
                trigger.setName("Case Reminder");
                trigger.setGroup("SelfService");
                scheduler.scheduleJob(jobDetail, trigger);
                List<TargetGroup> targetgroups = TargetgroupService.getTargetGroups();
                BaseDocumentUtil.removeDeletedDocuments(targetgroups);
                for (TargetGroup group : targetgroups) {
                    if (!group.scheduleJob(scheduler)) continue;
                    SelfServiceEngine.getLogger().info("Starting schedule for Target Group: " + group.getSubject());
                }
                trigger = TriggerUtils.makeDailyTrigger((int)7, (int)0);
                trigger.setStartTime(new Date());
                trigger.setName("Queue notification");
                trigger.setGroup("SelfService");
                map = new JobDataMap();
                jobDetail = new JobDetail("Queue notification", "SelfService", DataQueueAgent.class);
                jobDetail.setJobDataMap(map);
                scheduler.scheduleJob(jobDetail, trigger);
                trigger = TriggerUtils.makeHourlyTrigger((int)2);
                trigger.setName("Schedule Manager Listener");
                trigger.setStartTime(new Date());
                trigger.setGroup("SelfService");
                jobDetail = new JobDetail("Schedule Manager Listener", "SelfService", ScheduleCheckerAgent.class);
                jobDetail.setJobDataMap(new JobDataMap());
                scheduler.scheduleJob(jobDetail, trigger);
                trigger = TriggerUtils.makeHourlyTrigger((int)2);
                trigger.setName("Checkin Agent");
                trigger.setStartTime(new Date());
                trigger.setGroup("SelfService");
                jobDetail = new JobDetail("Checking Agent", "SelfService", CheckInAgent.class);
                jobDetail.setJobDataMap(new JobDataMap());
                scheduler.scheduleJob(jobDetail, trigger);
                trigger = TriggerUtils.makeDailyTrigger((int)6, (int)0);
                trigger.setName("Queue Hit Agent");
                trigger.setDescription("Checks for documents that are missing from the routing queue");
                trigger.setStartTime(new Date());
                trigger.setGroup("SelfService");
                jobDetail = new JobDetail("Queue Hit Agent", "SelfService", QueueHitAgent.class);
                jobDetail.setJobDataMap(new JobDataMap());
                scheduler.scheduleJob(jobDetail, trigger);
                if (SelfServiceEngine.getConfig("tasks.notify", "false").equals("true")) {
                    trigger = TriggerUtils.makeDailyTrigger((int)6, (int)10);
                    trigger.setName("Task notification Agent");
                    trigger.setDescription("Send task notifications");
                    trigger.setStartTime(new Date());
                    trigger.setGroup("SelfService");
                    jobDetail = new JobDetail("Task notification Agent", "SelfService", TaskAgent.class);
                    jobDetail.setJobDataMap(new JobDataMap());
                    scheduler.scheduleJob(jobDetail, trigger);
                }
                if (SelfServiceEngine.getConfig("data.retention.enabled", "false").equals("true")) {
                    trigger = TriggerUtils.makeDailyTrigger((int)5, (int)30);
                    trigger.setName("Data Retention Policy Agent");
                    trigger.setDescription("Purge data based on age");
                    trigger.setStartTime(new Date());
                    trigger.setGroup("SelfService");
                    jobDetail = new JobDetail("Data Retention Policy Agent", "SelfService", DataRetentionPolicyAgent.class);
                    jobDetail.setJobDataMap(new JobDataMap());
                    scheduler.scheduleJob(jobDetail, trigger);
                }
                if (configUpdateInterval > 0) {
                    trigger = TriggerUtils.makeMinutelyTrigger((int)configUpdateInterval);
                    trigger.setName("Config Update Agent");
                    trigger.setStartTime(new Date());
                    trigger.setGroup("SelfService");
                    jobDetail = new JobDetail("Config Update Agent", "SelfService", ConfigUpdate.class);
                    jobDetail.setJobDataMap(new JobDataMap());
                    scheduler.scheduleJob(jobDetail, trigger);
                }
            }
        }
        catch (SchedulerException ex) {
            throw new SelfServiceException((Exception)((Object)ex));
        }
        catch (TargetGroupException ex) {
            throw new SelfServiceException(ex);
        }
    }

    public static int getConfigUpdateInterval() {
        return configUpdateInterval;
    }

    static {
        isInitialized = false;
        connection = null;
        configUpdateInterval = 0;
        cache = new Cache(100);
        config = new Properties();
    }
}

