/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.selfservice;

import is.hugvit.bird.BirdComponentBase;
import is.hugvit.bird.BirdDatabase;
import is.hugvit.bird.BirdException;
import is.hugvit.bird.BirdPage;
import is.hugvit.bird.BirdSession;
import is.hugvit.bird.core.BirdInstallHelper;
import java.io.InputStream;
import java.util.Properties;
import java.util.ResourceBundle;
import net.gopro.selfservice.SelfServiceEngine;
import net.gopro.selfservice.util.ThreadContext;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;

public class Install
extends BirdComponentBase {
    private static final Properties p = new Properties();
    private static ResourceBundle lang;
    private static Document idoc;

    public Properties getInfo() {
        return p;
    }

    public void start(BirdSession context) throws BirdException {
        SelfServiceEngine.init(context);
    }

    public void stop(BirdSession context) throws BirdException {
        super.stop(context);
        try {
            SelfServiceEngine.getScheduler().shutdown();
            StdSchedulerFactory.getDefaultScheduler().shutdown(true);
            ThreadContext.remove();
            Thread.sleep(1000L);
        }
        catch (SchedulerException ex) {
            throw new BirdException((Exception)((Object)ex));
        }
        catch (InterruptedException ex) {
            throw new BirdException((Exception)ex);
        }
    }

    public void install(BirdSession context) throws BirdException {
        lang = ResourceBundle.getBundle("net.gopro.selfservice.locale.install", context.getLocale());
        BirdDatabase db = context.getDatabase();
        this.loadInstallXML();
        context.getLog().info("Starting Self Service Installation");
        BirdInstallHelper helper = new BirdInstallHelper(idoc, lang, (Object)this);
        helper.Install(context, db);
        boolean hide = false;
        if (BirdInstallHelper.Procedure.Full.equals((Object)helper.getProcedure())) {
            BirdPage frontPage = context.getDatabase().getPageByName("index.html");
            if (frontPage != null) {
                frontPage.delete();
            }
            db.importXMLData(((Object)((Object)this)).getClass().getResourceAsStream("files/bird_pagetype.xml"), hide);
            db.importXMLData(((Object)((Object)this)).getClass().getResourceAsStream("files/bird_page.xml"), hide);
            db.importXMLData(((Object)((Object)this)).getClass().getResourceAsStream("files/bird_file.xml"), hide);
            db.importXMLData(((Object)((Object)this)).getClass().getResourceAsStream("files/bird_element.xml"), hide);
            db.importXMLData(((Object)((Object)this)).getClass().getResourceAsStream("files/bird_template.xml"), hide);
            db.importXMLData(((Object)((Object)this)).getClass().getResourceAsStream("files/bird_thread.xml"), hide);
        } else if (BirdInstallHelper.Procedure.Partial.equals((Object)helper.getProcedure())) {
            db.importXMLData(((Object)((Object)this)).getClass().getResourceAsStream("files/bird_file.xml"), hide);
        }
        context.getLog().info("Self Service Installation Finished");
    }

    public final void uninstall(BirdSession context) throws BirdException {
        this.loadInstallXML();
        BirdDatabase db = context.getDatabase();
        BirdInstallHelper helper = new BirdInstallHelper(idoc, lang, (Object)this);
        helper.Uninstall(context, db, false);
    }

    private void loadInstallXML() throws BirdException {
        InputStream is = null;
        try {
            is = ((Object)((Object)this)).getClass().getResourceAsStream("install.xml");
            SAXReader reader = new SAXReader();
            idoc = reader.read(is);
        }
        catch (Exception ex) {
            throw new BirdException("Could not read the install.xml", ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception ex) {
                throw new BirdException(ex);
            }
        }
    }

    static {
        p.put("name", "Self Service:Core");
        p.put("version", "3.6.2");
    }
}

