/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.ws.plain;

import java.io.Reader;
import java.io.StringReader;
import javax.annotation.Resource;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.servlet.ServletContext;
import javax.xml.ws.WebServiceContext;
import net.gopro.gdf.data.DocumentCollectionType;
import net.gopro.gdf.data.EntityCollectionType;
import net.gopro.gdf.data.InlineMetaDataCollectionType;
import net.gopro.gdf.data.PhaseType;
import net.gopro.gdf.data.RoutingSlipType;
import net.gopro.gdf.data.UserPrincipal;
import net.gopro.gdf.selfservice.ServiceFactory;
import net.gopro.gdf.services.plain.IWorkflowService;
import net.gopro.gdf.ws.util.ArrayUtils;
import net.gopro.gdf.ws.util.AuthenticationUtil;

@WebService(targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/", serviceName="WorkflowService", portName="WorkflowServiceSoap")
@SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
public class WorkflowService
implements IWorkflowService {
    private static final String GDF_NS = "http://gopro/gdf/workflowservice/2009/02/02/";
    @Resource
    protected WebServiceContext wsContext;

    @WebMethod(operationName="approveReview", action="http://gopro/gdf/workflowservice/2009/02/02/approveReview")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public void approveReview(@WebParam(name="routingSlipType", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/") String routingSlipType, @WebParam(name="comment", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/") String comment, @WebParam(name="response", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/") String response) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            net.gopro.gdf.selfservice.WorkflowService service = ServiceFactory.getWorkflowService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(routingSlipType);
            RoutingSlipType routingSlip = (RoutingSlipType)RoutingSlipType.unmarshalRoutingSlipType((Reader)reader);
            service.approveReview(routingSlip, comment, response);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="createRoutingSlips", action="http://gopro/gdf/workflowservice/2009/02/02/createRoutingSlips")
    @WebResult(name="createRoutingSlipsResult", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String createRoutingSlips(@WebParam(name="documentCollection", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/") String documentCollection, @WebParam(name="start", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/") boolean start) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            net.gopro.gdf.selfservice.WorkflowService service = ServiceFactory.getWorkflowService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(documentCollection);
            DocumentCollectionType coll = DocumentCollectionType.unmarshalDocumentCollectionType((Reader)reader);
            DocumentCollectionType results = service.createRoutingSlips(coll, start);
            return results.toXMLString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="createTasks", action="http://gopro/gdf/workflowservice/2009/02/02/createTasks")
    @WebResult(name="createTasksResult", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String createTasks(@WebParam(name="tasks", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/") String tasks) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            net.gopro.gdf.selfservice.WorkflowService service = ServiceFactory.getWorkflowService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(tasks);
            EntityCollectionType coll = EntityCollectionType.unmarshalEntityCollectionType((Reader)reader);
            String[] results = service.createTasks(coll);
            return ArrayUtils.convertStringArrayToString(results);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="getTaskInitiationData", action="http://gopro/gdf/workflowservice/2009/02/02/getTaskInitiationData")
    @WebResult(name="getTaskInitiationDataResult", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String getTaskInitiationData(@WebParam(name="associatedId", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/") String associatedId) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            net.gopro.gdf.selfservice.WorkflowService service = ServiceFactory.getWorkflowService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            EntityCollectionType taskInitiationData = service.getTaskInitiationData(associatedId);
            return taskInitiationData.toXMLString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="getWorkflowDefinitions", action="http://gopro/gdf/workflowservice/2009/02/02/getWorkflowDefinitions")
    @WebResult(name="getWorkflowDefinitionsResult", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String getWorkflowDefinitions() {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            net.gopro.gdf.selfservice.WorkflowService service = ServiceFactory.getWorkflowService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            InlineMetaDataCollectionType results = service.getWorkflowDefinitions();
            return results.toXMLString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="rejectReview", action="http://gopro/gdf/workflowservice/2009/02/02/rejectReview")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public void rejectReview(@WebParam(name="routingSlipType", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/") String routingSlipType, @WebParam(name="comment", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/") String comment) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            net.gopro.gdf.selfservice.WorkflowService service = ServiceFactory.getWorkflowService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(routingSlipType);
            RoutingSlipType routingSlip = (RoutingSlipType)RoutingSlipType.unmarshalRoutingSlipType((Reader)reader);
            service.rejectReview(routingSlip, comment);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="startCreatedRoutingSlip", action="http://gopro/gdf/workflowservice/2009/02/02/startCreatedRoutingSlip")
    @WebResult(name="startCreatedRoutingSlipResult", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String startCreatedRoutingSlip(@WebParam(name="routingForm", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/") String routingForm, @WebParam(name="parentID", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/") String parentID) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            net.gopro.gdf.selfservice.WorkflowService service = ServiceFactory.getWorkflowService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(routingForm);
            RoutingSlipType routingSlip = (RoutingSlipType)RoutingSlipType.unmarshalRoutingSlipType((Reader)reader);
            RoutingSlipType results = service.startCreatedRoutingSlip(routingSlip, parentID);
            return results.toXMLString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="updatePhaseStep", action="http://gopro/gdf/workflowservice/2009/02/02/updatePhaseStep")
    @WebResult(name="updatePhaseStepResult", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String updatePhaseStep(@WebParam(name="phaseType", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/") String phaseType, @WebParam(name="workflowID", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/") String workflowID, @WebParam(name="comment", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/") String comment, @WebParam(name="response", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/") String response, @WebParam(name="completePhaseStep", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/") boolean completePhaseStep) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            net.gopro.gdf.selfservice.WorkflowService service = ServiceFactory.getWorkflowService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(phaseType);
            PhaseType phase = (PhaseType)PhaseType.unmarshalPhaseType((Reader)reader);
            PhaseType results = service.updatePhaseStep(phase, workflowID, comment, response, completePhaseStep);
            return results.toXMLString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="updateRoutingSlips", action="http://gopro/gdf/workflowservice/2009/02/02/updateRoutingSlips")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public void updateRoutingSlips(@WebParam(name="documentCollection", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/") String documentCollection) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            net.gopro.gdf.selfservice.WorkflowService service = ServiceFactory.getWorkflowService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(documentCollection);
            DocumentCollectionType coll = DocumentCollectionType.unmarshalDocumentCollectionType((Reader)reader);
            service.updateRoutingSlips(coll);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="updateTasks", action="http://gopro/gdf/workflowservice/2009/02/02/updateTasks")
    @WebResult(name="updateTasksResult", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String updateTasks(@WebParam(name="tasks", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/") String tasks) {
        try {
            UserPrincipal principal = AuthenticationUtil.handleAuthentication(this.wsContext.getMessageContext());
            net.gopro.gdf.selfservice.WorkflowService service = ServiceFactory.getWorkflowService((ServletContext)this.getServletContext(), (UserPrincipal)principal);
            StringReader reader = new StringReader(tasks);
            EntityCollectionType coll = EntityCollectionType.unmarshalEntityCollectionType((Reader)reader);
            String[] results = service.updateTasks(coll);
            return ArrayUtils.convertStringArrayToString(results);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="createTaskTemplates", action="http://gopro/gdf/workflowservice/2009/02/02/createTaskTemplates")
    @WebResult(name="createTaskTemplatesResult", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String createTaskTemplates(String taskTemplates) {
        return null;
    }

    @WebMethod(operationName="getTaskTemplateInitiationData", action="http://gopro/gdf/workflowservice/2009/02/02/getTaskTemplateInitiationData")
    @WebResult(name="getTaskTemplateInitiationDataResult", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String getTaskTemplateInitiationData(String parentId) {
        return null;
    }

    @WebMethod(operationName="startPhases", action="http://gopro/gdf/workflowservice/2009/02/02/startPhases")
    @WebResult(name="startPhasesResult", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public void startPhases(String caseID, String phaseTemplateID) {
    }

    @WebMethod(operationName="updatePhaseSteps", action="http://gopro/gdf/workflowservice/2009/02/02/updatePhaseSteps")
    @WebResult(name="updatePhaseStepsResult", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public void updatePhaseSteps(String phase, String stepIDs) {
    }

    @WebMethod(operationName="updateTaskTemplates", action="http://gopro/gdf/workflowservice/2009/02/02/updateTaskTemplates")
    @WebResult(name="updateTaskTemplatesResult", targetNamespace="http://gopro/gdf/workflowservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String updateTaskTemplates(String taskTemplates) {
        return null;
    }

    private final ServletContext getServletContext() {
        return (ServletContext)this.wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.context");
    }
}

