/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.ws.plain;

import java.io.Reader;
import java.io.StringReader;
import javax.annotation.Resource;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.servlet.ServletContext;
import javax.xml.ws.WebServiceContext;
import net.gopro.gdf.data.BaseRefCollectionType;
import net.gopro.gdf.data.UserCredentialsType;
import net.gopro.gdf.data.UserPrincipal;
import net.gopro.gdf.data.UserPrivilegeCollectionType;
import net.gopro.gdf.selfservice.ServiceFactory;
import net.gopro.gdf.services.plain.ISecurityService;

@WebService(targetNamespace="http://gopro/gdf/securityservice/2009/02/02/", serviceName="SecurityService", portName="SecurityServiceSoap")
@SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
public class SecurityService
implements ISecurityService {
    private static final String GDF_NS = "http://gopro/gdf/securityservice/2009/02/02/";
    @Resource
    protected WebServiceContext wsContext;

    @WebMethod(operationName="authenticateUser", action="http://gopro/gdf/securityservice/2009/02/02/authenticateUser")
    @WebResult(name="authenticateUserResult", targetNamespace="http://gopro/gdf/securityservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String authenticateUser(@WebParam(name="credentials", targetNamespace="http://gopro/gdf/securityservice/2009/02/02/") String credentials) {
        try {
            StringReader reader = new StringReader(credentials);
            UserCredentialsType userCredentials = (UserCredentialsType)UserCredentialsType.unmarshalUserCredentialsType((Reader)reader);
            net.gopro.gdf.selfservice.SecurityService service = ServiceFactory.getSecurityService((ServletContext)this.getServletContext());
            UserPrincipal principal = service.authenticateUser(userCredentials);
            return principal.toXMLString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="closeUserSession", action="http://gopro/gdf/securityservice/2009/02/02/closeUserSession")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public void closeUserSession(@WebParam(name="token", targetNamespace="http://gopro/gdf/securityservice/2009/02/02/") String token) {
        try {
            net.gopro.gdf.selfservice.SecurityService service = ServiceFactory.getSecurityService((ServletContext)this.getServletContext());
            service.closeUserSession(token);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="getUserNamesList", action="http://gopro/gdf/securityservice/2009/02/02/getUserNamesList")
    @WebResult(name="getUserNamesListResult", targetNamespace="http://gopro/gdf/securityservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String getUserNamesList(@WebParam(name="userID", targetNamespace="http://gopro/gdf/securityservice/2009/02/02/") String userID) {
        try {
            net.gopro.gdf.selfservice.SecurityService service = ServiceFactory.getSecurityService((ServletContext)this.getServletContext());
            BaseRefCollectionType userNamesList = service.getUserNamesList(userID);
            return userNamesList.toXMLString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="getUserPrivileges", action="http://gopro/gdf/securityservice/2009/02/02/getUserPrivileges")
    @WebResult(name="getUserPrivilegesResult", targetNamespace="http://gopro/gdf/securityservice/2009/02/02/")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public String getUserPrivileges(@WebParam(name="userID", targetNamespace="http://gopro/gdf/securityservice/2009/02/02/") String userID) {
        try {
            net.gopro.gdf.selfservice.SecurityService service = ServiceFactory.getSecurityService((ServletContext)this.getServletContext());
            UserPrivilegeCollectionType userPrivileges = service.getUserPrivileges(userID);
            return userPrivileges.toXMLString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="hasAccess", action="http://gopro/gdf/securityservice/2009/02/02/hasAccess")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public void hasAccess(@WebParam(name="privileges", targetNamespace="http://gopro/gdf/securityservice/2009/02/02/") String privileges) {
        try {
            net.gopro.gdf.selfservice.SecurityService service = ServiceFactory.getSecurityService((ServletContext)this.getServletContext());
            StringReader reader = new StringReader(privileges);
            UserPrivilegeCollectionType privilegeCollectionType = UserPrivilegeCollectionType.unmarshalUserPrivilegeCollectionType((Reader)reader);
            service.hasAccess(privilegeCollectionType);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @WebMethod(operationName="setUserPassword", action="http://gopro/gdf/securityservice/2009/02/02/setUserPassword")
    @SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
    public void setUserPassword(@WebParam(name="oldPassword", targetNamespace="http://gopro/gdf/securityservice/2009/02/02/") String oldPassword, @WebParam(name="newPassword", targetNamespace="http://gopro/gdf/securityservice/2009/02/02/") String newPassword, @WebParam(name="newPasswordConfirm", targetNamespace="http://gopro/gdf/securityservice/2009/02/02/") String newPasswordConfirm) {
        try {
            net.gopro.gdf.selfservice.SecurityService service = ServiceFactory.getSecurityService((ServletContext)this.getServletContext());
            service.setUserPassword(oldPassword, newPassword, newPasswordConfirm);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private final ServletContext getServletContext() {
        return (ServletContext)this.wsContext.getMessageContext().get((Object)"javax.xml.ws.servlet.context");
    }
}

