/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.chunking;

import java.nio.ByteBuffer;
import net.gopro.gdf.chunking.ChunkSettings;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.DocumentCollectionType;
import net.gopro.gdf.data.EMailType;
import net.gopro.gdf.data.ExternalDocumentVersionType;
import net.gopro.gdf.data.FileAttachmentType;
import net.gopro.gdf.data.IVersionable;
import net.gopro.gdf.data.UserType;
import net.gopro.gdf.exceptions.GdfServiceException;
import org.apache.commons.lang.math.NumberUtils;

public class ChunkUtils {
    public static final boolean needsChunking(DocumentCollectionType documentCollection) throws GdfServiceException {
        long fileSize = 0L;
        if (documentCollection != null && documentCollection.getDocumentsCount() > 0) {
            for (DocumentBaseType document : documentCollection.getDocuments()) {
                UserType user;
                if (document instanceof IVersionable) {
                    IVersionable versionable = (IVersionable)document;
                    if (versionable.getCurrentVersion() == null || versionable.getCurrentVersion().getAttachment() == null) continue;
                    fileSize = versionable.getCurrentVersion().getAttachment().getFileSize();
                    continue;
                }
                if (document instanceof ExternalDocumentVersionType) {
                    ExternalDocumentVersionType version = (ExternalDocumentVersionType)document;
                    if (version.getAttachment() == null) continue;
                    fileSize = version.getAttachment().getFileSize();
                    continue;
                }
                if (document instanceof EMailType) {
                    EMailType emailDoc = (EMailType)document;
                    if (emailDoc.getAttachments() == null) continue;
                    for (FileAttachmentType fileattachment : emailDoc.getAttachments()) {
                        fileSize = NumberUtils.max((long[])new long[]{fileSize, fileattachment.getFileSize()});
                    }
                    continue;
                }
                if (!(document instanceof UserType) || (user = (UserType)document).getPhoto() == null) continue;
                fileSize = user.getPhoto().getFileSize();
            }
        }
        return fileSize != 0L && fileSize > (long)(1024 * ChunkSettings.getSendLimitSize());
    }

    public static final long getIdFromReference(byte[] referenceId) {
        if (referenceId == null) {
            throw new IllegalArgumentException("Reference Id is null");
        }
        if (referenceId.length != 21) {
            throw new IllegalArgumentException("Invalid reference size. Size is: " + referenceId.length);
        }
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.put(referenceId, 5, 8);
        buf.rewind();
        long documentId = buf.getLong();
        return documentId;
    }

    public static final long getSizeFromReference(byte[] referenceId) {
        if (referenceId == null) {
            throw new IllegalArgumentException("Reference Id is null");
        }
        if (referenceId.length != 21) {
            throw new IllegalArgumentException("Invalid reference size. Size is: " + referenceId.length);
        }
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.put(referenceId, 13, 8);
        buf.rewind();
        long size = buf.getLong();
        return size;
    }

    public static final byte[] createReferenceId(long crc, int transactionId, long size) {
        ByteBuffer buffer = ByteBuffer.allocate(21);
        buffer.put(ChunkSettings.GDFPreample);
        buffer.putInt((int)crc);
        buffer.putInt(transactionId);
        buffer.putLong(size);
        return buffer.array();
    }

    public static String getHexString(byte[] b) {
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }
}

