/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.chunking;

import java.util.Arrays;

public class ChunkSettings {
    public static final int CHUNK_REFERENCE_SIZE = 21;
    public static final byte[] GDFPreample = new byte[]{58, 103, 102, 116, 124};
    private static final int CHUNK_SEND_SIZE_LIMIT = 512;
    private static final int CHUNK_SEND_SIZE = 512;
    private static final int CHUNK_GET_SIZE = 256;

    public static int getSendLimitSize() {
        return 512;
    }

    public static int getUploadChunkSize() {
        return 512;
    }

    public static int getDownloadChunkSize() {
        return 256;
    }

    public static String getTempDirectory() {
        String tempdir = System.getProperty("java.io.tmpdir");
        if (!tempdir.endsWith("/") && !tempdir.endsWith("\\")) {
            tempdir = tempdir + System.getProperty("file.separator");
        }
        return tempdir;
    }

    public static boolean isChunkedData(byte[] data) {
        if (data != null && data.length > GDFPreample.length) {
            byte[] sizedData = Arrays.copyOf(data, GDFPreample.length);
            return Arrays.equals(GDFPreample, sizedData);
        }
        return false;
    }
}

