/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.ws.proxy;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.xml.wss.impl.misc.Base64;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.soap.SOAPBinding;
import net.gopro.gdf.chunking.ChunkSettings;
import net.gopro.gdf.chunking.ChunkUtils;
import net.gopro.gdf.data.Chunk;
import net.gopro.gdf.data.DocumentBaseType;
import net.gopro.gdf.data.DocumentCollectionType;
import net.gopro.gdf.data.DocumentFilterType;
import net.gopro.gdf.data.EMailType;
import net.gopro.gdf.data.EntityCollectionType;
import net.gopro.gdf.data.ExternalDocumentType;
import net.gopro.gdf.data.ExternalDocumentVersionType;
import net.gopro.gdf.data.FileAttachmentType;
import net.gopro.gdf.data.FlexibleDataSetType;
import net.gopro.gdf.data.FormDocumentTemplateType;
import net.gopro.gdf.data.InlineMetaDataCollectionType;
import net.gopro.gdf.data.UserType;
import net.gopro.gdf.data.types.DocumentDownloadFormatType;
import net.gopro.gdf.data.types.DocumentStateType;
import net.gopro.gdf.exceptions.GdfServiceException;
import net.gopro.gdf.services.IBaseDocumentService;
import net.gopro.gdf.ws.handlers.CertStoreHandler;
import net.gopro.gdf.ws.handlers.DominoAxisHandler;
import net.gopro.gdf.ws.handlers.LoggingHandler;
import net.gopro.gdf.ws.proxy.plain.basedocument.BaseDocumentService;
import net.gopro.gdf.ws.proxy.plain.basedocument.BaseDocumentService_Service;
import net.gopro.gdf.ws.util.ArrayUtils;
import net.gopro.util.ChunkUtil;
import net.gopro.util.ChunkingException;

public class DocumentService
implements IBaseDocumentService {
    private static final Logger logger;
    private static final QName qname;
    private BaseDocumentService_Service proxy;
    private BaseDocumentService stub;
    private boolean debug = false;
    private File certificate;
    private File privateKey;
    private static final URL wsdlUrl;

    public DocumentService(String endpoint, String username, String password) {
        this.initializeService(endpoint, username, password);
    }

    public DocumentService(String endpoint, String username, String password, File x509certificate, File privateKey) {
        this.certificate = x509certificate;
        this.privateKey = privateKey;
        this.initializeService(endpoint, username, password);
    }

    public DocumentService(String endpoint, String username, String password, boolean debug) {
        this.debug = debug;
        this.initializeService(endpoint, username, password);
    }

    private void initializeService(String endpoint, String username, String password) {
        this.proxy = new BaseDocumentService_Service(wsdlUrl, qname);
        this.stub = this.proxy.getBaseDocumentServiceSoap();
        ((BindingProvider)this.stub).getRequestContext().put("javax.xml.ws.service.endpoint.address", endpoint);
        ((BindingProvider)this.stub).getRequestContext().put("javax.xml.ws.security.auth.username", username);
        ((BindingProvider)this.stub).getRequestContext().put("javax.xml.ws.security.auth.password", password);
        ArrayList<Object> chain = new ArrayList<Object>();
        try {
            if (this.certificate != null && this.privateKey != null) {
                PrivateKey key = this.loadKey(this.privateKey);
                X509Certificate cert = this.loadX509Certificate(this.certificate);
                chain.add(new CertStoreHandler(cert, key));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        if (this.debug) {
            chain.add(new LoggingHandler());
        }
        if (endpoint.toLowerCase().contains(".nsf")) {
            chain.add(new DominoAxisHandler());
        }
        ((BindingProvider)this.stub).getBinding().setHandlerChain(chain);
        SOAPBinding binding = (SOAPBinding)((BindingProvider)this.stub).getBinding();
        binding.setMTOMEnabled(true);
        ((BindingProvider)this.stub).getRequestContext().put("com.sun.xml.ws.connect.timeout", 120000);
        ((BindingProvider)this.stub).getRequestContext().put("com.sun.xml.ws.request.timeout", 300000);
    }

    public String[] copyDocuments(DocumentFilterType filter, String destinationId) throws GdfServiceException {
        try {
            String res = this.stub.copyDocuments(filter.toXMLString(), destinationId);
            return ArrayUtils.deserializeStringArray(res);
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public void createChunk(Chunk chunk) throws GdfServiceException {
        try {
            if (chunk.getChunkNumber() == 0) {
                long transactionId = this.stub.putChunk((int)chunk.getCRC(), chunk.getData(), chunk.getChunkNumber(), chunk.getChunksCount(), -1);
                chunk.setChunksStackId(transactionId);
            } else if (chunk.getChunksStackId() != -1L) {
                this.stub.putChunk((int)chunk.getCRC(), chunk.getData(), chunk.getChunkNumber(), chunk.getChunksCount(), (int)chunk.getChunksStackId());
            }
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public String[] createDocuments(DocumentCollectionType documentCollection) throws GdfServiceException {
        try {
            if (ChunkUtils.needsChunking((DocumentCollectionType)documentCollection)) {
                logger.info("Document Collection needs chunking.");
                this.chunkDocumentCollection(documentCollection);
            }
            String res = this.stub.createDocuments(documentCollection.toXMLString());
            return ArrayUtils.deserializeStringArray(res);
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public String[] createDocumentsCheckin(DocumentCollectionType documentCollection, boolean autoCheckin) throws GdfServiceException {
        try {
            if (ChunkUtils.needsChunking((DocumentCollectionType)documentCollection)) {
                logger.info("Document Collection needs chunking.");
                this.chunkDocumentCollection(documentCollection);
            }
            String res = this.stub.createDocumentsCheckin(documentCollection.toXMLString(), autoCheckin);
            return ArrayUtils.deserializeStringArray(res);
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public void deleteDocuments(DocumentFilterType filter) throws GdfServiceException {
        try {
            this.stub.deleteDocuments(filter.toXMLString());
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public void destroyDocuments(DocumentFilterType filter) throws GdfServiceException {
        try {
            this.stub.destroyDocuments(filter.toXMLString());
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public byte[] getChunk(long id, int chunkNumber, int chunkSize) throws GdfServiceException {
        try {
            byte[] bytes = this.stub.getChunk(id, chunkNumber, chunkSize);
            return bytes;
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public FlexibleDataSetType getDocumentHeaders(DocumentFilterType filter) throws GdfServiceException {
        try {
            String result = this.stub.getDocumentHeaders(filter.toXMLString());
            StringReader reader = new StringReader(result);
            return FlexibleDataSetType.unmarshalFlexibleDataSetType((Reader)reader);
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public DocumentCollectionType getDocumentInitiationData(String parentId, int documentType, String templateId) throws GdfServiceException {
        try {
            String result = this.stub.getDocumentInitiationData(parentId, documentType, templateId);
            StringReader reader = new StringReader(result);
            DocumentCollectionType dc = DocumentCollectionType.unmarshalDocumentCollectionType((Reader)reader);
            this.populateAttachments(dc);
            return dc;
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public InlineMetaDataCollectionType getDocumentRelatedData(String documentId, int documentType) throws GdfServiceException {
        try {
            String result = this.stub.getDocumentRelatedData(documentId, documentType);
            StringReader reader = new StringReader(result);
            return InlineMetaDataCollectionType.unmarshalInlineMetaDataCollectionType((Reader)reader);
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public EntityCollectionType getEntities(DocumentFilterType filter) throws GdfServiceException {
        try {
            String result = this.stub.getEntities(filter.toXMLString());
            StringReader reader = new StringReader(result);
            return EntityCollectionType.unmarshalEntityCollectionType((Reader)reader);
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public DocumentBaseType getDocumentVersion(DocumentFilterType filter) throws GdfServiceException {
        try {
            String result = this.stub.getDocumentVersion(filter.toXMLString());
            StringReader reader = new StringReader(result);
            return (DocumentBaseType)DocumentBaseType.unmarshalDocumentBaseType((Reader)reader);
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public FlexibleDataSetType getDocumentVersionList(DocumentFilterType filter) throws GdfServiceException {
        try {
            String result = this.stub.getDocumentVersionList(filter.toXMLString());
            StringReader reader = new StringReader(result);
            return FlexibleDataSetType.unmarshalFlexibleDataSetType((Reader)reader);
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public DocumentCollectionType getDocuments(DocumentFilterType filter, DocumentStateType documentStateSet) throws GdfServiceException {
        try {
            String result = this.stub.getDocuments(filter.toXMLString(), documentStateSet.toString());
            StringReader reader = new StringReader(result);
            DocumentCollectionType dc = DocumentCollectionType.unmarshalDocumentCollectionType((Reader)reader);
            if (filter.getLoadBinaryData()) {
                this.populateAttachments(dc);
            }
            return dc;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new GdfServiceException((Throwable)e);
        }
    }

    public FileAttachmentType[] getReadOnlyFormats(String[] documentIDs) throws GdfServiceException {
        throw new RuntimeException("Method is not implemented.");
    }

    public void restoreDocuments(DocumentFilterType filter) throws GdfServiceException {
        try {
            this.stub.restoreDocuments(filter.toXMLString());
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public String[] setDocumentsState(DocumentFilterType filter, DocumentStateType state) throws GdfServiceException {
        try {
            String res = this.stub.setDocumentsState(filter.toXMLString(), state.toString());
            return ArrayUtils.deserializeStringArray(res);
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public void updateDocumentFields(DocumentFilterType filter, DocumentBaseType documentPattern, String[] propertylist) throws GdfServiceException {
        try {
            this.stub.updateDocumentFields(filter.toXMLString(), documentPattern.toXMLString(), ArrayUtils.serialize(propertylist));
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public String[] updateDocuments(DocumentCollectionType documentCollection, boolean newVersion, DocumentStateType documentStateSet) throws GdfServiceException {
        try {
            String res = this.stub.updateDocuments(documentCollection.toXMLString(), newVersion, documentStateSet.toString());
            return ArrayUtils.deserializeStringArray(res);
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public String[] moveDocuments(DocumentFilterType filter, String destinationId) throws GdfServiceException {
        try {
            String res = this.stub.moveDocuments(filter.toXMLString(), destinationId);
            return ArrayUtils.deserializeStringArray(res);
        }
        catch (Exception e) {
            throw new GdfServiceException((Throwable)e);
        }
    }

    public int putChunk(int arg0, byte[] arg1, int arg2, int arg3, int arg4) throws GdfServiceException {
        return 0;
    }

    public List<HashMap<String, Object>> getDocumentEvents(String[] ids, int documentType, int start, int size) throws GdfServiceException {
        throw new GdfServiceException("Absurd method which is not implemented.");
    }

    public FileAttachmentType getDownloadDocument(String documentId, DocumentDownloadFormatType format, String attachmentId) throws GdfServiceException {
        throw new GdfServiceException("Method not implemented");
    }

    private void chunkDocumentCollection(DocumentCollectionType documentCollection) throws GdfServiceException {
        if (documentCollection != null && documentCollection.getDocumentsCount() > 0) {
            for (DocumentBaseType baseDoc : documentCollection.getDocuments()) {
                EMailType emailDoc;
                if (baseDoc instanceof ExternalDocumentType) {
                    try {
                        ExternalDocumentType exDoc = (ExternalDocumentType)baseDoc;
                        long iSize = exDoc.getCurrentVersion().getAttachment().getFileSize();
                        if (iSize <= (long)(1024 * ChunkSettings.getSendLimitSize())) continue;
                        FileAttachmentType ft = exDoc.getCurrentVersion().getAttachment();
                        byte[] referenceId = this.chunkAttachment(ft);
                        ft.setStream(referenceId);
                    }
                    catch (NullPointerException exDoc) {}
                    continue;
                }
                if (!(baseDoc instanceof EMailType) || (emailDoc = (EMailType)baseDoc).getAttachmentsCount() <= 0) continue;
                for (FileAttachmentType fileType : emailDoc.getAttachments()) {
                    if (fileType.getFileSize() <= (long)(1024 * ChunkSettings.getSendLimitSize())) continue;
                    try {
                        byte[] referenceId = this.chunkAttachment(fileType);
                        fileType.setStream(referenceId);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private final synchronized void populateAttachments(DocumentCollectionType coll) throws GdfServiceException {
        for (DocumentBaseType basedoc : coll.getDocuments()) {
            ExternalDocumentVersionType version;
            ByteBuffer buffer;
            long chunksize;
            if (basedoc instanceof ExternalDocumentType) {
                ExternalDocumentType exdoc = (ExternalDocumentType)basedoc;
                if (exdoc.getCurrentVersion() == null) {
                    logger.warning(String.format("No current version is present on the ExternalDocumentType %s.", exdoc.getSubject()));
                    continue;
                }
                FileAttachmentType ft = exdoc.getCurrentVersion().getAttachment();
                if (ft == null || ft.getStream() == null || ft.getStream().length != 21) continue;
                ByteBuffer matchBuffer = ByteBuffer.allocate(ChunkSettings.GDFPreample.length);
                matchBuffer.put(ft.getStream(), 0, ChunkSettings.GDFPreample.length);
                String hexPreample = ChunkUtils.getHexString((byte[])ChunkSettings.GDFPreample);
                String hexCurrent = ChunkUtils.getHexString((byte[])matchBuffer.array());
                if (!hexPreample.equals(hexCurrent)) continue;
                long streamId = ChunkUtils.getIdFromReference((byte[])ft.getStream());
                long streamSize = ChunkUtils.getSizeFromReference((byte[])ft.getStream());
                long chunksize2 = 1024 * ChunkSettings.getDownloadChunkSize();
                int chunkCount = (int)(streamSize / chunksize2);
                if ((long)((int)streamSize) % chunksize2 > 0L) {
                    ++chunkCount;
                }
                ByteBuffer buffer2 = ByteBuffer.allocate((int)streamSize);
                for (int i = 0; i < chunkCount; ++i) {
                    byte[] chunk = this.getChunk(streamId, i, (int)chunksize2);
                    if (chunk == null) {
                        throw new GdfServiceException(String.format("Chunk stream is null. Doc: \"%s\" (%s)", basedoc.getSubject(), basedoc.getID()));
                    }
                    buffer2.put(chunk);
                }
                ft.setStream(buffer2.array());
                buffer2.clear();
                continue;
            }
            if (basedoc instanceof ExternalDocumentVersionType) {
                ExternalDocumentVersionType version2 = (ExternalDocumentVersionType)basedoc;
                if (version2.getAttachment() == null || !ChunkSettings.isChunkedData((byte[])version2.getAttachment().getStream())) continue;
                long streamId = ChunkUtils.getIdFromReference((byte[])version2.getAttachment().getStream());
                long streamSize = ChunkUtils.getSizeFromReference((byte[])version2.getAttachment().getStream());
                chunksize = 1024 * ChunkSettings.getDownloadChunkSize();
                int chunkCount = (int)(streamSize / chunksize);
                if ((long)((int)streamSize) % chunksize > 0L) {
                    ++chunkCount;
                }
                buffer = ByteBuffer.allocate((int)streamSize);
                for (int i = 0; i < chunkCount; ++i) {
                    byte[] chunk = this.getChunk(streamId, i, (int)chunksize);
                    if (chunk == null) {
                        throw new GdfServiceException(String.format("Chunk stream is null. Doc: \"%s\" (%s)", basedoc.getSubject(), basedoc.getID()));
                    }
                    buffer.put(chunk);
                }
                version2.getAttachment().setStream(buffer.array());
                buffer.clear();
                continue;
            }
            if (basedoc instanceof EMailType) {
                for (FileAttachmentType attachment : ((EMailType)basedoc).getAttachments()) {
                    if (!ChunkSettings.isChunkedData((byte[])attachment.getStream())) continue;
                    long streamId = ChunkUtils.getIdFromReference((byte[])attachment.getStream());
                    long streamSize = ChunkUtils.getSizeFromReference((byte[])attachment.getStream());
                    long chunksize3 = 1024 * ChunkSettings.getDownloadChunkSize();
                    int chunkCount = (int)(streamSize / chunksize3);
                    if ((long)((int)streamSize) % chunksize3 > 0L) {
                        ++chunkCount;
                    }
                    ByteBuffer buffer3 = ByteBuffer.allocate((int)streamSize);
                    for (int i = 0; i < chunkCount; ++i) {
                        byte[] chunk = this.getChunk(streamId, i, (int)chunksize3);
                        if (chunk == null) {
                            throw new GdfServiceException(String.format("Chunk stream is null. Doc: \"%s\" (%s)", basedoc.getSubject(), basedoc.getID()));
                        }
                        buffer3.put(chunk);
                    }
                    attachment.setStream(buffer3.array());
                    buffer3.clear();
                }
                continue;
            }
            if (basedoc instanceof UserType) {
                if (((UserType)basedoc).getPhoto() == null || !ChunkSettings.isChunkedData((byte[])((UserType)basedoc).getPhoto().getStream())) continue;
                long streamId = ChunkUtils.getIdFromReference((byte[])((UserType)basedoc).getPhoto().getStream());
                long streamSize = ChunkUtils.getSizeFromReference((byte[])((UserType)basedoc).getPhoto().getStream());
                long chunksize4 = 1024 * ChunkSettings.getDownloadChunkSize();
                int chunkCount = (int)(streamSize / chunksize4);
                if ((long)((int)streamSize) % chunksize4 > 0L) {
                    ++chunkCount;
                }
                ByteBuffer buffer4 = ByteBuffer.allocate((int)streamSize);
                for (int i = 0; i < chunkCount; ++i) {
                    byte[] chunk = this.getChunk(streamId, i, (int)chunksize4);
                    if (chunk == null) {
                        throw new GdfServiceException(String.format("Chunk stream is null. Doc: \"%s\" (%s)", basedoc.getSubject(), basedoc.getID()));
                    }
                    buffer4.put(chunk);
                }
                ((UserType)basedoc).getPhoto().setStream(buffer4.array());
                buffer4.clear();
                continue;
            }
            if (!(basedoc instanceof FormDocumentTemplateType) || (version = ((FormDocumentTemplateType)basedoc).getCurrentVersion()).getAttachment() == null || !ChunkSettings.isChunkedData((byte[])version.getAttachment().getStream())) continue;
            long streamId = ChunkUtils.getIdFromReference((byte[])version.getAttachment().getStream());
            long streamSize = ChunkUtils.getSizeFromReference((byte[])version.getAttachment().getStream());
            chunksize = 1024 * ChunkSettings.getDownloadChunkSize();
            int chunkCount = (int)(streamSize / chunksize);
            if ((long)((int)streamSize) % chunksize > 0L) {
                ++chunkCount;
            }
            buffer = ByteBuffer.allocate((int)streamSize);
            for (int i = 0; i < chunkCount; ++i) {
                byte[] chunk = this.getChunk(streamId, i, (int)chunksize);
                if (chunk == null) {
                    throw new GdfServiceException(String.format("Chunk stream is null. Doc: \"%s\" (%s)", basedoc.getSubject(), basedoc.getID()));
                }
                buffer.put(chunk);
            }
            version.getAttachment().setStream(buffer.array());
            buffer.clear();
        }
    }

    private final synchronized byte[] chunkAttachment(FileAttachmentType file) throws GdfServiceException {
        try {
            int transactionId = 0;
            byte[] referenceId = null;
            if (file != null && file.getStream() != null && file.getStream().length > 0) {
                ChunkUtil chunker = new ChunkUtil(ChunkSettings.getTempDirectory());
                int streamSize = file.getStream().length;
                long crcChunkId = chunker.chunkStream(file.getStream());
                long chunksize = 1024 * ChunkSettings.getUploadChunkSize();
                int chunkCount = (int)Math.ceil((long)streamSize / chunksize);
                logger.info("CRC: " + crcChunkId + " chunkCount: " + chunkCount);
                for (int i = 0; i <= chunkCount; ++i) {
                    Chunk chunk = chunker.getChunk(crcChunkId, i, (int)chunksize);
                    chunk.setChunksStackId(crcChunkId);
                    if (chunk.getChunkNumber() == 0) {
                        transactionId = this.stub.putChunk((int)chunk.getCRC(), chunk.getData(), chunk.getChunkNumber(), chunk.getChunksCount(), -1);
                        if (transactionId == -1) {
                            transactionId = 1;
                        }
                        logger.info("Transaction ID from Service: " + transactionId);
                        continue;
                    }
                    if (transactionId == 0) {
                        throw new RuntimeException("Chunks are being sent in incorrect order!");
                    }
                    this.stub.putChunk((int)chunk.getCRC(), chunk.getData(), chunk.getChunkNumber(), chunk.getChunksCount(), transactionId);
                }
                referenceId = ChunkUtils.createReferenceId((long)crcChunkId, (int)transactionId, (long)streamSize);
            }
            return referenceId;
        }
        catch (IOException ex) {
            throw new GdfServiceException("Error creating chunk file!", (Throwable)ex);
        }
        catch (ChunkingException ex) {
            throw new GdfServiceException("Error fething chunk part!", (Throwable)ex);
        }
    }

    private X509Certificate loadX509Certificate(File certificate) throws GeneralSecurityException, IOException {
        CertificateFactory factory = CertificateFactory.getInstance("X509");
        return (X509Certificate)factory.generateCertificate(new FileInputStream(certificate));
    }

    private PrivateKey loadKey(File keyfile) throws IOException, GeneralSecurityException {
        String line;
        StringBuilder keyBuf = new StringBuilder();
        BufferedReader br = new BufferedReader(new FileReader(keyfile));
        while ((line = br.readLine()) != null) {
            if (line.startsWith("-----") || line.endsWith("-----")) continue;
            keyBuf.append(line);
        }
        br.close();
        try {
            PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(Base64.decode((String)keyBuf.toString()));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(privKeySpec);
        }
        catch (Base64DecodingException ex) {
            IOException x = new IOException("Invalid key file");
            x.initCause(ex);
            throw x;
        }
    }

    static {
        URL url;
        logger = Logger.getLogger(DocumentService.class.getName());
        qname = new QName("http://gopro/gdf/basedocumentservice/2009/02/02/", "BaseDocumentService");
        wsdlUrl = url = DocumentService.class.getResource("/META-INF/wsdl/BaseDocumentService.wsdl");
    }
}

