/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.ws.handlers;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class LoggingHandler
implements SOAPHandler<SOAPMessageContext> {
    private PrintStream out;

    public LoggingHandler() {
        this.setLogStream(System.out);
    }

    protected final void setLogStream(PrintStream ps) {
        this.out = ps;
    }

    public void init(Map c) {
        System.out.println("LoggingHandler : init() Called....");
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public boolean handleMessage(SOAPMessageContext smc) {
        System.out.println("LoggingHandler : handleMessage Called....");
        this.logToSystemOut(smc);
        return true;
    }

    public boolean handleFault(SOAPMessageContext smc) {
        System.out.println("LoggingHandler : handleFault Called....");
        this.logToSystemOut(smc);
        return true;
    }

    public void close(MessageContext messageContext) {
        System.out.println("LoggingHandler : close() Called....");
    }

    public void destroy() {
        System.out.println("LoggingHandler : destroy() Called....");
    }

    protected void logToSystemOut(SOAPMessageContext smc) {
        Boolean outboundProperty = (Boolean)smc.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outboundProperty.booleanValue()) {
            this.out.println("\nOutbound message:");
        } else {
            this.out.println("\nInbound message:");
        }
        SOAPMessage message = smc.getMessage();
        try {
            message.writeTo((OutputStream)this.out);
            this.out.println();
        }
        catch (Exception e) {
            this.out.println("Exception in handler: " + e);
        }
    }
}

