/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.ws.handlers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class DominoAxisHandler
implements SOAPHandler<SOAPMessageContext> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleMessage(SOAPMessageContext context) {
        Boolean isRequest = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
        if (isRequest == false) return true;
        try {
            SOAPMessage soapMsg = context.getMessage();
            URL url = new URL(context.get((Object)"javax.xml.ws.service.endpoint.address") + "");
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost connection = new HttpPost(url.toURI());
            CloseableHttpResponse response = null;
            try {
                if (connection == null) return true;
                connection.addHeader("Content-Type", "text/xml;charset=UTF-8");
                connection.addHeader("Content-Language", "sq-AL");
                connection.addHeader("Content-Transfer-Encoding", "binary");
                connection.addHeader("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.3");
                connection.addHeader("SOAPAction", context.get((Object)"javax.xml.ws.wsdl.operation") + "");
                if (context.get((Object)"javax.xml.ws.security.auth.username") != null) {
                    String authorization = Base64.encodeBase64String((byte[])(context.get((Object)"javax.xml.ws.security.auth.username") + ":" + context.get((Object)"javax.xml.ws.security.auth.password")).getBytes());
                    connection.addHeader("Authorization", "Basic " + authorization);
                }
                connection.setEntity((HttpEntity)new StringEntity(this.toString(soapMsg)));
                response = httpclient.execute((HttpUriRequest)connection);
                int statusCode = response.getStatusLine().getStatusCode();
                String resultBuffer = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                context.setMessage(this.getSoapMessageFromString(resultBuffer));
                boolean bl = false;
                return bl;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                throw ex;
            }
            finally {
                if (response != null) {
                    response.close();
                }
                httpclient.close();
            }
        }
        catch (SOAPException ex) {
            System.err.println((Object)ex);
            return false;
        }
        catch (IOException ex) {
            System.err.println(ex);
            return false;
        }
        catch (URISyntaxException ex) {
            System.err.println(ex);
            return false;
        }
    }

    private SOAPMessage getSoapMessageFromString(String xml) throws SOAPException, IOException {
        MessageFactory factory = MessageFactory.newInstance();
        SOAPMessage message = factory.createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(xml.getBytes(Charset.forName("UTF-8"))));
        return message;
    }

    private String toString(SOAPMessage message) throws SOAPException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        message.writeTo((OutputStream)out);
        return out.toString("UTF-8");
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }

    public Set<QName> getHeaders() {
        return null;
    }
}

