/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.gdf.ws.handlers;

import com.sun.xml.wss.impl.callback.CertStoreCallback;
import com.sun.xml.wss.impl.callback.KeyStoreCallback;
import com.sun.xml.wss.impl.callback.PrivateKeyCallback;
import com.sun.xml.wss.impl.callback.SignatureKeyCallback;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public class CertStoreCallbackHandler
implements CallbackHandler {
    private PrivateKey privateKey = null;
    private X509Certificate certificate = null;

    public CertStoreCallbackHandler() {
    }

    public CertStoreCallbackHandler(PrivateKey privateKey, X509Certificate certificate) {
        this.privateKey = privateKey;
        this.certificate = certificate;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks[0] instanceof CertStoreCallback) {
            return;
        }
        if (callbacks[0] instanceof KeyStoreCallback) {
            this.handle((KeyStoreCallback)callbacks[0]);
            return;
        }
        if (callbacks[0] instanceof SignatureKeyCallback) {
            this.handle((SignatureKeyCallback)callbacks[0]);
            return;
        }
        if (callbacks[0] instanceof PrivateKeyCallback) {
            this.handle((PrivateKeyCallback)callbacks[0]);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void handle(SignatureKeyCallback sk) throws IOException {
        SignatureKeyCallback.Request r = sk.getRequest();
        if (r instanceof SignatureKeyCallback.PrivKeyCertRequest) {
            SignatureKeyCallback.PrivKeyCertRequest pkcr = (SignatureKeyCallback.PrivKeyCertRequest)r;
            pkcr.setPrivateKey(this.privateKey);
            pkcr.setX509Certificate(this.certificate);
            return;
        }
        throw new UnsupportedOperationException();
    }

    private void handle(PrivateKeyCallback pkc) throws IOException {
        pkc.setKey(this.privateKey);
    }

    private void handle(KeyStoreCallback ksc) throws IOException {
        try {
            KeyStore ks = KeyStore.getInstance("jks");
            ks.load(null, null);
            ks.setKeyEntry("default", this.privateKey, new char[0], new Certificate[]{this.certificate});
            ksc.setKeystore(ks);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

