/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util.json;

import java.lang.reflect.Method;
import java.util.List;
import net.gopro.gdf.data.BaseRefProtoType;
import net.gopro.gdf.data.ObjectBaseType;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.map.introspect.VisibilityChecker;

public class VisibilityController
extends VisibilityChecker.Std {
    public VisibilityController(JsonAutoDetect arg0) {
        super(arg0);
    }

    public VisibilityController(JsonAutoDetect.Visibility getter, JsonAutoDetect.Visibility isGetter, JsonAutoDetect.Visibility setter, JsonAutoDetect.Visibility creator, JsonAutoDetect.Visibility field) {
        super(getter, isGetter, setter, creator, field);
    }

    public VisibilityController(JsonAutoDetect.Visibility arg0) {
        super(arg0);
    }

    public boolean isGetterVisible(Method method) {
        if (method.getName().endsWith("AsReference")) {
            return false;
        }
        if (method.getName().endsWith("Photo")) {
            return false;
        }
        if (this.ignoreMethodFromClass(method, BaseRefProtoType.class)) {
            return false;
        }
        if (this.ignoreMethodFromClass(method, ObjectBaseType.class)) {
            return false;
        }
        return super.isGetterVisible(method);
    }

    private boolean ignoreMethodFromClass(Method method, Class<?> clazz) {
        if ("getID".equals(method.getName()) || "setID".equals(method.getName())) {
            return false;
        }
        for (Method clazzMethod : clazz.getDeclaredMethods()) {
            if (!clazzMethod.getName().equals(method.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isSetterVisible(Method method) {
        if (List.class.isAssignableFrom(method.getParameterTypes()[0])) {
            return false;
        }
        if (method.getName().endsWith("Photo")) {
            return false;
        }
        if (this.ignoreMethodFromClass(method, BaseRefProtoType.class)) {
            return false;
        }
        if (this.ignoreMethodFromClass(method, ObjectBaseType.class)) {
            return false;
        }
        return super.isSetterVisible(method);
    }
}

