/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util.datastructures;

import java.util.Hashtable;
import org.apache.log4j.Logger;

public abstract class DuplexMap {
    private static Logger logger = Logger.getLogger(DuplexMap.class);
    protected Hashtable internalToExternal;
    protected Hashtable externalToInternal;

    public DuplexMap() {
        this.recreateMappings();
    }

    public void recreateMappings() {
        this.internalToExternal = new Hashtable();
        this.externalToInternal = new Hashtable();
        this.initMappings();
    }

    protected void initMappings() {
    }

    protected String getInternalKey(String externalKey) {
        return (String)this.externalToInternal.get(externalKey);
    }

    protected String getExternalKey(String internalKey) {
        return (String)this.internalToExternal.get(internalKey);
    }

    protected boolean hasInternalKey(String internalKey) {
        String key = (String)this.internalToExternal.get(internalKey);
        return key != null;
    }

    protected boolean hasExternalKey(String externalKey) {
        String key = (String)this.externalToInternal.get(externalKey);
        return key != null;
    }

    protected void addMapping(String externalKey, String internalKey) {
        this.addMapping(externalKey, internalKey, true, false);
    }

    protected void addMapping(String externalKey, String internalKey, boolean checkForOverride) {
        this.addMapping(externalKey, internalKey, checkForOverride, false);
    }

    protected void addMapping(String externalKey, String internalKey, boolean checkForOverride, boolean ignoreDuplicates) {
        String error = "";
        String existingKey = (String)this.externalToInternal.get(externalKey);
        if (checkForOverride && existingKey != null) {
            if (!ignoreDuplicates) {
                error = error + "[" + this.getClass().getName() + "]\nThere is already defined mapping for /externalKey = internalKey/ \nexisting mapping: " + externalKey + " = " + existingKey + "\nattemt to override with: " + externalKey + " = " + internalKey;
            }
        } else {
            this.externalToInternal.put(externalKey, internalKey);
        }
        existingKey = (String)this.internalToExternal.get(internalKey);
        if (checkForOverride && existingKey != null) {
            if (!ignoreDuplicates) {
                error = error + "[" + this.getClass().getName() + "]\nThere is already defined mapping for /internalKey = externalKey/ \nexisting mapping:" + internalKey + " = " + existingKey + "\nattemt to override with:" + internalKey + " = " + internalKey;
            }
        } else {
            this.internalToExternal.put(internalKey, externalKey);
        }
        if (error.length() > 0) {
            logger.debug((Object)error);
        }
    }
}

