/*
 * Decompiled with CFR 0.152.
 */
package net.gopro.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import net.gopro.util.AttachmentStoreUtil;
import net.gopro.util.Utils;

class TempFile
extends File {
    private static final long serialVersionUID = 1L;
    private String fileName;

    public TempFile(String fileName) {
        super(fileName);
        this.fileName = fileName;
        AttachmentStoreUtil.registerFileReference(fileName);
    }

    protected void finalize() throws IOException {
        AttachmentStoreUtil.unregisterFileReference(this.fileName);
        try {
            super.finalize();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compareTo(File secondFile) {
        if (AttachmentStoreUtil.isPerformContentCompare()) {
            try {
                FileInputStream ownIn = new FileInputStream(this);
                FileInputStream secondIn = new FileInputStream(secondFile);
                ByteArrayOutputStream ownBuff = new ByteArrayOutputStream(((InputStream)ownIn).available());
                ByteArrayOutputStream secondBuff = new ByteArrayOutputStream(((InputStream)secondIn).available());
                Utils.writeStream(ownIn, ownBuff);
                Utils.writeStream(secondIn, secondBuff);
                boolean equal = Arrays.equals(ownBuff.toByteArray(), secondBuff.toByteArray());
                return equal ? 0 : 1;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return super.compareTo(secondFile);
    }

    @Override
    public String toString() {
        return "TEMP FILE[ " + this.fileName + " ]";
    }
}

